/*
 * Decompiled with CFR 0.152.
 */
package com.countrygamer.core.blocks.tile;

import com.countrygamer.core.Base.block.tiles.TileEntityInventoryBase;
import com.countrygamer.core.CraftingSystem.DiagramRecipes;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileEntityDiagram
extends TileEntityInventoryBase {
    private DiagramRecipes.Recipe recipe;
    public boolean finishedCrafting = false;

    public TileEntityDiagram() {
        super("Diagram", 0, 1);
    }

    public DiagramRecipes.Recipe getRecipe() {
        return this.recipe;
    }

    public boolean setRecipe(String blockName) {
        if (DiagramRecipes.recipeList.containsKey(blockName)) {
            this.recipe = DiagramRecipes.recipeList.get(blockName);
            this.checkInventorySizeWithRecipe(this.recipe);
            return true;
        }
        return false;
    }

    private void checkInventorySizeWithRecipe(DiagramRecipes.Recipe recipe) {
        int recipeSize = recipe.getNeededSizeOfInventory();
        if (this.inv.length != recipeSize) {
            int i;
            ItemStack[] currentInv = new ItemStack[this.inv.length];
            for (i = 0; i < this.inv.length; ++i) {
                currentInv[i] = this.inv[i];
            }
            this.inv = new ItemStack[recipeSize];
            for (i = 0; i < recipeSize; ++i) {
                if (i >= currentInv.length) continue;
                this.inv[i] = currentInv[i];
            }
        }
    }

    @Override
    public void func_145845_h() {
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemStack) {
        super.func_70299_a(slot, itemStack);
        boolean finished = true;
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.func_70301_a(i) != null) continue;
            finished = false;
            break;
        }
        if (finished && this.recipe != null) {
            this.finishedCrafting = true;
            this.func_145831_w().func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.recipe.outputBlock, this.recipe.blockMetadata, 3);
            if (this.func_145831_w().func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this) {
                this.func_145831_w().func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, null);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCom) {
        super.func_145841_b(tagCom);
        tagCom.func_74757_a("finishedCrafting", this.finishedCrafting);
        if (this.recipe != null) {
            NBTTagCompound recipeTagCom = new NBTTagCompound();
            this.recipe.writeToNBT(recipeTagCom);
            tagCom.func_74782_a("recipe", (NBTBase)recipeTagCom);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCom) {
        super.func_145839_a(tagCom);
        this.finishedCrafting = tagCom.func_74767_n("finishedCrafting");
        NBTTagCompound recipeTagCom = tagCom.func_74775_l("recipe");
        this.recipe = new DiagramRecipes.Recipe();
        this.recipe.readFromNBT(recipeTagCom);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_145841_b(tagCom);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tagCom);
    }

    public ArrayList<float[]>[] getUVsToRender() {
        ArrayList[] uvsToRender = new ArrayList[6];
        if (this.getRecipe() != null) {
            for (int side = 0; side < 6; ++side) {
                uvsToRender[side] = new ArrayList();
                for (DiagramRecipes.Recipe.RecipeComponent component : this.getRecipe().getComponents()) {
                    if (!component.hasUVForSide(side)) continue;
                    uvsToRender[side].addAll(component.getUVsForSide(side));
                }
            }
        }
        return uvsToRender;
    }
}

