/*
 * Decompiled with CFR 0.152.
 */
package com.countrygamer.core.Handler;

import com.countrygamer.core.Base.packet.AbstractPacket;
import com.countrygamer.core.lib.CoreUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

public class PacketTeleport
extends AbstractPacket {
    private int dimId = 0;
    private double[] coords = new double[3];
    private boolean fallDamage;
    private boolean particles;

    public PacketTeleport() {
    }

    public PacketTeleport(int dim, double[] coords) {
        this(dim, coords, false, false);
    }

    public PacketTeleport(int dim, double[] coords, boolean fall, boolean particles) {
        this.dimId = dim;
        this.coords = coords;
        this.fallDamage = fall;
        this.particles = particles;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dimId);
        buffer.writeDouble(this.coords[0]);
        buffer.writeDouble(this.coords[1]);
        buffer.writeDouble(this.coords[2]);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dimId = buffer.readInt();
        this.coords[0] = buffer.readDouble();
        this.coords[1] = buffer.readDouble();
        this.coords[2] = buffer.readDouble();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        System.out.println("Client PacketTeleport Recieved");
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        System.out.println("Server PacketTeleport Recieved");
        CoreUtil.teleportPlayerToDimension(player, this.dimId);
        CoreUtil.teleportPlayer(player, this.coords[0], this.coords[1], this.coords[2], this.fallDamage, this.particles);
    }
}

