/*
 * Decompiled with CFR 0.152.
 */
package com.countrygamer.core.CraftingSystem;

import com.countrygamer.core.Core;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class DiagramRecipes {
    public static HashMap<String, Recipe> recipeList = new HashMap();

    public static void addRecipe(String name, Recipe recipe) {
        recipeList.put(name, recipe);
    }

    public static class Recipe {
        public Block outputBlock;
        public int blockMetadata;
        ArrayList<RecipeComponent> components = new ArrayList();

        public Recipe() {
        }

        public Recipe(Block outputBlock, int blockMetadata) {
            this.outputBlock = outputBlock;
            this.blockMetadata = blockMetadata;
        }

        public void addRecipeComponent(RecipeComponent component) {
            this.components.add(component);
        }

        public int getNeededSizeOfInventory() {
            return this.components.size();
        }

        public ArrayList<RecipeComponent> getComponents() {
            return this.components;
        }

        public RecipeComponent getComponentFromSidedUV(int side, float u, float v) {
            for (RecipeComponent comp : this.components) {
                if (!comp.hasUVForSide(side)) continue;
                ArrayList<float[]> uvList = comp.getUVsForSide(side);
                for (float[] uvs : uvList) {
                    float minU = uvs[0];
                    float maxU = uvs[1];
                    float minV = uvs[2];
                    float maxV = uvs[3];
                    if (!(minU <= u) || !(u <= maxU) || !(minV <= v) || !(v <= maxV)) continue;
                    return comp;
                }
            }
            return null;
        }

        public void printComponents() {
            String output = "\n";
            for (RecipeComponent component : this.components) {
                for (int side = 0; side < 6; ++side) {
                    if (component.sidedUVs[side] == null || !component.hasUVForSide(side)) continue;
                    ArrayList<float[]> uvList = component.getUVsForSide(side);
                    for (float[] uvs : uvList) {
                        output = output + "\t";
                        output = output + "Side: " + side;
                        output = output + "\n\t";
                        output = output + component.inputStack.func_82833_r() + ", " + component.inputStack.func_77960_j();
                        output = output + "\n\t\t";
                        output = output + "iU: " + uvs[0] + "F, ";
                        output = output + "aU: " + uvs[1] + "F, ";
                        output = output + "iV: " + uvs[2] + "F, ";
                        output = output + "aV: " + uvs[3] + "F\n";
                    }
                    output = output + "\n";
                }
            }
            if (output.equals("\n")) {
                output = "There are no components for the recipe of " + this.outputBlock.func_149739_a() + " with metadata of " + this.blockMetadata;
            }
            Core.log.info(output);
        }

        public void writeToNBT(NBTTagCompound tagCom) {
            tagCom.func_74768_a("block_id", Block.func_149682_b((Block)this.outputBlock));
            tagCom.func_74768_a("block_meta", this.blockMetadata);
            NBTTagCompound compsTagCom = new NBTTagCompound();
            int compIndex = 0;
            for (RecipeComponent rc : this.components) {
                NBTTagCompound componentTagCom = new NBTTagCompound();
                rc.writeToNBT(componentTagCom);
                compsTagCom.func_74782_a(compIndex + "", (NBTBase)componentTagCom);
                ++compIndex;
            }
            compsTagCom.func_74768_a("components", compIndex);
            tagCom.func_74782_a("recipe_components", (NBTBase)compsTagCom);
        }

        public void readFromNBT(NBTTagCompound tagCom) {
            this.outputBlock = Block.func_149729_e((int)tagCom.func_74762_e("block_id"));
            this.blockMetadata = tagCom.func_74762_e("block_meta");
            NBTTagCompound compsTagCom = tagCom.func_74775_l("recipe_components");
            int compSize = compsTagCom.func_74762_e("components");
            this.components.clear();
            for (int i = 0; i < compSize; ++i) {
                NBTTagCompound componentTagCom = compsTagCom.func_74775_l(i + "");
                RecipeComponent rc = new RecipeComponent();
                rc.readFromNBT(componentTagCom);
                this.components.add(rc);
            }
        }

        public static class RecipeComponent {
            public String name;
            public int slotiD = 0;
            public ItemStack inputStack;
            ArrayList<float[]>[] sidedUVs = new ArrayList[6];

            public RecipeComponent() {
            }

            public RecipeComponent(String name, Recipe recipe, ItemStack itemStack) {
                this.name = name;
                this.slotiD = recipe.getComponents().size();
                this.inputStack = itemStack;
                for (int i = 0; i < this.sidedUVs.length; ++i) {
                }
            }

            public RecipeComponent generateFullForAllSides() {
                this.generateForAllSides(0.0f, 1.0f, 0.0f, 1.0f);
                return this;
            }

            public RecipeComponent generateForAllSides(float minU, float maxU, float minV, float maxV) {
                for (int i = 0; i < 6; ++i) {
                    this.addSidedUVArea(i, minU, maxU, minV, maxV);
                }
                return this;
            }

            public RecipeComponent addSidedUVArea(int side, float minU, float maxU, float minV, float maxV) {
                if (side < 0 || side >= 6) {
                    side = 0;
                }
                if (this.sidedUVs[side] == null) {
                    this.sidedUVs[side] = new ArrayList();
                }
                this.sidedUVs[side].add(new float[]{minU, maxU, minV, maxV});
                return this;
            }

            public boolean hasUVForSide(int side) {
                if (this.sidedUVs == null || this.sidedUVs[side] == null) {
                    return false;
                }
                return side >= 0 && side < 6 && !this.sidedUVs[side].isEmpty();
            }

            public ArrayList<float[]> getUVsForSide(int side) {
                return side < 0 || side >= 6 ? null : this.sidedUVs[side];
            }

            public void writeToNBT(NBTTagCompound tagCom) {
                NBTTagCompound sidesTagCom = new NBTTagCompound();
                for (int side = 0; side < 6; ++side) {
                    NBTTagCompound sideTagCom = new NBTTagCompound();
                    if (this.hasUVForSide(side)) {
                        ArrayList<float[]> uvList = this.getUVsForSide(side);
                        NBTTagCompound uvs = new NBTTagCompound();
                        for (int i = 0; i < uvList.size(); ++i) {
                            float[] uv = uvList.get(i);
                            NBTTagCompound uvTagCom = new NBTTagCompound();
                            for (int j = 0; j < uv.length; ++j) {
                                uvTagCom.func_74776_a(j + "", uv[j]);
                            }
                            uvs.func_74782_a(i + "", (NBTBase)uvTagCom);
                        }
                        uvs.func_74768_a("uvList_size", uvList.size());
                        sideTagCom.func_74782_a("uvs", (NBTBase)uvs);
                    }
                    sidesTagCom.func_74782_a(side + "", (NBTBase)sideTagCom);
                }
                tagCom.func_74778_a("name", this.name);
                tagCom.func_74768_a("slotid", this.slotiD);
                NBTTagCompound stackTagCom = new NBTTagCompound();
                this.inputStack.func_77955_b(stackTagCom);
                tagCom.func_74782_a("stackTag", (NBTBase)stackTagCom);
                tagCom.func_74782_a("sides", (NBTBase)sidesTagCom);
            }

            public void readFromNBT(NBTTagCompound tagCom) {
                this.name = tagCom.func_74779_i("name");
                this.slotiD = tagCom.func_74762_e("slotid");
                NBTTagCompound stackTagCom = tagCom.func_74775_l("stackTag");
                this.inputStack = new ItemStack(Blocks.field_150350_a);
                this.inputStack.func_77963_c(stackTagCom);
                this.sidedUVs = new ArrayList[6];
                NBTTagCompound sidesTagCom = tagCom.func_74775_l("sides");
                for (int side = 0; side < 6; ++side) {
                    this.sidedUVs[side] = new ArrayList();
                    NBTTagCompound sideTagCom = sidesTagCom.func_74775_l(side + "");
                    NBTTagCompound uvs = sidesTagCom.func_74775_l("uvs");
                    for (int i = 0; i < uvs.func_74762_e("uvList_size"); ++i) {
                        NBTTagCompound uvTagCom = uvs.func_74775_l(i + "");
                        float[] uvSet = new float[4];
                        for (int j = 0; j < uvSet.length; ++j) {
                            float coor;
                            uvSet[j] = coor = uvTagCom.func_74760_g(j + "");
                        }
                        this.sidedUVs[side].set(i, uvSet);
                    }
                }
            }
        }
    }
}

