/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.bin;

import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import plantmegapack.PlantMegaPack;
import plantmegapack.api.PMPPlantCategory;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.block.PMPBlockBamboo;
import plantmegapack.worldgen.PMPGenBase;

public class PMPBlockPlant
extends Block
implements IPlantable {
    public static final int maxGrowthStages = 5;
    public static final int minStagesForTallPlant = 3;
    private PMPPlantCategory category;
    public String scientificName = "";
    private int plantGrowthStages;
    private int inventoryIconIndex;
    private boolean twoBlocksTall;
    protected boolean flatRenderer;
    protected int heightLimit;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] textures;

    public PMPBlockPlant(PMPPlantCategory plantCategory, String blockName, int growthStages, int invIconIndex, boolean tallPlant) {
        super(plantCategory == PMPPlantCategory.water ? Material.field_151586_h : Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149663_c(blockName);
        this.func_149647_a(PlantMegaPack.modCreativeTab);
        this.category = plantCategory;
        this.scientificName = LanguageRegistry.instance().getStringLocalization("tile." + blockName + ".snam");
        this.plantGrowthStages = growthStages < 1 || growthStages > 5 ? 1 : growthStages;
        this.inventoryIconIndex = invIconIndex < 0 || invIconIndex >= this.plantGrowthStages ? 0 : invIconIndex;
        this.twoBlocksTall = tallPlant && this.plantGrowthStages >= 3 ? tallPlant : false;
        this.flatRenderer = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        int growthStages;
        String iconName = this.func_149739_a().substring(5);
        int iconsToLoad = growthStages = this.getGrowthStages();
        if (growthStages == 1) {
            this.textures = new IIcon[1];
            this.textures[0] = ir.func_94245_a("plantmegapack:" + iconName + "0");
        } else {
            if (this.isTallPlant()) {
                iconsToLoad = growthStages * 2 - 2;
            }
            this.textures = new IIcon[iconsToLoad];
            for (int count = 0; count < iconsToLoad; ++count) {
                this.textures[count] = ir.func_94245_a("plantmegapack:" + iconName + String.valueOf(count));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metaData) {
        return metaData < this.textures.length ? this.textures[metaData] : this.textures[0];
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        if (this.isTallPlant() && !this.canReplaceBlock(world, x, y + 1, z)) {
            return false;
        }
        return this.canReplaceBlock(world, x, y, z) && (this.canPlantOnThisBlock(blockBelow) || blockBelow.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this));
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        int metaData = world.func_72805_g(x, y, z);
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        if (this.isTallPlant() && (metaData == 3 || metaData == 5 || metaData == 7)) {
            return blockBelow == this;
        }
        return this.canPlantOnThisBlock(blockBelow) || blockBelow.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (this.getPlantCategory() == PMPPlantCategory.bamboo) {
            Block blockBelow = world.func_147439_a(x, y - 1, z);
            if (this != blockBelow) {
                ((PMPBlockBamboo)this).growBambooPlantFromBottom(world, x, y, z);
            }
        } else if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        } else if (PMPConfigPlants.controlGrowthRate > 0 && random.nextInt(100) < PMPConfigPlants.controlGrowthRate) {
            this.growPlant(world, x, y, z);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metaData, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, 0));
        return ret;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metaData = world.func_72805_g(x, y, z);
        if (this.getPlantCategory() == PMPPlantCategory.bamboo) {
            switch (metaData) {
                case 0: {
                    this.func_149676_a(0.26f, 0.0f, 0.26f, 0.74f, 1.0f, 0.74f);
                    break;
                }
                case 1: {
                    this.func_149676_a(0.22f, 0.0f, 0.22f, 0.78f, 1.0f, 0.78f);
                    break;
                }
                case 2: {
                    this.func_149676_a(0.18f, 0.0f, 0.18f, 0.82f, 1.0f, 0.82f);
                    break;
                }
                case 3: {
                    this.func_149676_a(0.14f, 0.0f, 0.14f, 0.86f, 1.0f, 0.86f);
                    break;
                }
                default: {
                    this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
                    break;
                }
            }
        } else if (this.isTallPlant()) {
            switch (metaData) {
                case 0: 
                case 5: {
                    this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.75f, 0.9f);
                    break;
                }
                case 1: 
                case 7: {
                    this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.9f, 0.9f);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
                    break;
                }
                case 3: {
                    this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.5f, 0.9f);
                    break;
                }
                default: {
                    this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.9f, 0.9f);
                    break;
                }
            }
        } else if (this.getGrowthStages() > 1) {
            this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, (float)(0.6 + (double)metaData * (0.4 / (double)this.getGrowthStages())), 0.9f);
        } else {
            this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.9f, 0.9f);
        }
    }

    public void func_149664_b(World world, int x, int y, int z, int metaData) {
        if (this.isTallPlant()) {
            switch (metaData) {
                case 2: 
                case 4: 
                case 6: {
                    if (world.func_147439_a(x, y + 1, z) != this) break;
                    world.func_147468_f(x, y + 1, z);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (world.func_147439_a(x, y - 1, z) != this) break;
                    world.func_147468_f(x, y - 1, z);
                    break;
                }
            }
        }
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return 0;
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    public int func_149645_b() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public boolean canPlantOnThisBlock(Block block) {
        return block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150458_ak || block == Blocks.field_150391_bh;
    }

    protected boolean canReplaceBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == Blocks.field_150350_a || PMPGenBase.isLeafBlock(world, x, y, z) || block == Blocks.field_150329_H || block == Blocks.field_150395_bd;
    }

    public boolean growPlant(World world, int x, int y, int z) {
        block17: {
            int metaData;
            block16: {
                Block block = world.func_147439_a(x, y, z);
                metaData = world.func_72805_g(x, y, z);
                if (this.isFullyGrown(metaData)) {
                    return false;
                }
                if (!this.isTallPlant()) break block16;
                switch (metaData) {
                    case 0: {
                        world.func_72921_c(x, y, z, 1, 2);
                        return true;
                    }
                    case 1: {
                        if (world.func_147437_c(x, y + 1, z) && this.getGrowthStages() > 2) {
                            world.func_72921_c(x, y, z, 2, 2);
                            world.func_147465_d(x, y + 1, z, block, 3, 2);
                            return true;
                        }
                        break block17;
                    }
                    case 2: {
                        if (world.func_147439_a(x, y + 1, z) == block && this.getGrowthStages() > 3) {
                            world.func_72921_c(x, y, z, 4, 2);
                            world.func_72921_c(x, y + 1, z, 5, 2);
                            return true;
                        }
                        break block17;
                    }
                    case 3: {
                        if (world.func_147439_a(x, y - 1, z) == block && this.getGrowthStages() > 3) {
                            world.func_72921_c(x, y, z, 5, 2);
                            world.func_72921_c(x, y - 1, z, 4, 2);
                            return true;
                        }
                        break block17;
                    }
                    case 4: {
                        if (world.func_147439_a(x, y + 1, z) == block && this.getGrowthStages() > 4) {
                            world.func_72921_c(x, y, z, 6, 2);
                            world.func_72921_c(x, y + 1, z, 7, 2);
                            return true;
                        }
                        break block17;
                    }
                    case 5: {
                        if (world.func_147439_a(x, y - 1, z) == block && this.getGrowthStages() > 4) {
                            world.func_72921_c(x, y, z, 7, 2);
                            world.func_72921_c(x, y - 1, z, 6, 2);
                            return true;
                        }
                        break block17;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (this.category == PMPPlantCategory.bamboo) {
                return ((PMPBlockBamboo)this).growBambooPlantFromBottom(world, x, y, z);
            }
            if (++metaData < this.getGrowthStages()) {
                world.func_72921_c(x, y, z, metaData, 2);
                return true;
            }
        }
        return false;
    }

    public boolean isFullyGrown(int metaData) {
        if (this.category == PMPPlantCategory.bamboo) {
            return false;
        }
        if (this.category == PMPPlantCategory.berrybush) {
            return metaData == this.getGrowthStages() - 1;
        }
        if (!this.isTallPlant() || metaData < 3) {
            return metaData == this.getGrowthStages() - 1;
        }
        if ((metaData == 4 || metaData == 5) && this.getGrowthStages() == 4) {
            return true;
        }
        return (metaData == 6 || metaData == 7) && this.getGrowthStages() == 5;
    }

    public int getGrowthStages() {
        return this.plantGrowthStages;
    }

    public int getHeightLimit() {
        return this.heightLimit;
    }

    public int getInventoryIconIndex() {
        return this.inventoryIconIndex;
    }

    public boolean isTallPlant() {
        return this.twoBlocksTall;
    }

    public PMPPlantCategory getPlantCategory() {
        return this.category;
    }

    public static boolean isAdjacentToBlockID(World world, int x, int y, int z, Block block) {
        return world.func_147439_a(x - 1, y, z) == block || world.func_147439_a(x - 1, y, z - 1) == block || world.func_147439_a(x - 1, y, z + 1) == block || world.func_147439_a(x, y, z - 1) == block || world.func_147439_a(x, y, z + 1) == block || world.func_147439_a(x + 1, y, z) == block || world.func_147439_a(x + 1, y, z - 1) == block || world.func_147439_a(x + 1, y, z + 1) == block;
    }

    public static int getPlantHeightFromBase(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Block blockAbove = world.func_147439_a(x, y + 1, z);
        int height = 1;
        while (block == blockAbove) {
            blockAbove = world.func_147439_a(x, y + ++height, z);
        }
        return height;
    }

    public static int getPlantHeightFromTop(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        int height = 1;
        while (block == blockBelow) {
            blockBelow = world.func_147439_a(x, y - ++height, z);
        }
        return height;
    }
}

