/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;

public abstract class PMPGenOcean
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 0, 2);
            world.func_147465_d(locationData.x, locationData.y + 1, locationData.z, Blocks.field_150325_L, 11, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genOcean) {
            return false;
        }
        boolean generated = false;
        if (locationData.y > 46) {
            if (random.nextInt(100) < 75) {
                if (PMPConfigPlants.waterKelpGiantGRN > 0) {
                    generated = PMPGenOcean.spawnKelp(world, random, locationData, PMPBlocks.waterKelpGiantGRN);
                }
            } else if (PMPConfigPlants.waterKelpGiantGRN > 0) {
                generated = PMPGenOcean.spawnKelpCluster(world, random, locationData, PMPBlocks.waterKelpGiantGRN, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.waterKelpGiantGRN), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.waterKelpGiantGRN));
            }
        } else if (locationData.y > 44) {
            if (PMPGenBase.isAdjacentToBlock(world, locationData.x, locationData.y, locationData.z, Blocks.field_150351_n) && PMPConfigPlants.waterKelpGiantYEL > 0) {
                generated = PMPGenOcean.spawnKelp(world, random, locationData, PMPBlocks.waterKelpGiantYEL);
            }
        } else if (locationData.y > 36 && locationData.y < 39) {
            generated = PMPGenOcean.spawnRandomCoral(world, random, locationData);
        }
        return generated;
    }

    public static boolean spawnKelp(World world, Random random, PMPSpawnLocation locationData, Block block) {
        return PMPGenOcean.spawnKelp(world, random, locationData.x, locationData.y, locationData.z, block, locationData.waterBlockDepth);
    }

    public static boolean spawnKelp(World world, Random random, int x, int y, int z, Block block, int maxHeight) {
        int actualHeight = y + random.nextInt(Math.max(1, maxHeight));
        if (PMPGenBase.canGrowOceanPlantHere(world, x, y, z)) {
            for (int height = y; height < actualHeight; ++height) {
                world.func_147465_d(x, height, z, block, 0, 2);
            }
            return true;
        }
        return false;
    }

    public static boolean spawnKelpCluster(World world, Random random, PMPSpawnLocation locationData, Block block, int range, int maxPlants) {
        for (int count = 0; count < maxPlants; ++count) {
            int height;
            int ix = locationData.x + random.nextInt(range) - random.nextInt(range);
            int iz = locationData.z + random.nextInt(range) - random.nextInt(range);
            int iy = world.func_72976_f(ix, iz);
            if (!PMPGenBase.canGrowOceanPlantHere(world, ix, iy -= (height = PMPGenBase.adjustLocationForWaterBlock(world, ix, iy, iz)), iz)) continue;
            height = random.nextInt(Math.max(1, height));
            PMPGenOcean.spawnKelp(world, random, ix, iy, iz, block, height);
        }
        return true;
    }

    public static boolean spawnRandomCoral(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 25) {
            if (PMPConfigPlants.waterBambooCoralYEL > 0) {
                return PMPGenBase.placeUnderwaterPlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.waterBambooCoralYEL, 0);
            }
        } else if (distribution < 50) {
            if (PMPConfigPlants.waterPulsingXenia > 0) {
                return PMPGenBase.placeUnderwaterPlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.waterPulsingXenia, 0);
            }
        } else if (distribution < 75) {
            if (PMPConfigPlants.waterPurpleSeaWhip > 0) {
                return PMPGenBase.placeUnderwaterPlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.waterPurpleSeaWhip, 0);
            }
        } else if (PMPConfigPlants.waterRedSeaFan > 0) {
            return PMPGenBase.placeUnderwaterPlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.waterRedSeaFan, 0);
        }
        return false;
    }
}

