/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.feature.PMPGenBamboo;
import plantmegapack.worldgen.feature.PMPGenFungus;
import plantmegapack.worldgen.feature.PMPGenGroundcover;

public abstract class PMPGenMushroomIsland
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 14, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genMushroomIsland) {
            return false;
        }
        int distribution = random.nextInt(100);
        if (distribution < 60) {
            PMPGenGroundcover.generateMushroomIslandGroundcover(world, random, locationData);
        } else {
            PMPGenMushroomIsland.generateRandomPlant(world, random, locationData);
        }
        return true;
    }

    public static boolean generateRandomPlant(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 50) {
            PMPGenFungus.generate(world, random, locationData);
        } else if (distribution < 60) {
            if (PMPConfigPlants.bambooTimorBlack > 0) {
                PMPGenBamboo.spawnRandomBambooPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.bambooTimorBlack, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.bambooTimorBlack), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.bambooTimorBlack));
            }
        } else if (distribution < 90) {
            if (PMPConfigPlants.jungleShellflower > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.jungleShellflower, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.jungleShellflower), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.jungleShellflower));
            }
        } else if (PMPConfigPlants.fernScalyTree > 0) {
            PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fernScalyTree, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fernScalyTree), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fernScalyTree));
        }
        return true;
    }
}

