/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;

public abstract class PMPGenMountain
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 3, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genMountain) {
            return false;
        }
        int distribution = random.nextInt(100);
        if (PMPGenBase.isAdjacentToBlock(world, locationData.x, locationData.y - 1, locationData.z, Blocks.field_150348_b)) {
            if (distribution < 70) {
                PMPGenMountain.generateMountainShrub(world, random, locationData);
            } else if (PMPConfigPlants.flowerCandelabraAloe > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerCandelabraAloe, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerCandelabraAloe), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerCandelabraAloe));
                PMPGenBase.generateRandomGrassCluster(world, random, locationData.x, locationData.y, locationData.z, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerCandelabraAloe), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerCandelabraAloe));
            }
        } else if (distribution < 40) {
            PMPGenMountain.generateMountainShrub(world, random, locationData);
        } else if (distribution < 70) {
            PMPGenMountain.generateMountainPlant(world, random, locationData);
        } else if (distribution < 90) {
            if (PMPConfigPlants.grassFountain > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.grassFountain, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.grassFountain), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.grassFountain));
            }
        } else if (PMPConfigPlants.berrybushSnow > 0 && random.nextInt(10) < PMPConfigPlants.berrybushSnow) {
            PMPGenBase.placePlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.berrybushSnow, PMPBlocks.berrybushSnow.getGrowthStages() - 1);
            PMPGenBase.surroundPlantWithGrass(world, locationData.x, locationData.y, locationData.z);
        }
        return true;
    }

    public static boolean generateMountainShrub(World world, Random random, PMPSpawnLocation locationData) {
        boolean generated = false;
        int distribution = random.nextInt(100);
        if (distribution < 10) {
            if (PMPConfigPlants.shrubAlpineCurrant > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubAlpineCurrant, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubAlpineCurrant), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubAlpineCurrant));
            }
        } else if (distribution < 20) {
            if (PMPConfigPlants.shrubDaphne > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubDaphne, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubDaphne), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubDaphne));
            }
        } else if (distribution < 30) {
            if (PMPConfigPlants.shrubJuniperSavin > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubJuniperSavin, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubJuniperSavin), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubJuniperSavin));
            }
        } else if (distribution < 50) {
            if (PMPConfigPlants.shrubKerria > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubKerria, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubKerria), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubKerria));
            }
        } else if (distribution < 60) {
            if (PMPConfigPlants.shrubLavender > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubLavender, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubLavender), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubLavender));
            }
        } else if (distribution < 70) {
            if (PMPConfigPlants.mountainEdelweiss > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainEdelweiss, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainEdelweiss), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainEdelweiss));
            }
        } else if (distribution < 80) {
            if (PMPConfigPlants.mountainEdelweiss > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainEdelweiss, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainEdelweiss), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainEdelweiss));
            }
        } else if (distribution < 90) {
            if (PMPConfigPlants.leafyKrisPlant > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.leafyKrisPlant, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.leafyKrisPlant), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.leafyKrisPlant));
            }
        } else if (PMPConfigPlants.grassFountain > 0) {
            PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.grassFountain, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.grassFountain), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.grassFountain));
        }
        return generated;
    }

    public static boolean generateMountainPlant(World world, Random random, PMPSpawnLocation locationData) {
        boolean generated = false;
        int distribution = random.nextInt(100);
        if (distribution < 8) {
            if (PMPConfigPlants.mountainAlpineArmeria > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainAlpineArmeria, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainAlpineArmeria), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainAlpineArmeria));
            }
        } else if (distribution < 16) {
            if (PMPConfigPlants.mountainAlpineBellflower > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainAlpineBellflower, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainAlpineBellflower), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainAlpineBellflower));
            }
        } else if (distribution < 24) {
            if (PMPConfigPlants.mountainBistort > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainBistort, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainBistort), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainBistort));
            }
        } else if (distribution < 32) {
            if (PMPConfigPlants.mountainEdelweiss > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainEdelweiss, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainEdelweiss), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainEdelweiss));
            }
        } else if (distribution < 40) {
            if (PMPConfigPlants.mountainHouseleek > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainHouseleek, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainHouseleek), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainHouseleek));
            }
        } else if (distribution < 48) {
            if (PMPConfigPlants.mountainIris > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainIris, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainIris), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainIris));
            }
        } else if (distribution < 56) {
            if (PMPConfigPlants.mountainNorhternWillowherb > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainNorhternWillowherb, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainNorhternWillowherb), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainNorhternWillowherb));
            }
        } else if (distribution < 64) {
            if (PMPConfigPlants.mountainScarletTrumpet > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainScarletTrumpet, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainScarletTrumpet), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainScarletTrumpet));
            }
        } else if (distribution < 72) {
            if (PMPConfigPlants.mountainYellowBellflower > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainYellowBellflower, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainYellowBellflower), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainYellowBellflower));
            }
        } else if (distribution < 80) {
            if (PMPConfigPlants.flowerDelphinium > 0) {
                PMPGenBase.generateRandomMultiFlowerCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerDelphinium, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerDelphinium), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerDelphinium));
            }
        } else if (PMPConfigPlants.shrubAlpineCurrant > 0) {
            PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubAlpineCurrant, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubAlpineCurrant), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubAlpineCurrant));
        }
        return generated;
    }
}

