/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.feature.PMPGenGroundcover;

public abstract class PMPGenForestShade
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 5, 2);
            world.func_147465_d(locationData.x, locationData.y + 1, locationData.z, Blocks.field_150325_L, 12, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genForestShade) {
            return false;
        }
        int distribution = random.nextInt(100);
        if (distribution < 90) {
            PMPGenGroundcover.generateShadeGroundcover(world, random, locationData);
        } else {
            PMPGenForestShade.generateRandomForestPlant(world, random, locationData);
        }
        return true;
    }

    public static boolean generateRandomForestPlant(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 50) {
            PMPGenGroundcover.generate(world, random, locationData);
        } else if (distribution < 60) {
            if (PMPConfigPlants.leafyColeus > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.leafyColeus, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.leafyColeus), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.leafyColeus));
            }
        } else if (distribution < 70) {
            if (PMPConfigPlants.forestDeceivingTrillium > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.forestDeceivingTrillium, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.forestDeceivingTrillium), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.forestDeceivingTrillium));
            }
        } else if (distribution < 80) {
            if (PMPConfigPlants.flowerFoamFlower > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerFoamFlower, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerFoamFlower), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerFoamFlower));
            }
        } else if (distribution < 90) {
            if (PMPConfigPlants.flowerRoseCampion > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerRoseCampion, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerRoseCampion), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerRoseCampion));
            }
        } else if (PMPConfigPlants.shrubBoxwood > 0) {
            PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubBoxwood, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubBoxwood), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubBoxwood));
        }
        return true;
    }
}

