/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;

public abstract class PMPGenDesert
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 4, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genDesert) {
            return false;
        }
        int distribution = random.nextInt(100);
        if (PMPGenBase.isAdjacentToBlock(world, locationData.x, locationData.y, locationData.z, Blocks.field_150354_m)) {
            PMPGenDesert.generateRandomCactusCluster(world, random, locationData);
        } else if (distribution < 20) {
            PMPGenDesert.generateRandomDesertPlantCluster(world, random, locationData);
        }
        return true;
    }

    public static boolean generateRandomCactusCluster(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 20) {
            if (PMPConfigPlants.cactusArmatocereusMatucanensis > 0) {
                PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.cactusArmatocereusMatucanensis, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.cactusArmatocereusMatucanensis), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.cactusArmatocereusMatucanensis));
            }
            if (PMPConfigPlants.cactusEchinocereusMetornii > 0) {
                PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.cactusEchinocereusMetornii, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.cactusEchinocereusMetornii), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.cactusEchinocereusMetornii));
            }
        } else if (distribution < 40) {
            if (PMPConfigPlants.cactusBaseballBat > 0) {
                PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.cactusBaseballBat, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.cactusBaseballBat), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.cactusBaseballBat));
            }
            if (PMPConfigPlants.cactusGoldenCereus > 0) {
                PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.cactusGoldenCereus, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.cactusGoldenCereus), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.cactusGoldenCereus));
            }
        } else if (distribution < 60) {
            if (PMPConfigPlants.cactusGoldenSaguaro > 0) {
                PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.cactusGoldenSaguaro, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.cactusGoldenSaguaro), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.cactusGoldenSaguaro));
            }
            if (PMPConfigPlants.cactusMatucanaAureiflora > 0) {
                PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.cactusMatucanaAureiflora, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.cactusMatucanaAureiflora), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.cactusMatucanaAureiflora));
            }
        } else if (distribution < 80) {
            if (PMPConfigPlants.cactusPricklyPear > 0) {
                PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.cactusPricklyPear, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.cactusPricklyPear), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.cactusPricklyPear));
            }
        } else if (PMPConfigPlants.cactusToothpick > 0) {
            PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.cactusToothpick, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.cactusToothpick), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.cactusToothpick));
        }
        return true;
    }

    public static boolean generateRandomDesertPlantCluster(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 10 && PMPConfigPlants.desertBrittlebush > 0) {
            PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.desertBrittlebush, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.desertBrittlebush), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.desertBrittlebush));
        }
        if (distribution < 20) {
            if (PMPConfigPlants.desertSeepwood > 0) {
                PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.desertSeepwood, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.desertSeepwood), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.desertSeepwood));
            }
        } else if (distribution < 30 && PMPConfigPlants.desertWhiteSage > 0) {
            PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.desertWhiteSage, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.desertWhiteSage), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.desertWhiteSage));
        }
        return true;
    }
}

