/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.feature.PMPGenGroundcover;

public abstract class PMPGenColdForestShade
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 13, 2);
            world.func_147465_d(locationData.x, locationData.y + 1, locationData.z, Blocks.field_150325_L, 12, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genColdForestShade) {
            return false;
        }
        int distribution = random.nextInt(100);
        if (distribution < 90) {
            PMPGenGroundcover.generateShadeGroundcover(world, random, locationData);
        } else {
            PMPGenColdForestShade.generateRandomForestPlant(world, random, locationData);
        }
        return true;
    }

    public static boolean generateRandomForestPlant(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 50) {
            if (PMPConfigPlants.forestLilyoftheValley > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.forestLilyoftheValley, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.forestLilyoftheValley), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.forestLilyoftheValley));
            }
        } else if (PMPConfigPlants.flowerGladiolus > 0) {
            PMPGenBase.generateRandomMultiFlowerCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerGladiolus, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerGladiolus), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerGladiolus));
        }
        return true;
    }
}

