/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.block.PMPBlockBamboo;
import plantmegapack.worldgen.PMPGenBase;

public abstract class PMPGenBamboo
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        return false;
    }

    private static boolean spawnBamboo(World world, Random random, int x, int y, int z, Block block) {
        PMPBlockBamboo blockBamboo = (PMPBlockBamboo)block;
        if (blockBamboo == null) {
            return false;
        }
        int spawnHeight = random.nextInt(blockBamboo.getHeightLimit());
        for (int count = 0; count < spawnHeight; ++count) {
            if (PMPGenBase.canReplaceBlockWithPlant(world, x, y + count, z) && PMPGenBase.canReplaceBlockWithPlant(world, x, y + count + 1, z)) {
                if (blockBamboo.getRenderStyle() == 2) {
                    if (count == 0) {
                        world.func_147465_d(x, y + count, z, (Block)blockBamboo, 0, 2);
                        continue;
                    }
                    world.func_147465_d(x, y + count, z, (Block)blockBamboo, 1 + random.nextInt(3), 2);
                    continue;
                }
                world.func_147465_d(x, y + count, z, (Block)blockBamboo, 0, 2);
                continue;
            }
            spawnHeight = count;
        }
        world.func_147465_d(x, y + spawnHeight, z, (Block)blockBamboo, 4, 2);
        blockBamboo.updateBambooFromTop(world, x, y + spawnHeight, z);
        return true;
    }

    public static void spawnRandomBambooPlantCluster(World world, Random random, int x, int y, int z, Block block, int range, int maxPlants) {
        for (int count = 0; count < maxPlants; ++count) {
            int iz;
            int iy;
            int ix = x + random.nextInt(range) - random.nextInt(range);
            if (PMPGenBase.isLeafBlock(world, ix, (iy = world.func_72976_f(ix, iz = z + random.nextInt(range) - random.nextInt(range))) - 1, iz)) {
                iy = PMPGenBase.adjustHeightForLeaf(world, random, ix, iy, iz);
            }
            Block blockSoil = world.func_147439_a(ix, iy - 1, iz);
            if (!PMPGenBase.canReplaceBlockWithPlant(world, ix, iy, iz) || !PMPGenBase.canReplaceBlockWithPlant(world, ix, iy + 1, iz) || !PMPGenBase.isSoilBlock(blockSoil)) continue;
            PMPGenBamboo.spawnBamboo(world, random, ix, iy, iz, block);
        }
    }
}

