/*
 * Decompiled with CFR 0.152.
 */
package planetoid;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TimeAnalyzer {
    private static HashMap<String, Long> all = new HashMap();
    private static HashMap<String, Long> count = new HashMap();
    private static HashMap<String, Long> start = new HashMap();

    public static void start(String s) {
        if (!all.containsKey(s)) {
            all.put(s, 0L);
            count.put(s, 1L);
        } else {
            long co = count.get(s);
            count.remove(s);
            count.put(s, co + 1L);
        }
        start.put(s, System.currentTimeMillis());
    }

    public static void end(String s) {
        if (!start.containsKey(s)) {
            return;
        }
        long t = System.currentTimeMillis() - start.get(s);
        long a = all.get(s);
        all.remove(s);
        all.put(s, a + t);
        start.remove(s);
    }

    public static void print() {
        if (all.size() == 0) {
            System.out.println("----TimeAnalyzer EMPTY----");
            return;
        }
        System.out.println("----TimeAnalyzer----");
        Iterator<Map.Entry<String, Long>> iter = all.entrySet().iterator();
        while (iter.hasNext()) {
            String s = iter.next().getKey();
            System.out.println("TA: Section=" + s + "\tTime=" + all.get(s) + "ms\tCount=" + count.get(s) + "\tAverage=" + TimeAnalyzer.getAverage(s) + "ms");
        }
        System.out.println("----TimeAnalyzer----");
    }

    public static void reset() {
        try {
            all.clear();
            count.clear();
            start.clear();
        }
        catch (Exception e) {
            System.err.println("wuaaat! " + e);
        }
    }

    public static double getAverage(String s) {
        double a = all.get(s).longValue();
        double c = count.get(s).longValue();
        return a / c;
    }
}

