/*
 * Decompiled with CFR 0.152.
 */
package planetoid;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import planetoid.PlanetType;
import planetoid.PlanetoidChunkManager;
import planetoid.TimeAnalyzer;

public class Planet {
    static PlanetType DIRT = new PlanetType(2, 3, 20, "Dirt");
    static PlanetType WOOD = new PlanetType(18, 17, 10, "Wood");
    static PlanetType WATER = new PlanetType(20, 9, 5, "Water");
    static PlanetType SAND = new PlanetType(24, 12, 10, "Sand");
    static PlanetType GLOWSTONE = new PlanetType(2, 3, 5, "Glowstone");
    static PlanetType STONE = new PlanetType(1, 1, 20, "Stone");
    static PlanetType GRAVEL = new PlanetType(1, 13, 40, "Gravel");
    static PlanetType COBBLESTONE = new PlanetType(1, 13, 60, "Cobblestone");
    static PlanetType LAVA = new PlanetType(1, 11, 60, "Lava");
    static PlanetType COAL = new PlanetType(1, 16, 60, "Coal");
    static PlanetType IRON = new PlanetType(1, 15, 60, "Iron");
    static PlanetType GOLD = new PlanetType(1, 14, 30, "Gold");
    static PlanetType REDSTONE = new PlanetType(1, 73, 30, "Redstone");
    static PlanetType LAPISLAZULI = new PlanetType(1, 21, 15, "Lapislazuli");
    static PlanetType TNT = new PlanetType(1, 46, 2, "TNT");
    static PlanetType DIAMOND = new PlanetType(1, 56, 2, "Diamond");
    static PlanetType EMERALD = new PlanetType(1, 129, 1, "Emerald");
    static ArrayList<PlanetType> stonetypes = new ArrayList();
    static ArrayList<PlanetType> types = Planet.initTypes();
    Random rand = new Random();
    PlanetoidChunkManager chunkManager;
    World world2;
    int x;
    int y;
    int z;
    int radius;
    PlanetType type;
    ArrayList<Point> unfinished = new ArrayList();
    ArrayList<Point> finished = new ArrayList();

    public Planet(PlanetoidChunkManager cm, World w, int x, int y, int z, int r) {
        this.chunkManager = cm;
        this.world2 = w;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = r;
        this.type = this.getRandomPlanet();
    }

    private static ArrayList<PlanetType> initTypes() {
        ArrayList<PlanetType> list = new ArrayList<PlanetType>();
        list.add(DIRT);
        list.add(WOOD);
        list.add(WATER);
        list.add(SAND);
        list.add(GLOWSTONE);
        list.add(STONE);
        stonetypes.add(GRAVEL);
        stonetypes.add(COBBLESTONE);
        stonetypes.add(LAVA);
        stonetypes.add(COAL);
        stonetypes.add(IRON);
        stonetypes.add(GOLD);
        stonetypes.add(REDSTONE);
        stonetypes.add(LAPISLAZULI);
        stonetypes.add(TNT);
        stonetypes.add(DIAMOND);
        stonetypes.add(EMERALD);
        return list;
    }

    public Planet(PlanetoidChunkManager cm, World w, double x, double y, double z, double r) {
        this(cm, w, Planet.round(x), Planet.round(y), Planet.round(z), Planet.round(r));
    }

    public static void print() {
        System.out.println("---PREGENERATION: ---");
        for (PlanetType p : types) {
            System.out.println(p.name + ":\t" + p.total);
        }
        for (PlanetType p : stonetypes) {
            System.out.println("-" + p.name + ":\t" + p.total);
        }
        System.out.println("---PREGENERATION END---");
    }

    public PlanetType getRandomPlanet() {
        this.rand.setSeed((long)this.x * 341873128712L + (long)this.z * 132897987541L);
        int r = this.rand.nextInt(100);
        ArrayList<PlanetType> list = new ArrayList<PlanetType>();
        list.addAll(types);
        PlanetType type = (PlanetType)WeightedRandom.func_76271_a((Random)this.rand, list);
        if (type == STONE) {
            list.clear();
            list.addAll(stonetypes);
            type = (PlanetType)WeightedRandom.func_76271_a((Random)this.rand, list);
        }
        ++type.total;
        if (type.out == 1) {
            ++Planet.STONE.total;
        }
        return type;
    }

    public boolean tryToGenerate(int chunkX, int chunkZ, byte[] data) {
        TimeAnalyzer.start("tryToGenerate");
        if (this.isAreaClear()) {
            this.generatePlanet(chunkX, chunkZ, data);
            TimeAnalyzer.end("tryToGenerate");
            return true;
        }
        TimeAnalyzer.end("tryToGenerate");
        return false;
    }

    public void generatePlanet(int chunkX, int chunkZ, byte[] data) {
        TimeAnalyzer.start("generatePlanet");
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        TimeAnalyzer.start("thisChunk");
        this.generateChunk(chunkX, chunkZ, data);
        TimeAnalyzer.end("thisChunk");
        TimeAnalyzer.end("generatePlanet");
    }

    public void generateChunk(int chunkX, int chunkZ, byte[] data) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        TimeAnalyzer.start("generateChunk");
        for (int x2 = Math.max(chunkX * 16, this.x - this.radius); x2 <= Math.min(chunkX * 16 + 15, this.x + this.radius); ++x2) {
            for (int y2 = this.y - this.radius; y2 <= this.y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, this.z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, this.z + this.radius); ++z2) {
                    int d = Planet.round(Planet.distance(this.x, this.y, this.z, x2, y2, z2));
                    if (d == this.radius) {
                        if (this.type == SAND && !this.isBottomBlock(x2, y2, z2)) {
                            this.setBlock(x2, y2, z2, this.type.in, 0, data);
                        } else {
                            this.setBlock(x2, y2, z2, this.type.out, 0, data);
                        }
                    } else if (d < this.radius) {
                        this.setBlock(x2, y2, z2, this.type.in, 0, data);
                    }
                    this.generateSpecial(x2, y2, z2, data);
                }
            }
        }
        if (!this.finished.contains(new Point(chunkX, chunkZ))) {
            this.finished.add(new Point(chunkX, chunkZ));
        }
        if (this.unfinished.contains(new Point(chunkX, chunkZ))) {
            this.unfinished.remove(new Point(chunkX, chunkZ));
        }
        TimeAnalyzer.end("generateChunk");
    }

    public void decorateChunk(World world, int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, this.x - this.radius); x2 <= Math.min(chunkX * 16 + 15, this.x + this.radius); ++x2) {
            for (int y2 = this.y; y2 <= this.y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, this.z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, this.z + this.radius); ++z2) {
                    int i;
                    boolean flag2;
                    if (!this.isTopBlock(x2, y2, z2)) continue;
                    if (this.type == SAND && this.rand.nextDouble() <= 0.05 && Block.field_72038_aV.func_71930_b(world, x2, y2 + 1, z2)) {
                        for (int i2 = 1; i2 <= 1 + this.rand.nextInt(3); ++i2) {
                            world.func_72832_d(x2, y2 + i2, z2, 81, 0, 3);
                        }
                    }
                    if (this.type != DIRT) continue;
                    if (this.rand.nextDouble() <= 0.1 && Block.field_71962_X.func_71930_b(world, x2, y2 + 1, z2)) {
                        world.func_72832_d(x2, y2 + 1, z2, 31, 1, 3);
                        continue;
                    }
                    if (!(this.rand.nextDouble() <= 0.004)) continue;
                    boolean flag1 = world.func_72798_a(x2 + 1, y2, z2) == 2 && world.func_72798_a(x2 - 1, y2, z2) == 2 && world.func_72798_a(x2, y2, z2 + 1) == 2 && world.func_72798_a(x2, y2, z2 - 1) == 2;
                    boolean bl = flag2 = world.func_72798_a(x2 + 1, y2 + 1, z2) == 0 && world.func_72798_a(x2 - 1, y2 + 1, z2) == 0 && world.func_72798_a(x2, y2 + 1, z2 + 1) == 0 && world.func_72798_a(x2, y2 + 1, z2 - 1) == 0;
                    if (!flag1 || !flag2) continue;
                    world.func_72832_d(x2, y2, z2, 9, 0, 3);
                    for (i = 1; i <= 1 + this.rand.nextInt(3); ++i) {
                        world.func_72832_d(x2 + 1, y2 + i, z2, 83, 0, 3);
                    }
                    for (i = 1; i <= 1 + this.rand.nextInt(3); ++i) {
                        world.func_72832_d(x2 - 1, y2 + i, z2, 83, 0, 3);
                    }
                    for (i = 1; i <= 1 + this.rand.nextInt(3); ++i) {
                        world.func_72832_d(x2, y2 + i, z2 + 1, 83, 0, 3);
                    }
                    for (i = 1; i <= 1 + this.rand.nextInt(3); ++i) {
                        world.func_72832_d(x2, y2 + i, z2 - 1, 83, 0, 3);
                    }
                }
            }
        }
    }

    private void generateSpecial(int x, int y, int z, byte[] data) {
    }

    private boolean isTopBlock(int x2, int y2, int z2) {
        return Planet.round(Planet.distance(this.x, this.y, this.z, x2, y2, z2)) == this.radius && Planet.round(Planet.distance(this.x, this.y, this.z, x2, y2 + 1, z2)) > this.radius;
    }

    private boolean isBottomBlock(int x2, int y2, int z2) {
        return Planet.round(Planet.distance(this.x, this.y, this.z, x2, y2, z2)) == this.radius && Planet.round(Planet.distance(this.x, this.y, this.z, x2, y2 - 1, z2)) > this.radius;
    }

    public static int getBlockNum(int x, int y, int z) {
        if (x < 0) {
            x = 16 + x;
        }
        if (z < 0) {
            z = 16 + z;
        }
        return y + z * 128 + x * 128 * 16;
    }

    private void setBlock(int x, int y, int z, int id, int meta, byte[] data) {
        if (y < 0 || y >= 128) {
            return;
        }
        data[Planet.getBlockNum((int)(x % 16), (int)y, (int)(z % 16))] = (byte)id;
    }

    public boolean shouldFinishChunk(int cx, int cz) {
        return this.unfinished.contains(new Point(cx, cz));
    }

    public boolean shouldDecorateChunk(int cx, int cz) {
        return this.finished.contains(new Point(cx, cz));
    }

    public boolean isAreaClear() {
        for (Planet p : this.chunkManager.unfinished) {
            if (!p.intersects(this)) continue;
            return false;
        }
        for (Planet p : this.chunkManager.finished) {
            if (!p.intersects(this)) continue;
            return false;
        }
        return true;
    }

    private boolean intersects(Planet planet) {
        return Planet.distance(planet.x, planet.y, planet.z, this.x, this.y, this.z) <= (double)(planet.radius + this.radius + 1);
    }

    public boolean isFinished() {
        return this.unfinished.size() == 0;
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
    }

    public static int round(double d) {
        return (int)Math.round(d);
    }
}

