/*
 * Decompiled with CFR 0.152.
 */
package planetoid;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.SpawnListEntry;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import planetoid.Planet;
import planetoid.TimeAnalyzer;

public class PlanetoidChunkManager
extends WorldChunkManager
implements IChunkProvider {
    Random rand = new Random();
    long seed;
    World world;
    boolean mapFeaturesEnabled;
    private double[] noiseField;
    ArrayList<Planet> finished = new ArrayList();
    ArrayList<Planet> unfinished = new ArrayList();
    ArrayList<Point> pregen = new ArrayList();
    int pregenChunkSize = 4;
    int planetDepth = 16;
    IChunkProvider defaultProvider;

    public PlanetoidChunkManager(World w) {
        this(w, w.func_72905_C(), true);
    }

    public PlanetoidChunkManager(World w, long s, boolean maps) {
        super(w);
        this.world = w;
        this.seed = s;
        this.mapFeaturesEnabled = maps;
        this.defaultProvider = new ChunkProviderGenerate(w, w.func_72905_C(), w.func_72912_H().func_76089_r());
    }

    public boolean func_73149_a(int i, int j) {
        return true;
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        this.preGenerate(par1, par2);
        byte[] abyte = new byte[32768];
        this.generatePlanetoid(par1, par2, abyte);
        Chunk chunk = new Chunk(this.world, abyte, par1, par2);
        BiomeGenBase[] abiomegenbase = this.world.func_72959_q().func_76933_b((BiomeGenBase[])null, par1 * 16, par2 * 16, 16, 16);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)abiomegenbase[k].field_76756_M;
        }
        chunk.func_76603_b();
        chunk.func_76586_k();
        TimeAnalyzer.print();
        return chunk;
    }

    public void preGenerate(int cx, int cz) {
        TimeAnalyzer.start("pregenerate");
        int x = PlanetoidChunkManager.round(cx / this.pregenChunkSize);
        int z = PlanetoidChunkManager.round(cz / this.pregenChunkSize);
        this.preGenerate2(x - 1, z - 1);
        this.preGenerate2(x - 1, z);
        this.preGenerate2(x - 1, z + 1);
        this.preGenerate2(x, z - 1);
        this.preGenerate2(x, z);
        this.preGenerate2(x, z + 1);
        this.preGenerate2(x + 1, z - 1);
        this.preGenerate2(x + 1, z);
        this.preGenerate2(x + 1, z + 1);
        TimeAnalyzer.end("pregenerate");
    }

    private void preGenerate2(int x, int z) {
        if (!this.pregen.contains(new Point(x, z))) {
            this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            int x2 = x * this.pregenChunkSize * 16;
            int z2 = z * this.pregenChunkSize * 16;
            this.preGenerate_do(x2, z2, x2 + this.pregenChunkSize * 16, z2 + this.pregenChunkSize * 16);
            this.pregen.add(new Point(x, z));
        }
    }

    private void preGenerate_do(int x1, int z1, int x2, int z2) {
        TimeAnalyzer.start("pregenerate_do");
        int p2 = 0;
        for (int l = 0; l < this.planetDepth; ++l) {
            double z;
            double y;
            double r = PlanetoidChunkManager.round(this.rand.nextDouble() * 10.0 + 5.0);
            double x = x1 + this.rand.nextInt(x2 - x1);
            Planet p = new Planet(this, this.world, x, y = (double)PlanetoidChunkManager.round(r + (128.0 - 2.0 * r) * this.rand.nextDouble()), z = (double)(z1 + this.rand.nextInt(z2 - z1)), (double)PlanetoidChunkManager.round(r));
            if (!p.isAreaClear()) continue;
            int c = 0;
            for (int i = PlanetoidChunkManager.round(x) - PlanetoidChunkManager.round(r); i <= PlanetoidChunkManager.round(x) + PlanetoidChunkManager.round(r); ++i) {
                for (int k = PlanetoidChunkManager.round(z) - PlanetoidChunkManager.round(r); k <= PlanetoidChunkManager.round(z) + PlanetoidChunkManager.round(r); ++k) {
                    int cz;
                    int cx = (int)Math.floor((double)i / 16.0);
                    if (p.unfinished.contains(new Point(cx, cz = (int)Math.floor((double)k / 16.0)))) continue;
                    p.unfinished.add(new Point(cx, cz));
                    ++c;
                }
            }
            ++p2;
            this.unfinished.add(p);
        }
        TimeAnalyzer.end("pregenerate_do");
    }

    public void generatePlanetoid(int chunkX, int chunkZ, byte[] data) {
        TimeAnalyzer.start("generate");
        double planetsperchunk = 3.0;
        TimeAnalyzer.start("generateNew");
        TimeAnalyzer.end("generateNew");
        TimeAnalyzer.start("finishPlanets");
        for (int i = 0; i < this.unfinished.size(); ++i) {
            Planet p = this.unfinished.get(i);
            if (p.shouldFinishChunk(chunkX, chunkZ)) {
                p.generateChunk(chunkX, chunkZ, data);
            }
            if (!p.isFinished()) continue;
            this.unfinished.remove(p);
            this.finished.add(p);
            --i;
        }
        TimeAnalyzer.end("finishPlanets");
        TimeAnalyzer.start("generateWater");
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 16; ++z) {
                    data[Planet.getBlockNum((int)x, (int)y, (int)z)] = (byte)(y == 0 ? 7 : 9);
                }
            }
        }
        TimeAnalyzer.end("generateWater");
        TimeAnalyzer.end("generate");
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int x, int z) {
        Planet p;
        int i;
        TimeAnalyzer.start("populate");
        for (i = 0; i < this.unfinished.size(); ++i) {
            p = this.unfinished.get(i);
            if (!p.shouldDecorateChunk(x, z)) continue;
            p.decorateChunk(this.world, x, z);
        }
        for (i = 0; i < this.finished.size(); ++i) {
            p = this.finished.get(i);
            if (!p.shouldDecorateChunk(x, z)) continue;
            p.decorateChunk(this.world, x, z);
        }
        TimeAnalyzer.start("populate2");
        this.defaultProvider.func_73153_a(ichunkprovider, x, z);
        int k = x * 16;
        int l = z * 16;
        BiomeGenBase biomegenbase = this.world.func_72807_a(k + 16, l + 16);
        for (int s = 0; s < 3; ++s) {
            SpawnerAnimals.func_77191_a((World)this.world, (BiomeGenBase)biomegenbase, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
        }
        TimeAnalyzer.end("populate2");
        Chunk c = this.world.func_72964_e(x, z);
        c.func_76603_b();
        c.func_76586_k();
        TimeAnalyzer.end("populate");
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate iprogressupdate) {
        return false;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "Planetoid";
    }

    public List func_73155_a(EnumCreatureType type, int i, int j, int k) {
        ArrayList<SpawnListEntry> list = new ArrayList<SpawnListEntry>();
        if (type == EnumCreatureType.monster) {
            list.add(new SpawnListEntry(EntitySpider.class, 10, 4, 4));
            list.add(new SpawnListEntry(EntityZombie.class, 10, 4, 4));
            list.add(new SpawnListEntry(EntitySkeleton.class, 10, 4, 4));
            list.add(new SpawnListEntry(EntityCreeper.class, 10, 4, 4));
            list.add(new SpawnListEntry(EntitySlime.class, 10, 4, 4));
            list.add(new SpawnListEntry(EntityEnderman.class, 1, 1, 4));
        } else if (type == EnumCreatureType.creature) {
            list.add(new SpawnListEntry(EntitySheep.class, 12, 4, 4));
        } else if (type == EnumCreatureType.waterCreature) {
            list.add(new SpawnListEntry(EntitySquid.class, 10, 4, 4));
        }
        return list;
    }

    public ChunkPosition func_73150_a(World world, String s, int i, int j, int k) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int i, int j) {
    }

    public void func_76938_b() {
    }

    public static int round(double d) {
        return (int)Math.round(d);
    }

    public void func_104112_b() {
    }
}

