/*
 * Decompiled with CFR 0.152.
 */
package itfellfromthesky.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import itfellfromthesky.common.ItFellFromTheSky;
import itfellfromthesky.common.network.IPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;

public class ChannelHandler
extends FMLIndexedMessageToMessageCodec<IPacket> {
    public ChannelHandler(Class<? extends IPacket> ... packets) {
        for (int i = 0; i < packets.length; ++i) {
            this.addDiscriminator(i, packets[i]);
        }
    }

    public void encodeInto(ChannelHandlerContext ctx, IPacket msg, ByteBuf target) throws Exception {
        try {
            msg.writeTo(target, FMLCommonHandler.instance().getEffectiveSide());
        }
        catch (Exception e) {
            ItFellFromTheSky.console("Error writing to packet!", true);
            e.printStackTrace();
        }
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IPacket msg) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        EntityPlayer player = null;
        if (side.isServer()) {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            player = ((NetHandlerPlayServer)netHandler).field_147369_b;
        } else {
            player = this.getMCPlayer();
        }
        try {
            msg.readFrom(source, side, player);
        }
        catch (Exception e) {
            ItFellFromTheSky.console("Error reading from packet!", true);
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getMCPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void sendToDimension(IPacket packet, int dimension) {
        ItFellFromTheSky.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        ItFellFromTheSky.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        ItFellFromTheSky.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public static void sendToServer(IPacket packet) {
        ItFellFromTheSky.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        ItFellFromTheSky.channels.get(Side.CLIENT).writeAndFlush((Object)packet);
    }
}

