/*
 * Decompiled with CFR 0.152.
 */
package itfellfromthesky.common.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import itfellfromthesky.client.entity.EntitySmokeParticle;
import itfellfromthesky.common.core.ChunkLoadHandler;
import itfellfromthesky.common.entity.EntityBlock;
import itfellfromthesky.common.entity.EntityTransformer;
import itfellfromthesky.common.network.ChannelHandler;
import itfellfromthesky.common.network.PacketKillMeteorite;
import itfellfromthesky.common.network.PacketMeteoriteInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;

public class EntityMeteorite
extends Entity {
    public float rotYaw;
    public float rotPitch;
    public float prevRotYaw;
    public float prevRotPitch;
    public boolean canSetDead;
    public boolean stopped;
    public double prevInertia;
    public int stopTime;
    public double originX;
    public double originZ;
    public static float maxRotFac = 10.0f;

    public EntityMeteorite(World world) {
        super(world);
        this.func_70105_a(23.0f, 23.0f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.field_70156_m = true;
        this.field_70158_ak = true;
        this.field_70155_l = 60.0;
    }

    public EntityMeteorite(World world, double x, double y, double z) {
        this(world);
        this.originX = x;
        this.originZ = z;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(18, (Object)Float.valueOf(this.field_70146_Z.nextFloat() * (2.0f * maxRotFac) - maxRotFac));
        this.field_70180_af.func_75682_a(19, (Object)Float.valueOf(this.field_70146_Z.nextFloat() * (2.0f * maxRotFac) - maxRotFac));
        this.field_70180_af.func_75682_a(20, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(21, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(22, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(23, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(24, (Object)Float.valueOf(0.0f));
    }

    public void setRotFacYaw(float f) {
        if (this.getRotFacYaw() != f) {
            this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(f));
        }
    }

    public float getRotFacYaw() {
        return this.field_70180_af.func_111145_d(18);
    }

    public void setRotFacPitch(float f) {
        if (this.getRotFacPitch() != f) {
            this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(f));
        }
    }

    public float getRotFacPitch() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void updateMotion(double d, double d1, double d2) {
        if (this.getMoX() != d || this.getMoY() != d1 || this.getMoZ() != d2) {
            this.field_70180_af.func_75692_b(20, (Object)Float.valueOf((float)d));
            this.field_70180_af.func_75692_b(21, (Object)Float.valueOf((float)d1));
            this.field_70180_af.func_75692_b(22, (Object)Float.valueOf((float)d2));
        }
    }

    public double getMoX() {
        return this.field_70180_af.func_111145_d(20);
    }

    public double getMoY() {
        return this.field_70180_af.func_111145_d(21);
    }

    public double getMoZ() {
        return this.field_70180_af.func_111145_d(22);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70081_e(int par1) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.field_70137_T -= (double)this.field_70129_M;
            this.field_70167_r -= (double)this.field_70129_M;
            this.field_70163_u -= (double)this.field_70129_M;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.field_70163_u < -64.0) {
            this.func_70106_y();
            return;
        }
        this.prevRotYaw = this.rotYaw;
        this.prevRotPitch = this.rotPitch;
        this.field_70142_S = this.field_70169_q = this.field_70165_t;
        this.field_70137_T = this.field_70167_r = this.field_70163_u;
        this.field_70136_U = this.field_70166_s = this.field_70161_v;
        this.rotYaw += this.getRotFacYaw();
        this.rotPitch += this.getRotFacPitch();
        if (!this.field_70170_p.field_72995_K) {
            double velo;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            double degs = Math.atan2(this.field_70159_w, this.field_70179_y);
            double radius = (double)this.field_70130_N / 2.0 * 1.1;
            double halfHeight = (double)this.field_70131_O / 2.0 * 1.1;
            double radius2 = radius;
            if (this.prevInertia - 0.07 > 0.0) {
                double amp = MathHelper.func_151237_a((double)(1.0 + (this.prevInertia - 0.07) / 1.2), (double)1.0, (double)1.3);
                radius2 *= amp;
            }
            double inertiaFactor = 1.0E-4;
            double inertiaDampening = 0.0;
            double backChance = radius / radius2;
            for (double y = this.field_70163_u - halfHeight; y <= this.field_70163_u + halfHeight; y += 1.0) {
                double x1 = this.field_70165_t - (double)((int)Math.round(Math.cos(degs) * radius * (1.0 - MathHelper.func_151237_a((double)(Math.abs(y - this.field_70163_u) / halfHeight), (double)0.0, (double)1.0))));
                double x2 = this.field_70165_t + (double)((int)Math.round(Math.cos(degs) * radius * (1.0 - MathHelper.func_151237_a((double)(Math.abs(y - this.field_70163_u) / halfHeight), (double)0.0, (double)1.0))));
                double z1 = this.field_70161_v + (double)((int)Math.round(Math.sin(degs) * radius * (1.0 - MathHelper.func_151237_a((double)(Math.abs(y - this.field_70163_u) / halfHeight), (double)0.0, (double)1.0))));
                double z2 = this.field_70161_v - (double)((int)Math.round(Math.sin(degs) * radius * (1.0 - MathHelper.func_151237_a((double)(Math.abs(y - this.field_70163_u) / halfHeight), (double)0.0, (double)1.0))));
                if (x1 > x2) {
                    double xx = x2;
                    x2 = x1;
                    x1 = xx;
                }
                if (z1 > z2) {
                    double zz = z2;
                    z2 = z1;
                    z1 = zz;
                }
                double x3 = this.field_70165_t + (double)((int)Math.round(Math.sin(degs) * radius * (1.0 - MathHelper.func_151237_a((double)(Math.abs(y - this.field_70163_u) / halfHeight), (double)0.0, (double)1.0))));
                double x4 = this.field_70165_t;
                double z3 = this.field_70161_v + (double)((int)Math.round(Math.cos(degs) * radius * (1.0 - MathHelper.func_151237_a((double)(Math.abs(y - this.field_70163_u) / halfHeight), (double)0.0, (double)1.0))));
                double z4 = this.field_70161_v;
                if (x3 > x4) {
                    double xx = x4;
                    x4 = x3;
                    x3 = xx;
                }
                if (z3 > z4) {
                    double zz = z4;
                    z4 = z3;
                    z3 = zz;
                }
                if (x3 < x1) {
                    x1 = x3;
                }
                if (x4 > x2) {
                    x2 = x4;
                }
                if (z3 < z1) {
                    z1 = z3;
                }
                if (z4 > z2) {
                    z2 = z4;
                }
                for (double x = x1; x <= x2; x += 1.0) {
                    for (double z = z1; z <= z2; z += 1.0) {
                        int i = (int)Math.floor(x);
                        int j = (int)Math.floor(y);
                        int k = (int)Math.floor(z);
                        Block blk = this.field_70170_p.func_147439_a(i, j, k);
                        float blockHardness = blk.func_149712_f(this.field_70170_p, i, j, k);
                        if (!(this.func_70011_f(x, y, z) < radius) || this.field_70170_p.func_147437_c(i, j, k) || !(blockHardness >= 0.0f) || !blk.canEntityDestroy((IBlockAccess)this.field_70170_p, i, j, k, (Entity)this)) continue;
                        boolean isFluid = false;
                        if (blk.func_149688_o() == Material.field_151586_h || blk.func_149688_o() == Material.field_151587_i || FluidRegistry.lookupFluidForBlock((Block)blk) != null) {
                            isFluid = true;
                            blockHardness = 1.0f;
                        }
                        if (blockHardness > 100.0f) {
                            blockHardness *= 0.25f;
                        }
                        if (blockHardness > 10.0f) {
                            blockHardness *= 0.5f;
                        }
                        if (blockHardness > 1.0f) {
                            blockHardness *= 0.75f;
                        }
                        inertiaDampening = 1.01 * inertiaDampening + (double)(blockHardness * blockHardness) * inertiaFactor;
                        if (this.field_70146_Z.nextFloat() < 0.25f && !isFluid) {
                            double amp = 0.75;
                            double offsetX = 0.0;
                            double offsetZ = 0.0;
                            double xDist = Math.abs(this.field_70165_t - x);
                            if (x >= this.field_70165_t && x <= x2 + 1.0) {
                                offsetX = amp * Math.pow(xDist / (x2 - this.field_70165_t), 2.0);
                            } else if (x > x1 - 1.0) {
                                offsetX = -amp * Math.pow(xDist / (this.field_70165_t - x1), 2.0);
                            }
                            double zDist = Math.abs(this.field_70161_v - z);
                            if (z >= this.field_70161_v && z <= z2 + 1.0) {
                                offsetZ = amp * Math.pow(zDist / (z2 - this.field_70161_v), 2.0);
                            } else if (z > z1 - 1.0) {
                                offsetZ = -amp * Math.pow(zDist / (this.field_70161_v - z1), 2.0);
                            }
                            double mX = this.field_70159_w * (1.5 + 0.5 * this.field_70146_Z.nextDouble()) + offsetX;
                            double mZ = this.field_70179_y * (1.5 + 0.5 * this.field_70146_Z.nextDouble()) + offsetZ;
                            double mY = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) + this.field_70146_Z.nextDouble() * 0.5;
                            if (backChance != 1.0) {
                                mX = this.field_70159_w * (2.0 + 0.5 * this.field_70146_Z.nextDouble()) * -1.0 + offsetX * 0.5;
                                mZ = this.field_70179_y * (2.0 + 0.5 * this.field_70146_Z.nextDouble()) * -1.0 + offsetZ * 0.5;
                                mY = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 0.5 + this.field_70146_Z.nextDouble() * 0.5;
                            }
                            this.field_70170_p.func_72838_d((Entity)new EntityBlock(this.field_70170_p, i, j, k, mX, mY, mZ, 30));
                            continue;
                        }
                        this.field_70170_p.func_147468_f(i, j, k);
                    }
                }
            }
            this.prevInertia = inertiaDampening;
            this.field_70159_w *= 1.0 - inertiaDampening;
            this.field_70179_y *= 1.0 - inertiaDampening;
            this.field_70181_x *= 1.0 - inertiaDampening;
            this.setRotFacYaw(this.getRotFacYaw() * (float)(1.0 - 2.0 * inertiaDampening));
            this.setRotFacPitch(this.getRotFacPitch() * (float)(1.0 - 2.0 * inertiaDampening));
            if (this.field_70181_x <= -0.1) {
                this.field_70181_x += inertiaDampening > 0.04 ? 0.04 : inertiaDampening;
            }
            if (inertiaDampening > 0.0) {
                this.field_70181_x -= 0.001;
            }
            if ((velo = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) < 0.333) {
                this.field_70159_w *= 0.8;
                this.field_70181_x *= 0.8;
                this.field_70179_y *= 0.8;
                this.setRotFacYaw(this.getRotFacYaw() * 0.85f);
                this.setRotFacPitch(this.getRotFacPitch() * 0.85f);
                if (velo < 0.01) {
                    this.stopped = true;
                }
            }
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.05000000298023224 + Math.abs(this.field_70159_w), 0.0 + Math.abs(this.field_70181_x), 0.05000000298023224 + Math.abs(this.field_70179_y)));
            for (int kk = 0; kk < list.size(); ++kk) {
                Entity entity = (Entity)list.get(kk);
                if (entity instanceof EntityBlock || !entity.func_70104_M()) continue;
                this.func_70108_f(entity);
            }
            this.updateMotion(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateDataWatcher();
        } else {
            this.func_70091_d(this.getMoX(), this.getMoY(), this.getMoZ());
            if (this.field_70170_p.field_73007_j.contains((Object)this)) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72331_e(1.0, 1.0, 1.0));
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EntityTransformer) || ((EntityTransformer)((Object)list.get((int)i))).field_70173_aa <= 10) continue;
                    this.canSetDead = true;
                    this.func_70106_y();
                    return;
                }
            }
            this.spawnParticles();
        }
        if (this.stopped) {
            this.setRotFacYaw(0.0f);
            this.setRotFacPitch(0.0f);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            ++this.stopTime;
            if (!this.field_70170_p.field_72995_K) {
                if (this.stopTime == 20) {
                    EntityTransformer trans = new EntityTransformer(this, 200 + this.field_70146_Z.nextInt(400));
                    this.field_70170_p.func_72838_d((Entity)trans);
                    ChunkLoadHandler.passChunkloadTicket(this, trans);
                }
                if (this.stopTime == 25) {
                    this.func_70106_y();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        double velo = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        if (!this.stopped && this.field_70146_Z.nextDouble() < 0.25 + velo * 0.5) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntitySmokeParticle(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() * 5.0 - 2.5), this.field_70163_u + (this.field_70146_Z.nextDouble() * 5.0 - 2.5), this.field_70161_v + (this.field_70146_Z.nextDouble() * 5.0 - 2.5), 0.0, 0.0, 0.0));
        }
    }

    private void updateDataWatcher() {
        if (this.field_70180_af.func_75684_a()) {
            ChannelHandler.sendToDimension(new PacketMeteoriteInfo(this), this.field_70170_p.field_73011_w.field_76574_g);
            this.field_70180_af.func_75688_b();
        }
    }

    public void func_70108_f(Entity par1Entity) {
        double d1;
        double d0;
        double d2;
        if (par1Entity.field_70153_n != this && par1Entity.field_70154_o != this && (d2 = MathHelper.func_76132_a((double)(d0 = par1Entity.field_70165_t - this.field_70165_t), (double)(d1 = par1Entity.field_70161_v - this.field_70161_v))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            par1Entity.func_70024_g((d0 *= (double)(1.0f - this.field_70144_Y)) * 7.5, 0.5, (d1 *= (double)(1.0f - this.field_70144_Y)) * 7.5);
        }
    }

    protected void func_70037_a(NBTTagCompound var1) {
        this.rotYaw = var1.func_74760_g("rotYaw");
        this.rotPitch = var1.func_74760_g("rotPitch");
        this.field_70180_af.func_75692_b(23, (Object)Float.valueOf(this.rotYaw));
        this.field_70180_af.func_75692_b(24, (Object)Float.valueOf(this.rotPitch));
        this.originX = var1.func_74769_h("originX");
        this.originZ = var1.func_74769_h("originZ");
    }

    protected void func_70014_b(NBTTagCompound var1) {
        var1.func_74776_a("rotYaw", this.rotYaw);
        var1.func_74776_a("rotPitch", this.rotPitch);
        var1.func_74780_a("originX", this.originX);
        var1.func_74780_a("originZ", this.originZ);
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            ChannelHandler.sendToDimension(new PacketKillMeteorite(this.func_145782_y()), this.field_70170_p.field_73011_w.field_76574_g);
            ChunkLoadHandler.removeTicket(this);
            super.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && this.canSetDead) {
            super.func_70106_y();
        }
    }

    public void func_70091_d(double par1, double par3, double par5) {
        if (this.field_70145_X) {
            this.field_70121_D.func_72317_d(par1, par3, par5);
            this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
            this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
            this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
        } else {
            double d11;
            double d10;
            double d12;
            int j;
            this.field_70170_p.field_72984_F.func_76320_a("move");
            this.field_70139_V *= 0.4f;
            double d3 = this.field_70165_t;
            double d4 = this.field_70163_u;
            double d5 = this.field_70161_v;
            if (this.field_70134_J) {
                this.field_70134_J = false;
                par1 *= 0.25;
                par3 *= (double)0.05f;
                par5 *= 0.25;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            double d6 = par1;
            double d7 = par3;
            double d8 = par5;
            AxisAlignedBB axisalignedbb = this.field_70121_D.func_72329_c();
            List list = this.getCollidingBoundingBoxes(this.field_70121_D.func_72321_a(par1, par3, par5));
            for (int i = 0; i < list.size(); ++i) {
                par3 = ((AxisAlignedBB)list.get(i)).func_72323_b(this.field_70121_D, par3);
            }
            this.field_70121_D.func_72317_d(0.0, par3, 0.0);
            if (!this.field_70135_K && d7 != par3) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            }
            boolean flag1 = this.field_70122_E || d7 != par3 && d7 < 0.0;
            for (j = 0; j < list.size(); ++j) {
                par1 = ((AxisAlignedBB)list.get(j)).func_72316_a(this.field_70121_D, par1);
            }
            this.field_70121_D.func_72317_d(par1, 0.0, 0.0);
            if (!this.field_70135_K && d6 != par1) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            }
            for (j = 0; j < list.size(); ++j) {
                par5 = ((AxisAlignedBB)list.get(j)).func_72322_c(this.field_70121_D, par5);
            }
            this.field_70121_D.func_72317_d(0.0, 0.0, par5);
            if (!this.field_70135_K && d8 != par5) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            }
            if (this.field_70138_W > 0.0f && flag1 && this.field_70139_V < 0.05f && (d6 != par1 || d8 != par5)) {
                int k;
                d12 = par1;
                d10 = par3;
                d11 = par5;
                par1 = d6;
                par3 = this.field_70138_W;
                par5 = d8;
                AxisAlignedBB axisalignedbb1 = this.field_70121_D.func_72329_c();
                this.field_70121_D.func_72328_c(axisalignedbb);
                list = this.getCollidingBoundingBoxes(this.field_70121_D.func_72321_a(d6, par3, d8));
                for (k = 0; k < list.size(); ++k) {
                    par3 = ((AxisAlignedBB)list.get(k)).func_72323_b(this.field_70121_D, par3);
                }
                this.field_70121_D.func_72317_d(0.0, par3, 0.0);
                if (!this.field_70135_K && d7 != par3) {
                    par5 = 0.0;
                    par3 = 0.0;
                    par1 = 0.0;
                }
                for (k = 0; k < list.size(); ++k) {
                    par1 = ((AxisAlignedBB)list.get(k)).func_72316_a(this.field_70121_D, par1);
                }
                this.field_70121_D.func_72317_d(par1, 0.0, 0.0);
                if (!this.field_70135_K && d6 != par1) {
                    par5 = 0.0;
                    par3 = 0.0;
                    par1 = 0.0;
                }
                for (k = 0; k < list.size(); ++k) {
                    par5 = ((AxisAlignedBB)list.get(k)).func_72322_c(this.field_70121_D, par5);
                }
                this.field_70121_D.func_72317_d(0.0, 0.0, par5);
                if (!this.field_70135_K && d8 != par5) {
                    par5 = 0.0;
                    par3 = 0.0;
                    par1 = 0.0;
                }
                if (!this.field_70135_K && d7 != par3) {
                    par5 = 0.0;
                    par3 = 0.0;
                    par1 = 0.0;
                } else {
                    par3 = -this.field_70138_W;
                    for (k = 0; k < list.size(); ++k) {
                        par3 = ((AxisAlignedBB)list.get(k)).func_72323_b(this.field_70121_D, par3);
                    }
                    this.field_70121_D.func_72317_d(0.0, par3, 0.0);
                }
                if (d12 * d12 + d11 * d11 >= par1 * par1 + par5 * par5) {
                    par1 = d12;
                    par3 = d10;
                    par5 = d11;
                    this.field_70121_D.func_72328_c(axisalignedbb1);
                }
            }
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70170_p.field_72984_F.func_76320_a("rest");
            this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
            this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
            this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
            this.field_70123_F = d6 != par1 || d8 != par5;
            this.field_70124_G = d7 != par3;
            this.field_70122_E = d7 != par3 && d7 < 0.0;
            this.field_70132_H = this.field_70123_F || this.field_70124_G;
            this.func_70064_a(par3, this.field_70122_E);
            if (d6 != par1) {
                this.field_70159_w = 0.0;
            }
            if (d7 != par3) {
                this.field_70181_x = 0.0;
            }
            if (d8 != par5) {
                this.field_70179_y = 0.0;
            }
            d12 = this.field_70165_t - d3;
            d10 = this.field_70163_u - d4;
            d11 = this.field_70161_v - d5;
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            boolean flag2 = this.func_70026_G();
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    public List getCollidingBoundingBoxes(AxisAlignedBB par2AxisAlignedBB) {
        ArrayList boxes = new ArrayList();
        int i = MathHelper.func_76128_c((double)par2AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par2AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par2AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par2AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par2AxisAlignedBB.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(par2AxisAlignedBB.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!this.field_70170_p.func_72899_e(k1, 64, l1)) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    Block block = k1 >= -30000000 && k1 < 30000000 && l1 >= -30000000 && l1 < 30000000 ? this.field_70170_p.func_147439_a(k1, i2, l1) : Blocks.field_150348_b;
                    if (!((double)block.func_149712_f(this.field_70170_p, k1, i2, l1) < 0.0)) continue;
                    block.func_149743_a(this.field_70170_p, k1, i2, l1, par2AxisAlignedBB, boxes, (Entity)this);
                }
            }
        }
        return boxes;
    }
}

