/*
 * Decompiled with CFR 0.152.
 */
package photoreal.client.core;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ichun.client.render.RendererHelper;
import ichun.common.core.util.ObfHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import photoreal.common.Photoreal;
import photoreal.common.entity.EntityPhotoreal;
import photoreal.common.item.ItemCamera;

public class TickHandlerClient {
    private boolean hasShownTooltip;
    public int prevCurItem;
    public boolean currentItemIsCamera;
    public boolean renderCameraOverlay;
    public float renderTick;
    public boolean shouldLookDownCamera;
    public int lookingDownCameraTimer;
    public int flashTimeout;
    public boolean hasScreen;
    public long clock;
    public static final ResourceLocation texCamTopLeft = new ResourceLocation("photoreal", "textures/camera/topleft.png");
    public static final ResourceLocation texCamTop = new ResourceLocation("photoreal", "textures/camera/top.png");
    public static final ResourceLocation texCamTopRight = new ResourceLocation("photoreal", "textures/camera/topright.png");
    public static final ResourceLocation texCamRight = new ResourceLocation("photoreal", "textures/camera/right.png");
    public static final ResourceLocation texCamBottomRight = new ResourceLocation("photoreal", "textures/camera/bottomright.png");
    public static final ResourceLocation texCamBottom = new ResourceLocation("photoreal", "textures/camera/bottom.png");
    public static final ResourceLocation texCamBottomLeft = new ResourceLocation("photoreal", "textures/camera/bottomleft.png");
    public static final ResourceLocation texCamLeft = new ResourceLocation("photoreal", "textures/camera/left.png");
    public static final ResourceLocation texCamCentral = new ResourceLocation("photoreal", "textures/camera/central.png");
    public static final ResourceLocation texCamVignette = new ResourceLocation("photoreal", "textures/camera/vignette.png");
    public static final ResourceLocation texCamFlash = new ResourceLocation("photoreal", "textures/camera/flash.png");
    public int screenWidth;
    public int screenHeight;
    public Framebuffer cameraPoV;
    public ArrayList<EntityPhotoreal> pendingRenders;

    public TickHandlerClient() {
        this.screenWidth = Minecraft.func_71410_x().field_71443_c;
        this.screenHeight = Minecraft.func_71410_x().field_71440_d;
        this.cameraPoV = RendererHelper.createFrameBuffer((String)"Photoreal", (boolean)true);
        this.pendingRenders = new ArrayList();
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            if (event.phase == TickEvent.Phase.START) {
                this.renderTick = event.renderTickTime;
                for (int i = this.pendingRenders.size() - 1; i >= 0; --i) {
                    EntityPhotoreal photo = this.pendingRenders.get(i);
                    if (photo.field_70170_p != mc.field_71441_e) {
                        this.pendingRenders.remove(i);
                        continue;
                    }
                    if (photo.tex == null) {
                        photo.rendered = true;
                        this.pendingRenders.remove(i);
                        continue;
                    }
                    GL11.glPushMatrix();
                    GL11.glLoadIdentity();
                    photo.tex.func_147610_a(true);
                    GL11.glClear((int)17664);
                    GL11.glMatrixMode((int)5889);
                    GL11.glLoadIdentity();
                    GL11.glMatrixMode((int)5888);
                    GL11.glLoadIdentity();
                    GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
                    EntityLivingBase viewEntity = mc.field_71451_h;
                    double posX = viewEntity.field_70165_t;
                    double posY = viewEntity.field_70163_u;
                    double posZ = viewEntity.field_70161_v;
                    float rotYaw = viewEntity.field_70177_z;
                    float rotPitch = viewEntity.field_70125_A;
                    float progress = 1.0f - (float)this.lookingDownCameraTimer / 10.0f;
                    EntityOtherPlayerMP fakePlayer = new EntityOtherPlayerMP((World)mc.field_71441_e, new GameProfile("MorphClientDummyPlayer", mc.field_71439_g.func_70005_c_()));
                    mc.field_71451_h = fakePlayer;
                    List ents = photo.field_70170_p.func_72839_b((Entity)photo, photo.field_70121_D.func_72314_b(0.1, 0.1, 0.1));
                    for (Object obj : ents) {
                        if (obj == mc.field_71439_g) {
                            mc.field_71451_h = viewEntity;
                            continue;
                        }
                        Entity ent = (Entity)obj;
                        ent.field_70163_u -= 10.0;
                    }
                    fakePlayer.field_70165_t = photo.func_70096_w().func_111145_d(16);
                    fakePlayer.field_70163_u = photo.func_70096_w().func_111145_d(17);
                    fakePlayer.field_70161_v = photo.func_70096_w().func_111145_d(18);
                    fakePlayer.field_70177_z = photo.func_70096_w().func_111145_d(19);
                    fakePlayer.field_70125_A = photo.func_70096_w().func_111145_d(20);
                    boolean hideGui = mc.field_71474_y.field_74319_N;
                    mc.field_71474_y.field_74319_N = true;
                    int tp = mc.field_71474_y.field_74320_O;
                    mc.field_71474_y.field_74320_O = 0;
                    mc.field_71460_t.func_78471_a(1.0f, 0L);
                    if (photo.fogR == 1.0 && photo.fogG == 1.0 && photo.fogB == 1.0) {
                        try {
                            photo.fogR = ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)mc.field_71460_t, (String[])ObfHelper.fogColorRed)).floatValue();
                            photo.fogG = ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)mc.field_71460_t, (String[])ObfHelper.fogColorGreen)).floatValue();
                            photo.fogB = ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)mc.field_71460_t, (String[])ObfHelper.fogColorBlue)).floatValue();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ObfHelper.obfWarning();
                            Vec3 fog = Minecraft.func_71410_x().field_71441_e.func_72948_g(1.0f);
                            photo.fogR = fog.field_72450_a;
                            photo.fogG = fog.field_72448_b;
                            photo.fogB = fog.field_72449_c;
                        }
                    }
                    mc.field_71474_y.field_74320_O = tp;
                    mc.field_71474_y.field_74319_N = hideGui;
                    mc.field_71451_h = viewEntity;
                    viewEntity.field_70165_t = posX;
                    viewEntity.field_70163_u = posY;
                    viewEntity.field_70161_v = posZ;
                    viewEntity.field_70177_z = rotYaw;
                    viewEntity.field_70125_A = rotPitch;
                    for (Object obj : ents) {
                        if (obj == mc.field_71439_g) {
                            mc.field_71451_h = viewEntity;
                            continue;
                        }
                        Entity ent = (Entity)obj;
                        ent.field_70163_u += 10.0;
                    }
                    EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                    GL11.glPopMatrix();
                    photo.rendered = true;
                    if (photo.func_70096_w().func_75679_c(23) == 0) {
                        photo.flashTimeout = 3;
                    }
                    this.pendingRenders.remove(i);
                }
                ItemStack currentInv = mc.field_71439_g.func_71045_bC();
                if (currentInv != null && currentInv.func_77973_b() instanceof ItemCamera) {
                    mc.field_71442_b.func_78767_c();
                    if (this.prevCurItem == mc.field_71439_g.field_71071_by.field_70461_c) {
                        try {
                            ObfuscationReflectionHelper.setPrivateValue(ItemRenderer.class, (Object)mc.field_71460_t.field_78516_c, (Object)Float.valueOf(1.0f), (String[])ObfHelper.equippedProgress);
                            ObfuscationReflectionHelper.setPrivateValue(ItemRenderer.class, (Object)mc.field_71460_t.field_78516_c, (Object)Float.valueOf(1.0f), (String[])ObfHelper.prevEquippedProgress);
                            ObfuscationReflectionHelper.setPrivateValue(ItemRenderer.class, (Object)mc.field_71460_t.field_78516_c, (Object)mc.field_71439_g.field_71071_by.func_70448_g(), (String[])ObfHelper.itemToRender);
                            ReflectionHelper.setPrivateValue(ItemRenderer.class, (Object)mc.field_71460_t.field_78516_c, (Object)mc.field_71439_g.field_71071_by.field_70461_c, (String[])ObfHelper.equippedItemSlot);
                            int showName = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiIngame.class, (Object)mc.field_71456_v, (String[])ObfHelper.showNameTime);
                            if (showName == 0) {
                                this.hasShownTooltip = true;
                            }
                            if (this.hasShownTooltip) {
                                ReflectionHelper.setPrivateValue(GuiIngame.class, (Object)mc.field_71456_v, (Object)0, (String[])ObfHelper.showNameTime);
                            }
                        }
                        catch (Exception e) {
                            ObfHelper.obfWarning();
                            e.printStackTrace();
                        }
                    }
                    mc.field_71439_g.field_82175_bq = false;
                    mc.field_71439_g.field_110158_av = 0;
                    mc.field_71439_g.field_70733_aJ = 0.0f;
                }
                boolean bl = this.currentItemIsCamera = currentInv != null && currentInv.func_77973_b() instanceof ItemCamera;
                if (this.prevCurItem != mc.field_71439_g.field_71071_by.field_70461_c) {
                    if (mc.field_71439_g.field_71071_by.field_70461_c >= 0 && mc.field_71439_g.field_71071_by.field_70461_c <= 9) {
                        try {
                            if (((Float)ObfuscationReflectionHelper.getPrivateValue(ItemRenderer.class, (Object)mc.field_71460_t.field_78516_c, (String[])ObfHelper.equippedProgress)).floatValue() >= 1.0f) {
                                this.prevCurItem = mc.field_71439_g.field_71071_by.field_70461_c;
                            }
                        }
                        catch (Exception e) {
                            ObfHelper.obfWarning();
                            e.printStackTrace();
                        }
                    }
                    this.currentItemIsCamera = false;
                }
                if (!this.currentItemIsCamera) {
                    this.shouldLookDownCamera = false;
                    this.renderCameraOverlay = false;
                    this.lookingDownCameraTimer = 0;
                }
            } else if ((mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat) && mc.field_71474_y.field_74320_O == 0 && this.renderCameraOverlay) {
                ScaledResolution scaledresolution = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
                int width = scaledresolution.func_78326_a();
                int height = scaledresolution.func_78328_b();
                double size = 48.0;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                GL11.glDisable((int)3008);
                RendererHelper.drawColourOnScreen((int)32810, (int)35, (double)0.0, (double)0.0, (double)width, (double)height, (double)90.0);
                RendererHelper.drawTextureOnScreen((ResourceLocation)texCamVignette, (double)0.0, (double)0.0, (double)width, (double)height, (double)90.0);
                float flashProg = (float)Math.pow(((float)this.flashTimeout - this.renderTick) / 3.0f, 2.0);
                if (flashProg < 0.0f || this.flashTimeout == 0) {
                    flashProg = 0.0f;
                }
                RendererHelper.drawColourOnScreen((int)0xFFFFFF, (int)((int)(240.0f * flashProg)), (double)0.0, (double)0.0, (double)width, (double)height, (double)90.0);
                float brightness = 0.3f;
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                RendererHelper.drawTextureOnScreen((ResourceLocation)texCamTop, (double)(size / 2.0), (double)0.0, (double)((double)width - size), (double)size, (double)90.0);
                RendererHelper.drawTextureOnScreen((ResourceLocation)texCamBottom, (double)(size / 2.0), (double)((double)height - size), (double)((double)width - size), (double)size, (double)90.0);
                RendererHelper.drawTextureOnScreen((ResourceLocation)texCamLeft, (double)0.0, (double)(size / 2.0), (double)size, (double)((double)height - size), (double)90.0);
                RendererHelper.drawTextureOnScreen((ResourceLocation)texCamRight, (double)((double)width - size), (double)(size / 2.0), (double)size, (double)((double)height - size), (double)90.0);
                RendererHelper.drawTextureOnScreen((ResourceLocation)texCamTopLeft, (double)0.0, (double)0.0, (double)size, (double)size, (double)90.0);
                RendererHelper.drawTextureOnScreen((ResourceLocation)texCamBottomLeft, (double)0.0, (double)((double)height - size), (double)size, (double)size, (double)90.0);
                RendererHelper.drawTextureOnScreen((ResourceLocation)texCamTopRight, (double)((double)width - size), (double)0.0, (double)size, (double)size, (double)90.0);
                RendererHelper.drawTextureOnScreen((ResourceLocation)texCamBottomRight, (double)((double)width - size), (double)((double)height - size), (double)size, (double)size, (double)90.0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                double centralSize = 48.0;
                RendererHelper.drawTextureOnScreen((ResourceLocation)texCamCentral, (double)((double)(width / 2) - centralSize / 2.0), (double)((double)(height / 2) - centralSize / 2.0), (double)centralSize, (double)centralSize, (double)90.0);
                String reso = Blocks.field_150344_f.func_149691_a(0, 0).func_94216_b() + "x";
                int resoSize = mc.field_71466_p.func_78256_a(reso);
                double vertAlignReso = 27.0;
                double horiAlignReso = 0.0;
                RendererHelper.drawColourOnScreen((int)8486514, (int)255, (double)(size + horiAlignReso - 6.0), (double)((double)height - size - vertAlignReso - 2.5), (double)(resoSize + 12), (double)13.0, (double)90.0);
                RendererHelper.drawColourOnScreen((int)0, (int)255, (double)(size + horiAlignReso - 5.0), (double)((double)height - size - vertAlignReso - 1.5), (double)3.0, (double)2.0, (double)90.0);
                RendererHelper.drawColourOnScreen((int)0, (int)255, (double)(size + horiAlignReso - 5.0), (double)((double)height - size - vertAlignReso + 1.5), (double)3.0, (double)2.0, (double)90.0);
                RendererHelper.drawColourOnScreen((int)0, (int)255, (double)(size + horiAlignReso - 5.0), (double)((double)height - size - vertAlignReso + 4.5), (double)3.0, (double)2.0, (double)90.0);
                RendererHelper.drawColourOnScreen((int)0, (int)255, (double)(size + horiAlignReso - 5.0), (double)((double)height - size - vertAlignReso + 7.5), (double)3.0, (double)2.0, (double)90.0);
                RendererHelper.drawColourOnScreen((int)0, (int)255, (double)(size + horiAlignReso + (double)resoSize + 2.0), (double)((double)height - size - vertAlignReso - 1.5), (double)3.0, (double)2.0, (double)90.0);
                RendererHelper.drawColourOnScreen((int)0, (int)255, (double)(size + horiAlignReso + (double)resoSize + 2.0), (double)((double)height - size - vertAlignReso + 1.5), (double)3.0, (double)2.0, (double)90.0);
                RendererHelper.drawColourOnScreen((int)0, (int)255, (double)(size + horiAlignReso + (double)resoSize + 2.0), (double)((double)height - size - vertAlignReso + 4.5), (double)3.0, (double)2.0, (double)90.0);
                RendererHelper.drawColourOnScreen((int)0, (int)255, (double)(size + horiAlignReso + (double)resoSize + 2.0), (double)((double)height - size - vertAlignReso + 7.5), (double)3.0, (double)2.0, (double)90.0);
                mc.field_71466_p.func_78276_b(reso, (int)(size + horiAlignReso), (int)((double)height - size - vertAlignReso), 0x313131);
                RendererHelper.drawColourOnScreen((int)8486514, (int)255, (double)(size + horiAlignReso - 6.0), (double)((double)height - size - vertAlignReso + 15.0 - 2.5), (double)(mc.field_71466_p.func_78256_a("Auto") + 12), (double)13.0, (double)90.0);
                mc.field_71466_p.func_78276_b("Auto", (int)(size + horiAlignReso), (int)((double)height - size - vertAlignReso + 15.0), 0x313131);
                mc.field_71466_p.func_78276_b(mc.field_71441_e.func_72820_D() % 24000L < 12000L ? "F2.9" : "F2.4", (int)(size + horiAlignReso - 6.0), (int)((double)height - size - vertAlignReso + 29.0), 8486514);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ItemStack is = mc.field_71439_g.func_71045_bC();
                if (is != null && is.func_77973_b() instanceof ItemCamera && is.func_77978_p() != null && (is.func_77978_p().func_74762_e("recharge") > 0 && (long)mc.field_71439_g.field_70173_aa % 20L < 10L || is.func_77978_p().func_74762_e("recharge") == 0)) {
                    if (is.func_77978_p().func_74762_e("recharge") > 0) {
                        GL11.glColor4f((float)1.0f, (float)0.2f, (float)0.2f, (float)1.0f);
                    }
                    RendererHelper.drawTextureOnScreen((ResourceLocation)texCamFlash, (double)(size + horiAlignReso + 20.0), (double)((double)height - size - vertAlignReso + 29.0), (double)7.0, (double)7.0, (double)90.0);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)true);
                GL11.glDisable((int)3042);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        if (event.phase == TickEvent.Phase.END && world != null) {
            if (this.cameraPoV != null && world.func_72820_D() % (long)(20 - Photoreal.config.getInt("cameraFreq") + 1) == 0L) {
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                this.cameraPoV.func_147610_a(true);
                GL11.glClear((int)17664);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
                EntityLivingBase viewEntity = mc.field_71451_h;
                double posX = viewEntity.field_70165_t;
                double posY = viewEntity.field_70163_u;
                double posZ = viewEntity.field_70161_v;
                float rotYaw = viewEntity.field_70177_z;
                float progress = 1.0f - (float)this.lookingDownCameraTimer / 10.0f;
                viewEntity.field_70165_t -= (double)(MathHelper.func_76134_b((float)(viewEntity.field_70177_z / 180.0f * (float)Math.PI)) * 0.18f) * (double)progress;
                viewEntity.field_70163_u -= 0.1 * (double)progress;
                viewEntity.field_70161_v -= (double)(MathHelper.func_76126_a((float)(viewEntity.field_70177_z / 180.0f * (float)Math.PI)) * 0.18f) * (double)progress;
                viewEntity.field_70165_t += (double)(MathHelper.func_76126_a((float)(viewEntity.field_70177_z / 180.0f * (float)Math.PI)) * -0.2f) * (double)progress;
                viewEntity.field_70161_v -= (double)(MathHelper.func_76134_b((float)(viewEntity.field_70177_z / 180.0f * (float)Math.PI)) * -0.2f) * (double)progress;
                viewEntity.field_70177_z -= 10.0f * progress;
                boolean hideGui = mc.field_71474_y.field_74319_N;
                mc.field_71474_y.field_74319_N = true;
                int tp = mc.field_71474_y.field_74320_O;
                mc.field_71474_y.field_74320_O = 0;
                mc.field_71460_t.func_78471_a(1.0f, 0L);
                mc.field_71474_y.field_74320_O = tp;
                mc.field_71474_y.field_74319_N = hideGui;
                viewEntity.field_70165_t = posX;
                viewEntity.field_70163_u = posY;
                viewEntity.field_70161_v = posZ;
                viewEntity.field_70177_z = rotYaw;
                this.cameraPoV.func_147609_e();
                GL11.glPopMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (this.clock != mc.field_71441_e.func_72820_D() || !world.func_82736_K().func_82766_b("doDaylightCycle")) {
                this.clock = world.func_72820_D();
                if (this.shouldLookDownCamera) {
                    ++this.lookingDownCameraTimer;
                    if (this.lookingDownCameraTimer == 10) {
                        this.renderCameraOverlay = true;
                    }
                    if (this.lookingDownCameraTimer > 10) {
                        this.lookingDownCameraTimer = 10;
                    }
                } else {
                    --this.lookingDownCameraTimer;
                    if (this.lookingDownCameraTimer < 0) {
                        this.lookingDownCameraTimer = 0;
                    }
                }
                if (this.flashTimeout > 0) {
                    --this.flashTimeout;
                }
            }
            this.hasScreen = mc.field_71462_r != null;
        }
    }
}

