/*
 * Decompiled with CFR 0.152.
 */
package photoreal.client.render;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import photoreal.client.model.ModelCamera;
import photoreal.common.Photoreal;

public class RenderCameraItem
implements IItemRenderer {
    private static final ResourceLocation texCamera = new ResourceLocation("photoreal", "textures/model/camera.png");
    private ModelCamera modelCamera = new ModelCamera();
    private Random rand = new Random();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_ROTATION: 
            case ENTITY_BOBBING: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        boolean isFirstPerson = false;
        int renderType = 0;
        switch (type) {
            case ENTITY: {
                renderType = 2;
            }
            case INVENTORY: {
                data = new Object[]{data[0], null};
                if (renderType == 0) {
                    renderType = 1;
                }
            }
            case EQUIPPED_FIRST_PERSON: {
                if (renderType == 0) {
                    isFirstPerson = true;
                }
            }
            case EQUIPPED: {
                float scale1;
                float offset;
                float prog2;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                float progress = 0.0f;
                if (isFirstPerson) {
                    progress = (float)Math.pow((double)((float)Photoreal.proxy.tickHandlerClient.lookingDownCameraTimer + (Photoreal.proxy.tickHandlerClient.shouldLookDownCamera ? Photoreal.proxy.tickHandlerClient.renderTick : -Photoreal.proxy.tickHandlerClient.renderTick)) / 10.0, 2.0);
                }
                if (progress > 1.0f) {
                    progress = 1.0f;
                }
                if (Photoreal.proxy.tickHandlerClient.lookingDownCameraTimer == 0) {
                    progress = 0.0f;
                }
                if ((prog2 = progress) > (offset = 0.75f)) {
                    prog2 = (0.25f - (prog2 - offset)) / 0.25f * offset;
                }
                prog2 = (float)Math.pow(prog2 / offset, 0.75);
                GL11.glRotatef((float)(-18.0f * progress), (float)0.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)(-10.0f - 1.0f * progress), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(180.0f + 8.0f * progress), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-0.85f + 0.28f * progress - 0.24f * prog2), (float)(0.18f - 0.67f * progress), (float)(0.15f - 0.89f * progress));
                if (isFirstPerson) {
                    GL11.glRotatef((float)-10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.06f, (float)-0.1f, (float)-0.15f);
                }
                float f = isFirstPerson ? 1.5f : (renderType == 1 ? 23.0f : (scale1 = renderType == 2 ? 1.5f : 0.8f));
                if (renderType == 1) {
                    GL11.glScalef((float)(-scale1), (float)(-scale1), (float)(-scale1));
                    GL11.glRotatef((float)-160.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.08f, (float)0.55f, (float)-0.4f);
                } else {
                    if (renderType == 2) {
                        GL11.glTranslatef((float)0.2f, (float)-0.5f, (float)0.0f);
                    }
                    GL11.glScalef((float)scale1, (float)scale1, (float)scale1);
                }
                if (isFirstPerson && (!Photoreal.proxy.tickHandlerClient.shouldLookDownCamera || Photoreal.proxy.tickHandlerClient.lookingDownCameraTimer != 10)) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(Minecraft.func_71410_x().field_71439_g.func_110306_p());
                    this.modelCamera.renderArms(0.0625f);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texCamera);
                this.modelCamera.renderCamera(0.0625f, isFirstPerson);
                GL11.glDisable((int)3042);
                if (renderType == 1) {
                    GL11.glScalef((float)(-scale1), (float)(-scale1), (float)(-scale1));
                }
                GL11.glPopMatrix();
                break;
            }
        }
    }
}

