/*
 * Decompiled with CFR 0.152.
 */
package sanandreasp.mods.ParticleDecoMod.registry;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import sanandreasp.mods.managers.SAP_ConfigManagerII;
import sanandreasp.mods.managers.SAP_LanguageManager;
import sanandreasp.mods.managers.SAP_UpdateManager;

public class ManagerPackHelper {
    public boolean loading = true;
    private Object cfgmanInst;
    private Object updmanInst;
    private Object langmanInst;

    public void checkManPack(String modname) {
        try {
            Mod s;
            Class<?> cls = Class.forName("sanandreasp.mods.managers.SAP_ManagerRegistry");
            if (cls == null) {
                this.loading = false;
                this.stopLoad(String.format("You forgot to install the Manager Pack!\nPlease download the latest version from http://goo.gl/WZwtZ\n- Minecraft will load without this mod: >> %s <<! -", modname), "No Manager Pack!");
            }
            if ((s = cls.getAnnotation(Mod.class)) != null) {
                int verErr = this.checkVersion(s.version(), "1.4");
                if (verErr > 1) {
                    this.loading = false;
                    this.stopLoad(String.format("Wrong version of the Manager Pack!\nPlease download the latest version from http://goo.gl/WZwtZ\n- Minecraft will load without this mod: >> %s <<! -", modname), "Manager Pack outdated!");
                } else if (verErr == 1) {
                    FMLLog.warning((String)"No up-to-date SAP Manager Pack!\nPlease get the latest version now at: http://goo.gl/WZwtZ\n- Expect bugs and crashes!", (Object[])new Object[0]);
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.stopLoad(String.format("You forgot to install the Manager Pack!\nPlease download the latest version from http://goo.gl/WZwtZ\n- Minecraft will load without this mod: >> %s <<! -", modname), "No Manager Pack!");
            this.loading = false;
        }
    }

    public void initMan(SAP_ConfigManagerII cfgman, SAP_LanguageManager langman, SAP_UpdateManager updman) {
        this.cfgmanInst = cfgman;
        this.langmanInst = langman;
        this.updmanInst = updman;
    }

    public SAP_ConfigManagerII getCfgMan() {
        return (SAP_ConfigManagerII)(this.cfgmanInst != null && this.cfgmanInst instanceof SAP_ConfigManagerII ? this.cfgmanInst : null);
    }

    public SAP_LanguageManager getLangMan() {
        return (SAP_LanguageManager)(this.langmanInst != null && this.langmanInst instanceof SAP_LanguageManager ? this.langmanInst : null);
    }

    public SAP_UpdateManager getUpdMan() {
        return (SAP_UpdateManager)(this.updmanInst != null && this.updmanInst instanceof SAP_UpdateManager ? this.updmanInst : null);
    }

    private void stopLoad(final String msg, final String title) {
        FMLLog.severe((String)(title + " Please get the latest version now at: http://goo.gl/WZwtZ"), (Object[])new Object[0]);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JOptionPane pane = new JOptionPane(msg, 0);
                    JDialog dlg = pane.createDialog(title);
                    dlg.setModal(false);
                    dlg.setVisible(true);
                }
            }).start();
        }
    }

    private int checkVersion(String currVer, String expectedVer) {
        String[] currSplit = currVer.split("\\.");
        String[] exptSplit = expectedVer.split("\\.");
        int majDiff = Integer.parseInt(currSplit[0]) - Integer.parseInt(exptSplit[0]);
        int minDiff = Integer.parseInt(currSplit[1]) - Integer.parseInt(exptSplit[1]);
        int revDiff = (currSplit.length < 3 ? 0 : Integer.parseInt(currSplit[2])) - (exptSplit.length < 3 ? 0 : Integer.parseInt(exptSplit[2]));
        if (majDiff < 0) {
            return 3;
        }
        if (minDiff < 0 && majDiff == 0) {
            return 2;
        }
        if (revDiff < 0 && minDiff == 0 && majDiff == 0) {
            return 1;
        }
        return 0;
    }
}

