/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.worldgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tw.oresplus.api.Ores;
import tw.oresplus.worldgen.OreGenClass;
import tw.oresplus.worldgen.WorldGenCore;

public class WorldGenOre {
    private OreGenClass ore;
    boolean enabled = true;
    Block block;
    Block target;
    public boolean doRegen;
    public String regenKey;
    public int dimension;
    public Collection<String> biomeList;
    public HashMap<Integer, ArrayList<ChunkCoordIntPair>> regenList = new HashMap();

    public WorldGenOre(OreGenClass genOre) {
        this.ore = genOre;
        this.block = Ores.manager.getOre(genOre.oreName);
        this.doRegen = genOre.doRegen;
        this.regenKey = genOre.regenKey;
        this.dimension = genOre.dimension;
        switch (genOre.dimension) {
            case -1: {
                this.target = Blocks.field_150424_aL;
                WorldGenCore.oreGenNether.add(this);
                break;
            }
            case 1: {
                this.target = Blocks.field_150377_bs;
                WorldGenCore.oreGenEnd.add(this);
                break;
            }
            default: {
                this.target = Blocks.field_150348_b;
                WorldGenCore.oreGenOverworld.add(this);
            }
        }
        this.biomeList = this.ore.oreName.equals("oreBauxite") ? WorldGenCore.biomeListBauxite : (this.ore.oreName.equals("oreCassiterite") ? WorldGenCore.biomeListCassiterite : (this.ore.oreName.equals("oreColdiron") ? WorldGenCore.biomeListColdiron : (this.ore.oreName.equals("oreMithral") ? WorldGenCore.biomeListMithral : (this.ore.oreName.equals("oreNickel") ? WorldGenCore.biomeListNickel : (this.ore.oreName.equals("oreRuby") ? WorldGenCore.biomeListRuby : (this.ore.oreName.equals("oreSapphire") ? WorldGenCore.biomeListSapphire : (this.ore.oreName.equals("oreSaltpeter") ? WorldGenCore.biomeListSaltpeter : (this.ore.oreName.equals("oreTetrahedrite") ? WorldGenCore.biomeListTetrahedrite : new ArrayList<String>()))))))));
    }

    public boolean generate(World world, Random random, int chunkX, int chunkZ) {
        int biomeX = chunkX * 16 + 8;
        int biomeZ = chunkZ * 16 + 8;
        String biomeName = world.func_72807_a((int)biomeX, (int)biomeZ).field_76791_y;
        if (!this.ore.enabled) {
            return false;
        }
        if (this.biomeList.isEmpty() || this.biomeList.contains(biomeName)) {
            int actualVeins = this.ore.numVeins * this.ore.density / 100;
            int seaLevel = world.field_73011_w.func_76557_i() + 1;
            block11: for (int a = 0; a < actualVeins; ++a) {
                int x = chunkX + random.nextInt(16);
                int y = (random.nextInt(this.ore.maxY - this.ore.minY) + this.ore.minY) * seaLevel / 64;
                int z = chunkZ + random.nextInt(16);
                switch (this.ore.veinSize) {
                    case 1: {
                        if (!world.func_147439_a(x, y, z).isReplaceableOreGen(world, x, y, z, this.target)) continue block11;
                        switch (this.ore.genType) {
                            case NEAR_LAVA: {
                                if (!this.isNearLava(world, x, y, z)) continue block11;
                                world.func_147465_d(x, y, z, this.block, 0, 2);
                                break;
                            }
                            case UNDER_LAVA: {
                                if (!world.func_147439_a(x, y + 1, z).equals(Blocks.field_150353_l)) continue block11;
                                world.func_147465_d(x, y, z, this.block, 0, 2);
                                break;
                            }
                            default: {
                                world.func_147465_d(x, y, z, this.block, 0, 2);
                                break;
                            }
                        }
                        continue block11;
                    }
                    default: {
                        float f = random.nextFloat() * (float)Math.PI;
                        double d0 = (float)(x + 8) + MathHelper.func_76126_a((float)f) * (float)this.ore.veinSize / 8.0f;
                        double d1 = (float)(x + 8) - MathHelper.func_76126_a((float)f) * (float)this.ore.veinSize / 8.0f;
                        double d2 = (float)(z + 8) + MathHelper.func_76134_b((float)f) * (float)this.ore.veinSize / 8.0f;
                        double d3 = (float)(z + 8) - MathHelper.func_76134_b((float)f) * (float)this.ore.veinSize / 8.0f;
                        double d4 = y + random.nextInt(3) - 2;
                        double d5 = y + random.nextInt(3) - 2;
                        for (int l = 0; l <= this.ore.veinSize; ++l) {
                            double d6 = d0 + (d1 - d0) * (double)l / (double)this.ore.veinSize;
                            double d7 = d4 + (d5 - d4) * (double)l / (double)this.ore.veinSize;
                            double d8 = d2 + (d3 - d2) * (double)l / (double)this.ore.veinSize;
                            double d9 = random.nextDouble() * (double)this.ore.veinSize / 16.0;
                            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.ore.veinSize)) + 1.0f) * d9 + 1.0;
                            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.ore.veinSize)) + 1.0f) * d9 + 1.0;
                            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
                            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
                            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
                            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
                            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
                            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
                            for (int k2 = i1; k2 <= l1; ++k2) {
                                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                                if (!(d12 * d12 < 1.0)) continue;
                                for (int l2 = j1; l2 <= i2; ++l2) {
                                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                                    block15: for (int i3 = k1; i3 <= j2; ++i3) {
                                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || !world.func_147439_a(k2, l2, i3).isReplaceableOreGen(world, k2, l2, i3, this.target)) continue;
                                        switch (this.ore.genType) {
                                            case NEAR_LAVA: {
                                                if (!this.isNearLava(world, k2, l2, i3)) continue block15;
                                                world.func_147465_d(k2, l2, i3, this.block, 0, 2);
                                                continue block15;
                                            }
                                            case UNDER_LAVA: {
                                                if (!world.func_147439_a(k2, l2 + 1, i3).equals(Blocks.field_150353_l)) continue block15;
                                                world.func_147465_d(k2, l2, i3, this.block, 0, 2);
                                                continue block15;
                                            }
                                            default: {
                                                world.func_147465_d(k2, l2, i3, this.block, 0, 2);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public String getOreName() {
        return this.ore.name;
    }

    private boolean isNearLava(World world, int nearX, int nearY, int nearZ) {
        for (int k = 1; k <= 4; ++k) {
            if (world.func_147439_a(nearX, nearY - k, nearZ).equals(Blocks.field_150353_l)) {
                return true;
            }
            if (world.func_147439_a(nearX, nearY - k, nearZ).isAir((IBlockAccess)world, nearX, nearY - k, nearZ)) continue;
            return false;
        }
        return false;
    }
}

