/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.worldgen;

import java.util.Random;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import tw.oresplus.items.Items;
import tw.oresplus.items.OreItems;
import tw.oresplus.ores.GemstoneOres;
import tw.oresplus.ores.MetallicOres;
import tw.oresplus.recipes.OreItemStack;

public class OreChestLoot {
    private static String[] randomChests = new String[]{"dungeonChest", "mineshaftCorridor", "pyramidDesertyChest", "pyramidJungleChest", "strongholdCorridor", "strongholdCrossing", "strongholdLibrary"};
    private static OreItemStack[] commonItems = new OreItemStack[]{MetallicOres.Copper.ingot, MetallicOres.Lead.ingot, MetallicOres.Nickel.ingot, MetallicOres.Silver.ingot, MetallicOres.Tin.ingot, MetallicOres.Zinc.ingot};
    private static OreItemStack[] uncommonItems = new OreItemStack[]{MetallicOres.Aluminium.ingot, MetallicOres.Brass.ingot, MetallicOres.Bronze.ingot, MetallicOres.Electrum.ingot, MetallicOres.Manganese.ingot, MetallicOres.Osmium.ingot, GemstoneOres.Amethyst.gem};
    private static OreItemStack[] rareItems = new OreItemStack[]{MetallicOres.Ardite.ingot, MetallicOres.Cobalt.ingot, MetallicOres.Coldiron.ingot, MetallicOres.Platinum.ingot, GemstoneOres.GreenSapphire.gem, GemstoneOres.Ruby.gem, GemstoneOres.Sapphire.gem, GemstoneOres.Topaz.gem};
    private static OreItemStack[] ultraRareItems = new OreItemStack[]{MetallicOres.Adamantine.ingot, MetallicOres.Mithral.ingot, OreItems.gemRedGarnet.item, OreItems.gemYellowGarnet.item};
    private static OreItemStack[] commonSmithItems = new OreItemStack[]{MetallicOres.Copper.ingot, MetallicOres.Lead.ingot, MetallicOres.Nickel.ingot, MetallicOres.Silver.ingot, MetallicOres.Tin.ingot, MetallicOres.Zinc.ingot};
    private static OreItemStack[] uncommonSmithItems = new OreItemStack[]{MetallicOres.Aluminium.ingot, MetallicOres.Brass.ingot, MetallicOres.Electrum.ingot, MetallicOres.Manganese.ingot, MetallicOres.Osmium.ingot, Items.toolAdamantineAxe, Items.toolAdamantineHoe, Items.toolAdamantinePickaxe, Items.toolAdamantineSpade, Items.toolColdironAxe, Items.toolColdironHoe, Items.toolColdironPickaxe, Items.toolColdironSpade, Items.toolMithralAxe, Items.toolMithralHoe, Items.toolMithralPickaxe, Items.toolMithralSpade};
    private static OreItemStack[] rareSmithItems = new OreItemStack[]{MetallicOres.Adamantine.ingot, MetallicOres.Ardite.ingot, MetallicOres.Cobalt.ingot, MetallicOres.Coldiron.ingot, MetallicOres.Mithral.ingot, MetallicOres.Platinum.ingot, Items.toolAdamantineSword, Items.toolColdironSword, Items.toolMithralSword};
    private static OreItemStack[] ultraRareSmithItems = new OreItemStack[]{Items.armorAdamantineBoots, Items.armorAdamantineChestplate, Items.armorAdamantineHelmet, Items.armorAdamantineLeggings, Items.armorColdironBoots, Items.armorColdironChestplate, Items.armorColdironHelmet, Items.armorColdironLeggings, Items.armorMithralBoots, Items.armorMithralChestplate, Items.armorMithralHelmet, Items.armorMithralLeggings};

    public static void registerChestLoot() {
        Random rand = new Random();
        for (String string : randomChests) {
            for (OreItemStack item : commonItems) {
                ChestGenHooks.addItem((String)string, (WeightedRandomChestContent)new WeightedRandomChestContent(item.newStack(2 + rand.nextInt(4)), 1, 3, 5));
            }
            for (OreItemStack item : uncommonItems) {
                ChestGenHooks.addItem((String)string, (WeightedRandomChestContent)new WeightedRandomChestContent(item.newStack(1 + rand.nextInt(4)), 1, 2, 4));
            }
            for (OreItemStack item : rareItems) {
                ChestGenHooks.addItem((String)string, (WeightedRandomChestContent)new WeightedRandomChestContent(item.newStack(), 1, 1, 2));
            }
            for (OreItemStack item : ultraRareItems) {
                ChestGenHooks.addItem((String)string, (WeightedRandomChestContent)new WeightedRandomChestContent(item.newStack(), 1, 1, 1));
            }
        }
        for (OreItemStack oreItemStack : commonSmithItems) {
            ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(oreItemStack.newStack(2 + rand.nextInt(4)), 1, 3, 5));
        }
        for (OreItemStack oreItemStack : uncommonSmithItems) {
            ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(oreItemStack.newStack(1 + rand.nextInt(4)), 1, 2, 4));
        }
        for (OreItemStack oreItemStack : rareSmithItems) {
            ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(oreItemStack.newStack(), 1, 1, 2));
        }
        for (OreItemStack oreItemStack : ultraRareSmithItems) {
            ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(oreItemStack.newStack(), 1, 1, 1));
        }
    }
}

