/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.ores;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import tw.oresplus.api.Ores;
import tw.oresplus.blocks.BlockCore;
import tw.oresplus.blocks.BlockOre;
import tw.oresplus.core.Config;
import tw.oresplus.core.OreClass;
import tw.oresplus.core.helpers.Helpers;
import tw.oresplus.items.ItemCore;
import tw.oresplus.ores.DustOres;
import tw.oresplus.ores.IOres;
import tw.oresplus.ores.OreDrops;
import tw.oresplus.ores.OreSources;
import tw.oresplus.recipes.OreItemStack;
import tw.oresplus.recipes.RecipeManager;

public enum MetallicOres implements IOres
{
    Adamantine(3, Aspect.ARMOR),
    Aluminium(2, Aspect.EXCHANGE),
    Ardite(4, Aspect.VOID),
    Brass(Aspect.MECHANISM, true),
    Bronze(Aspect.MECHANISM, true),
    Cobalt(4, Aspect.CRAFT),
    Coldiron(2, Aspect.COLD),
    Copper(1, Aspect.EXCHANGE),
    Electrum(Aspect.EXCHANGE, true),
    Gold(2, Aspect.GREED),
    Iron(1, Aspect.METAL),
    Lead(1, Aspect.ORDER),
    Manganese(2, Aspect.ORDER),
    Mithral(3, Aspect.MAGIC),
    Nickel(2, Aspect.ORDER),
    Osmium(1, Aspect.ARMOR),
    Platinum(2, Aspect.GREED),
    Silver(2, Aspect.GREED),
    Tin(1, Aspect.CRYSTAL),
    Zinc(2, Aspect.CRYSTAL);

    public String oreName = "ore" + this.toString();
    public String netherOreName = "oreNether" + this.toString();
    public String blockName = "block" + this.toString();
    public String ingotName = "ingot" + this.toString();
    public String nuggetName = "nugget" + this.toString();
    public String dustName = "dust" + this.toString();
    public String tinyDustName = "dustTiny" + this.toString();
    public String crushedOreName = "crushed" + this.toString();
    public String purifiedCrushedOreName = "crushedPurified" + this.toString();
    public OreItemStack ore;
    public OreItemStack netherOre;
    public OreItemStack block;
    public OreItemStack ingot;
    public OreItemStack nugget;
    public OreItemStack dust;
    public OreItemStack tinyDust;
    public OreItemStack crushedOre;
    public OreItemStack purifiedCrushedOre;
    private int _harvestLevel;
    private int _xpLow;
    private int _xpHigh;
    private OreDrops _drops;
    private OreSources _source;
    private boolean _isAlloy;
    private float _smeltXP;
    private Aspect _secondaryAspect;
    public boolean enabled = true;

    private MetallicOres(Aspect secondaryAspect, boolean isAlloy) {
        this(0, secondaryAspect, isAlloy);
    }

    private MetallicOres(int harvestLevel, Aspect secondaryAspect) {
        this(harvestLevel, secondaryAspect, false);
    }

    private MetallicOres(int harvestLevel, Aspect secondaryAspect, boolean isAlloy) {
        this._harvestLevel = harvestLevel;
        this._xpLow = 0;
        this._xpHigh = 0;
        this._source = OreSources.DEFAULT;
        this._isAlloy = isAlloy;
        this._drops = OreDrops.ORE;
        this._secondaryAspect = secondaryAspect;
    }

    @Override
    public OreClass getDefaultConfig() {
        return new OreClass(this.oreName, this.enabled, this._harvestLevel, this._xpLow, this._xpHigh, this._drops, this._source);
    }

    @Override
    public OreClass getDefaultConfigNether() {
        return new OreClass(this.netherOreName, this.enabled, this._harvestLevel, this._xpLow, this._xpHigh, this._drops, this._source);
    }

    private boolean isVanilla() {
        return this == Iron || this == Gold;
    }

    @Override
    public void registerBlocks() {
        OreClass oreConfig;
        if (!this.isVanilla() && !this._isAlloy) {
            oreConfig = Config.getOre(this.getDefaultConfig());
            if (oreConfig.enabled) {
                this.ore = new OreItemStack(new BlockOre(oreConfig));
            }
        } else if (this == Gold) {
            this.ore = new OreItemStack(Blocks.field_150352_o);
        } else if (this == Iron) {
            this.ore = new OreItemStack(Blocks.field_150366_p);
        }
        if (!this._isAlloy) {
            oreConfig = Config.getOre(this.getDefaultConfigNether());
            if (oreConfig.enabled) {
                this.netherOre = new OreItemStack(new BlockOre(oreConfig, true));
            }
        }
        if (!this.isVanilla()) {
            this.block = new OreItemStack(new BlockCore(Material.field_151573_f, this.blockName).func_149647_a(CreativeTabs.field_78030_b).func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(Block.field_149777_j));
        } else if (this == Gold) {
            this.block = new OreItemStack(Blocks.field_150340_R);
        } else if (this == Iron) {
            this.block = new OreItemStack(Blocks.field_150339_S);
        }
    }

    @Override
    public void registerItems() {
        if (!this.isVanilla()) {
            this.ingot = new OreItemStack(new ItemCore(this.ingotName).func_77637_a(CreativeTabs.field_78035_l));
        } else if (this == Gold) {
            this.ingot = new OreItemStack(Items.field_151043_k);
        } else if (this == Iron) {
            this.ingot = new OreItemStack(Items.field_151042_j);
        }
        this.nugget = this != Gold ? new OreItemStack(new ItemCore(this.nuggetName).func_77637_a(CreativeTabs.field_78035_l)) : new OreItemStack(Items.field_151074_bl);
        this.dust = new OreItemStack(new ItemCore(this.dustName).func_77637_a(CreativeTabs.field_78035_l));
        this.tinyDust = new OreItemStack(new ItemCore(this.tinyDustName).func_77637_a(CreativeTabs.field_78035_l));
        if (!this._isAlloy) {
            this.crushedOre = new OreItemStack(new ItemCore(this.crushedOreName).func_77637_a(CreativeTabs.field_78035_l));
            this.purifiedCrushedOre = new OreItemStack(new ItemCore(this.purifiedCrushedOreName).func_77637_a(CreativeTabs.field_78035_l));
        }
    }

    @Override
    public void registerRecipes() {
        OreItemStack stoneDust = new OreItemStack(new ItemStack(Helpers.IC2.getItem("itemDust"), 1, 9));
        if (!this.isVanilla()) {
            RecipeManager.addShapedRecipe(this.block.newStack(), "iii", "iii", "iii", Character.valueOf('i'), this.ingotName);
            RecipeManager.addShapelessRecipe(this.ingot.newStack(9), this.block.newStack());
            if (!this._isAlloy) {
                RecipeManager.addSmelting(this.ore.newStack(), this.ingot.newStack(), Float.valueOf(this._smeltXP));
            }
        }
        if (!this.toString().equals("Gold")) {
            if (this.toString().equals("Iron")) {
                RecipeManager.addShapelessRecipe(this.nugget.newStack(9), this.ingot.newStack());
            } else {
                RecipeManager.addShapelessRecipe(this.nugget.newStack(9), this.ingotName);
            }
            RecipeManager.addShapedRecipe(this.ingot.newStack(), "nnn", "nnn", "nnn", Character.valueOf('n'), this.nuggetName);
        }
        if (this.isVanilla()) {
            Ores.grinderRecipes.add(this.ingot.newStack(), this.dust.newStack());
        } else {
            Ores.grinderRecipes.add(this.ingotName, this.dust.newStack());
        }
        if (Helpers.IC2.isLoaded()) {
            Helpers.IC2.registerRecipe("Macerator", this.ingot.newStack(), this.dust.newStack());
        }
        if (!this._isAlloy) {
            RecipeManager.addSmelting(this.netherOre.newStack(), this.ore.newStack(2), Float.valueOf(0.0f));
            RecipeManager.addSmelting(this.crushedOre.newStack(), this.ingot.newStack(), Float.valueOf(this._smeltXP));
            RecipeManager.addSmelting(this.purifiedCrushedOre.newStack(), this.ingot.newStack(), Float.valueOf(this._smeltXP));
            RecipeManager.addGrinderRecipe(this.oreName, this.crushedOre.newStack(2));
            if (Helpers.IC2.isLoaded()) {
                Helpers.IC2.registerRecipe("Macerator", this.ore.newStack(), this.crushedOre.newStack(2));
                NBTTagCompound metadata = new NBTTagCompound();
                metadata.func_74768_a("amount", 1000);
                switch (this) {
                    case Lead: {
                        Helpers.IC2.registerRecipe("OreWasher", this.crushedOre.newStack(), metadata, this.purifiedCrushedOre.newStack(), DustOres.Sulfur.tinyDust.newStack(3), stoneDust.newStack());
                        break;
                    }
                    default: {
                        Helpers.IC2.registerRecipe("OreWasher", this.crushedOre.newStack(), metadata, this.purifiedCrushedOre.newStack(), this.tinyDust.newStack(2), stoneDust.newStack());
                    }
                }
            }
        }
        RecipeManager.addSmelting(this.dust.newStack(), this.ingot.newStack(), Float.valueOf(this._smeltXP));
        RecipeManager.addShapedRecipe(this.dust.newStack(), "ttt", "ttt", "ttt", Character.valueOf('t'), this.tinyDustName);
        RecipeManager.addShapelessRecipe(this.tinyDust.newStack(9), this.dust.newStack());
    }

    @Override
    public void registerAspects() {
        if (!Helpers.ThaumCraft.isLoaded()) {
            return;
        }
        if (!this.isVanilla() && this != Copper && this != Tin && this != Silver && this != Lead) {
            ThaumcraftApi.registerObjectTag(this.nuggetName, new AspectList().add(Aspect.METAL, 1));
            ThaumcraftApi.registerObjectTag(this.ingotName, new AspectList().add(Aspect.METAL, 3).add(this._secondaryAspect, 1));
            ThaumcraftApi.registerObjectTag(this.dustName, new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(this._secondaryAspect, 1));
            ThaumcraftApi.registerObjectTag(this.oreName, new AspectList().add(Aspect.METAL, 2).add(Aspect.EARTH, 1).add(this._secondaryAspect, 1));
            ThaumcraftApi.registerObjectTag(this.blockName, new AspectList().add(Aspect.METAL, 5).add(this._secondaryAspect, 3));
        }
        ThaumcraftApi.registerObjectTag(this.netherOreName, new AspectList().add(Aspect.METAL, 2).add(this._secondaryAspect, 2).add(Aspect.EARTH, 1).add(Aspect.FIRE, 1));
    }
}

