/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.core.helpers;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import tw.oresplus.api.Ores;
import tw.oresplus.core.OreLog;
import tw.oresplus.core.helpers.OresHelper;

public class BCHelper
extends OresHelper {
    private Class genOilClass;
    private Object genOilClassObj;
    private Method genOilMethod;
    private String[] subMods = new String[]{"BuildCraft|Builders", "BuildCraft|Energy", "BuildCraft|Factory", "BuildCraft|Silicon", "BuildCraft|Transport"};

    public BCHelper() {
        super("BuildCraft|Core");
    }

    @Override
    public void init() {
        if (!this.isLoaded()) {
            OreLog.info("BuildCraft not found, helper disabled");
            return;
        }
        if (this.isEnergyLoaded()) {
            Block blockOil = this.getBlock("blockOil");
            if (blockOil != null) {
                Ores.registerBlock("blockOil", "BuildCraft", blockOil);
            }
            try {
                this.genOilClass = Class.forName("buildcraft.energy.worldgen.OilPopulate");
            }
            catch (ClassNotFoundException e) {
                OreLog.info("Could not find OilPopulate class");
                e.printStackTrace();
            }
            Constructor c = null;
            try {
                c = this.genOilClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                OreLog.info("Could not find constructor");
                e.printStackTrace();
            }
            catch (SecurityException e) {
                OreLog.info("Access denied to contructor");
                e.printStackTrace();
            }
            if (c != null) {
                c.setAccessible(true);
                try {
                    this.genOilClassObj = c.newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    OreLog.info("InstatianException");
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    OreLog.info("Illegal Access");
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    OreLog.info("Illrgal args");
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    OreLog.info("Target exception");
                    e.printStackTrace();
                }
            }
            if (this.genOilClass != null && this.genOilClassObj != null) {
                for (Method method : this.genOilClass.getMethods()) {
                    if (!method.getName().equals("generateOil")) continue;
                    this.genOilMethod = method;
                }
            }
        }
        OreLog.info("BuildCraft found, helper Initialized");
    }

    private boolean isEnergyLoaded() {
        return Loader.isModLoaded((String)"BuildCraft|Energy");
    }

    @Override
    public void generate(World world, Random rand, int chunkX, int chunkZ) {
        if (!this.isEnergyLoaded() || this.genOilMethod == null) {
            return;
        }
        try {
            this.genOilMethod.invoke(this.genOilClassObj, world, rand, chunkX, chunkZ);
        }
        catch (IllegalAccessException e) {
            OreLog.info("Call to OilPopulate.generate was denied");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            OreLog.info("Call to OilPopulate.generate was failed, illegal arguments");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            OreLog.info("OilPopulate.generate caused an exception");
            e.printStackTrace();
        }
    }

    @Override
    public void registerRecipe(String recipeType, ItemStack input, NBTTagCompound metadata, ItemStack ... outputs) {
    }

    @Override
    public Block getBlock(String blockName) {
        Block result = super.getBlock(blockName);
        if (result == null) {
            for (String subModName : this.subMods) {
                Block subModResult = GameRegistry.findBlock((String)subModName, (String)blockName);
                if (subModResult == null) continue;
                result = subModResult;
            }
        }
        return result;
    }
}

