/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.core;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import tw.oresplus.OresPlus;
import tw.oresplus.core.OreClass;
import tw.oresplus.core.OreLog;
import tw.oresplus.ores.OreSources;
import tw.oresplus.worldgen.OreGenClass;

public class Config {
    public static final String CAT_ORES = "ores";
    public static final String CAT_ORE_GEN = "ore_generation";
    public static final String CAT_REGEN = "regeneration";
    public static final String CAT_CONFIG = "configFile";
    private static OreLog log = OresPlus.log;
    private static boolean configured;
    private static Configuration configFile;
    private static final int configVersion = 1;
    private static int configFileVersion;

    public static void init(FMLPreInitializationEvent event) {
        OreLog.info("Initializing Configuration");
        configFile = new Configuration(event.getSuggestedConfigurationFile());
        configFile.load();
        configFile.addCustomCategoryComment(CAT_CONFIG, "Config file versioning");
        configFile.addCustomCategoryComment(CAT_ORES, "Ore configuration = oreEnabled,oreSource");
        configFile.addCustomCategoryComment(CAT_ORE_GEN, "Ore generator configuration = generatorEnabled,denisty%,regenerateOre");
        configFile.addCustomCategoryComment(CAT_REGEN, "Configure general regeneration options here");
        configFileVersion = configFile.hasKey(CAT_CONFIG, "configVersion") ? Config.getInt(CAT_CONFIG, "configVersion", configFileVersion, "Configuration File Version - Do not change, modifying this may break your game") : 0;
        OreLog.info("Reading from v" + configFileVersion + " Configuration File");
        configured = true;
    }

    private static int getInt(String key, int defaultValue, String comment) {
        return Config.getInt("general", key, defaultValue, comment);
    }

    private static int getInt(String category, String key, int defaultValue, String comment) {
        Property prop = configFile.get(category, key, defaultValue);
        if (comment != "") {
            prop.comment = comment;
        }
        return prop.getInt(defaultValue);
    }

    public static void save() {
        if (!configured) {
            OreLog.info("Error - configuration not initialized!");
            return;
        }
        OreLog.info("Saving Configuration");
        if (configFileVersion != 1) {
            Property prop = configFile.get(CAT_CONFIG, "configVersion", 1);
            prop.comment = "Configuration File Version - Do not change, modifying this may break your game";
            prop.set(1);
        }
        if (configFile.hasChanged()) {
            configFile.save();
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue, String comment) {
        Property prop = configFile.get("general", key, defaultValue);
        if (comment != "") {
            prop.comment = comment;
        }
        return prop.getBoolean(defaultValue);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return Config.getBoolean(key, defaultValue, "");
    }

    public static String getString(String catagory, String key, String defaultValue, String comment) {
        Property prop = configFile.get(catagory, key, defaultValue);
        if (comment != "") {
            prop.comment = comment;
        }
        return prop.getString();
    }

    public static String getString(String key, String defaultValue, String comment) {
        return Config.getString("general", key, defaultValue, comment);
    }

    public static String getString(String key, String defaultValue) {
        return Config.getString("general", key, defaultValue, "");
    }

    private static String getOreGenCfgLine(OreGenClass oreConfig) {
        if (oreConfig == null) {
            return null;
        }
        return Boolean.toString(oreConfig.enabled) + "," + oreConfig.density + "," + Boolean.toString(oreConfig.doRegen) + "," + oreConfig.regenKey;
    }

    public static OreGenClass getOreGen(OreGenClass oreConfig) {
        if (oreConfig != null) {
            Property prop = configFile.get(CAT_ORE_GEN, oreConfig.name, Config.getOreGenCfgLine(oreConfig));
            String[] cfg = prop.getString().split(",");
            boolean configChanged = false;
            block0 : switch (configFileVersion) {
                case 1: {
                    oreConfig.enabled = Boolean.parseBoolean(cfg[0]);
                    oreConfig.density = Integer.parseInt(cfg[1]);
                    oreConfig.doRegen = Boolean.parseBoolean(cfg[2]);
                    oreConfig.regenKey = cfg[3];
                    break;
                }
                default: {
                    switch (cfg.length) {
                        case 3: {
                            oreConfig.enabled = Boolean.parseBoolean(cfg[0]);
                            oreConfig.density = Integer.parseInt(cfg[1]);
                            oreConfig.doRegen = Boolean.parseBoolean(cfg[2]);
                            break block0;
                        }
                        case 4: {
                            oreConfig.enabled = Boolean.parseBoolean(cfg[0]);
                            oreConfig.density = Integer.parseInt(cfg[1]);
                            oreConfig.doRegen = Boolean.parseBoolean(cfg[2]);
                            oreConfig.regenKey = cfg[3];
                            break block0;
                        }
                        case 8: {
                            oreConfig.enabled = Boolean.parseBoolean(cfg[1]);
                            oreConfig.doRegen = Boolean.parseBoolean(cfg[7]);
                            configChanged = true;
                            break block0;
                        }
                    }
                    OreLog.info("Could not read config for ore " + oreConfig.name + ". Resetting to default");
                    configChanged = true;
                }
            }
            if (configChanged) {
                prop.set(Config.getOreGenCfgLine(oreConfig));
            }
        }
        return oreConfig;
    }

    private static String getOreCfgLine(OreClass ore) {
        if (ore == null) {
            return null;
        }
        return Boolean.toString(ore.enabled) + "," + ore.source.name();
    }

    public static OreClass getOre(OreClass ore) {
        if (ore != null) {
            Property prop = configFile.get(CAT_ORES, ore.name, Config.getOreCfgLine(ore));
            String[] cfg = prop.getString().split(",");
            boolean configChanged = false;
            switch (cfg.length) {
                case 2: {
                    ore.enabled = Boolean.parseBoolean(cfg[0]);
                    ore.source = OreSources.valueOf(cfg[1]);
                    break;
                }
                case 3: {
                    ore.enabled = Boolean.parseBoolean(cfg[0]);
                    configChanged = true;
                    break;
                }
                default: {
                    OreLog.info("Could not read config for ore " + ore.name + ". Resetting to default");
                    configChanged = true;
                }
            }
            if (configChanged) {
                prop.set(Config.getOreCfgLine(ore));
            }
        }
        return ore;
    }
}

