/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.triggers;

import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITriggerParameter;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import tw.oresplus.blocks.TileEntityMachine;
import tw.oresplus.triggers.Trigger;

public class TriggerMachine
extends Trigger
implements ITileTrigger {
    private IIcon icon;
    private boolean active;

    public TriggerMachine(boolean checkActive) {
        this.active = checkActive;
    }

    @Override
    public String getUniqueTag() {
        return "OresPlus:" + (this.active ? "HasWork" : "WorkDone");
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("OresPlus:triggers/" + (this.active ? "hasWork" : "workDone"));
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public boolean requiresParameter() {
        return false;
    }

    @Override
    public String getDescription() {
        return this.active ? "Has work" : "Work Done";
    }

    @Override
    public ITriggerParameter createParameter() {
        return null;
    }

    @Override
    public boolean isTriggerActive(ForgeDirection direction, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof TileEntityMachine) {
            if (this.active) {
                return ((TileEntityMachine)tile).hasWork();
            }
            return !((TileEntityMachine)tile).hasWork();
        }
        return false;
    }
}

