/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.recipes;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tw.oresplus.recipes.ICraftingHandler;

public class TmiHandler
implements ICraftingHandler {
    private Class tmi;
    private Object tmiObject;
    private Method hideItemMethod;
    private boolean isInitialized = false;

    public TmiHandler() {
        if (!this.isLoaded()) {
            return;
        }
        try {
            this.tmi = Class.forName("TMIItemInfo");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (this.tmi != null) {
            try {
                this.tmiObject = this.tmi.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.tmi != null && this.tmiObject != null) {
            for (Method method : this.tmi.getMethods()) {
                if (!method.getName().equals("hideItem")) continue;
                this.hideItemMethod = method;
            }
        }
        this.isInitialized = true;
    }

    @Override
    public boolean isLoaded() {
        return Loader.isModLoaded((String)"TooManyItems");
    }

    @Override
    public boolean hideItem(ItemStack item) {
        if (!this.isInitialized) {
            return false;
        }
        try {
            this.hideItemMethod.invoke(this.tmiObject, Item.func_150891_b((Item)item.func_77973_b()));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return true;
    }
}

