/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.ores;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import tw.oresplus.blocks.BlockCore;
import tw.oresplus.blocks.BlockOre;
import tw.oresplus.core.Config;
import tw.oresplus.core.OreClass;
import tw.oresplus.core.helpers.Helpers;
import tw.oresplus.items.ItemCore;
import tw.oresplus.ores.IOres;
import tw.oresplus.ores.OreDrops;
import tw.oresplus.ores.OreSources;
import tw.oresplus.recipes.OreItemStack;
import tw.oresplus.recipes.RecipeManager;

public enum GemstoneOres implements IOres
{
    Amethyst(2, OreDrops.AMETHYST),
    Apatite(1, OreDrops.APATITE),
    Diamond(2, 3, 7, OreDrops.DIAMOND),
    Emerald(2, 3, 7, OreDrops.EMERALD),
    GreenSapphire(2, 3, 7, OreDrops.GREENSAPPHIRE),
    Ruby(2, 3, 7, OreDrops.RUBY),
    Sapphire(2, 3, 7, OreDrops.SAPPHIRE),
    Topaz(2, 3, 7, OreDrops.TOPAZ);

    public String oreName = "ore" + this.toString();
    public String netherOreName = "oreNether" + this.toString();
    public String blockName = "block" + this.toString();
    public String gemName = "gem" + this.toString();
    public OreItemStack ore;
    public OreItemStack netherOre;
    public OreItemStack block;
    public OreItemStack gem;
    public boolean enabled = true;
    private int _harvestLevel;
    private int _xpLow;
    private int _xpHigh;
    private OreDrops _drops;
    private OreSources _source;

    private GemstoneOres(int harvestLevel, int xpLow, int xpHigh, OreDrops drops) {
        this._harvestLevel = harvestLevel;
        this._xpLow = xpLow;
        this._xpHigh = xpHigh;
        this._drops = drops;
        this._source = OreSources.DEFAULT;
    }

    private GemstoneOres(int harvestLevel, OreDrops drops) {
        this(harvestLevel, 0, 0, drops);
    }

    private boolean isVanilla() {
        return this == Diamond || this == Emerald;
    }

    @Override
    public OreClass getDefaultConfig() {
        return new OreClass(this.oreName, this.enabled, this._harvestLevel, this._xpLow, this._xpHigh, this._drops, this._source);
    }

    @Override
    public OreClass getDefaultConfigNether() {
        return new OreClass(this.netherOreName, this.enabled, this._harvestLevel, this._xpLow, this._xpHigh, OreDrops.ORE, this._source);
    }

    @Override
    public void registerBlocks() {
        OreClass oreConfig;
        if (!this.isVanilla()) {
            oreConfig = Config.getOre(this.getDefaultConfig());
            if (oreConfig.enabled) {
                this.ore = new OreItemStack(new BlockOre(oreConfig));
            }
        } else if (this == Diamond) {
            this.ore = new OreItemStack(Blocks.field_150482_ag);
        } else if (this == Emerald) {
            this.ore = new OreItemStack(Blocks.field_150412_bA);
        }
        oreConfig = Config.getOre(this.getDefaultConfigNether());
        if (oreConfig.enabled) {
            this.netherOre = new OreItemStack(new BlockOre(oreConfig, true));
        }
        if (!this.isVanilla()) {
            this.block = new OreItemStack(new BlockCore(Material.field_151573_f, this.blockName).func_149647_a(CreativeTabs.field_78030_b).func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(Block.field_149777_j));
        } else if (this == Diamond) {
            this.block = new OreItemStack(Blocks.field_150484_ah);
        } else if (this == Emerald) {
            this.block = new OreItemStack(Blocks.field_150475_bE);
        }
    }

    @Override
    public void registerItems() {
        if (!this.isVanilla()) {
            this.gem = new OreItemStack(new ItemCore(this.gemName).func_77637_a(CreativeTabs.field_78035_l));
        } else if (this == Diamond) {
            this.gem = new OreItemStack(Items.field_151045_i);
        } else if (this == Emerald) {
            this.gem = new OreItemStack(Items.field_151166_bC);
        }
    }

    @Override
    public void registerRecipes() {
        switch (this) {
            case Diamond: 
            case Emerald: {
                RecipeManager.addGrinderRecipe(this.oreName, this.gem.newStack(2));
                if (!Helpers.IC2.isLoaded()) break;
                Helpers.IC2.registerRecipe("Macerator", this.ore.newStack(), this.gem.newStack(2));
                break;
            }
            case Apatite: {
                RecipeManager.addSmelting(this.ore.newStack(), this.gem.newStack(6), Float.valueOf(0.0f));
                RecipeManager.addGrinderRecipe(this.oreName, this.gem.newStack(6));
                if (!Helpers.IC2.isLoaded()) break;
                Helpers.IC2.registerRecipe("Macerator", this.ore.newStack(), this.gem.newStack(6));
                break;
            }
            default: {
                RecipeManager.addSmelting(this.ore.newStack(), this.gem.newStack(), Float.valueOf(0.0f));
                RecipeManager.addGrinderRecipe(this.oreName, this.gem.newStack(2));
                if (!Helpers.IC2.isLoaded()) break;
                Helpers.IC2.registerRecipe("Macerator", this.ore.newStack(), this.gem.newStack(2));
            }
        }
        RecipeManager.addSmelting(this.netherOre.newStack(), this.ore.newStack(2), Float.valueOf(0.0f));
        if (!this.isVanilla()) {
            RecipeManager.addShapedRecipe(this.block.newStack(), "ggg", "ggg", "ggg", Character.valueOf('g'), this.gemName);
        }
        if (!this.isVanilla()) {
            RecipeManager.addShapelessRecipe(this.gem.newStack(9), this.block.newStack());
        }
    }

    @Override
    public void registerAspects() {
        if (!Helpers.ThaumCraft.isLoaded()) {
            return;
        }
        switch (this) {
            case Apatite: {
                ThaumcraftApi.registerObjectTag(this.gemName, new AspectList().add(Aspect.CRYSTAL, 3).add(Aspect.CROP, 1));
                ThaumcraftApi.registerObjectTag(this.oreName, new AspectList().add(Aspect.CRYSTAL, 2).add(Aspect.EARTH, 1));
                ThaumcraftApi.registerObjectTag(this.blockName, new AspectList().add(Aspect.CRYSTAL, 6).add(Aspect.CROP, 4));
                ThaumcraftApi.registerObjectTag(this.netherOreName, new AspectList().add(Aspect.CRYSTAL, 2).add(Aspect.ENERGY, 1).add(Aspect.EARTH, 1).add(Aspect.FIRE, 1));
                break;
            }
            default: {
                if (!this.isVanilla()) {
                    ThaumcraftApi.registerObjectTag(this.gemName, new AspectList().add(Aspect.CRYSTAL, 4).add(Aspect.GREED, 4));
                    ThaumcraftApi.registerObjectTag(this.oreName, new AspectList().add(Aspect.EARTH, 1).add(Aspect.GREED, 3).add(Aspect.CRYSTAL, 3));
                    ThaumcraftApi.registerObjectTag(this.blockName, new AspectList().add(Aspect.CRYSTAL, 6).add(Aspect.GREED, 6));
                }
                ThaumcraftApi.registerObjectTag(this.netherOreName, new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 1).add(Aspect.GREED, 3).add(Aspect.CRYSTAL, 3));
            }
        }
    }
}

