/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.ores;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import tw.oresplus.api.Ores;
import tw.oresplus.blocks.BlockCore;
import tw.oresplus.blocks.BlockOre;
import tw.oresplus.core.Config;
import tw.oresplus.core.OreClass;
import tw.oresplus.core.helpers.Helpers;
import tw.oresplus.items.ItemCore;
import tw.oresplus.ores.IOres;
import tw.oresplus.ores.OreDrops;
import tw.oresplus.ores.OreSources;
import tw.oresplus.recipes.OreItemStack;
import tw.oresplus.recipes.RecipeManager;

public enum DustOres implements IOres
{
    Nikolite(2, Aspect.ENERGY, Aspect.MECHANISM, OreDrops.NIKOLITE),
    Phosphorite(1, Aspect.ENERGY, Aspect.HARVEST, OreDrops.PHOSPHORITE),
    Potash(1, Aspect.ENERGY, Aspect.HARVEST, OreDrops.POTASH),
    Redstone(2, Aspect.ENERGY, Aspect.MECHANISM),
    Saltpeter(1, Aspect.FIRE, Aspect.HARVEST, OreDrops.SALTPETER),
    Sulfur(1, Aspect.FIRE, Aspect.ENTROPY, OreDrops.SULFUR);

    public String oreName = "ore" + this.toString();
    public String netherOreName = "oreNether" + this.toString();
    public String blockName = "block" + this.toString();
    public String dustName = "dust" + this.toString();
    public String tinyDustName = "dustTiny" + this.toString();
    public OreItemStack ore;
    public OreItemStack netherOre;
    public OreItemStack block;
    public OreItemStack dust;
    public OreItemStack tinyDust;
    private int _harvestLevel;
    private OreDrops _drops;
    private Aspect _aspect;
    private Aspect _secondaryAspect;

    private DustOres(int harvestLevel, Aspect aspect, Aspect secondaryAspect) {
        this(harvestLevel, aspect, secondaryAspect, OreDrops.ORE);
    }

    private DustOres(int harvestLevel, Aspect aspect, Aspect secondaryAspect, OreDrops drops) {
        this._harvestLevel = harvestLevel;
        this._drops = drops;
        this._aspect = aspect;
        this._secondaryAspect = secondaryAspect;
    }

    @Override
    public OreClass getDefaultConfig() {
        return new OreClass(this.oreName, true, this._harvestLevel, 0, 0, this._drops, OreSources.DEFAULT);
    }

    @Override
    public OreClass getDefaultConfigNether() {
        return new OreClass(this.netherOreName, true, this._harvestLevel, 0, 0, OreDrops.ORE, OreSources.DEFAULT);
    }

    @Override
    public void registerBlocks() {
        OreClass oreClass;
        switch (this) {
            case Redstone: {
                this.ore = new OreItemStack(Blocks.field_150450_ax);
                Ores.manager.registerOre(this.oreName, Blocks.field_150450_ax);
                this.block = new OreItemStack(Blocks.field_150451_bX);
                Ores.manager.registerOre(this.blockName, Blocks.field_150451_bX);
                break;
            }
            default: {
                oreClass = Config.getOre(this.getDefaultConfig());
                if (oreClass.enabled) {
                    this.ore = new OreItemStack(new BlockOre(oreClass));
                }
                this.block = new OreItemStack(new BlockCore(Material.field_151573_f, this.blockName).func_149647_a(CreativeTabs.field_78030_b).func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(Block.field_149777_j));
            }
        }
        oreClass = Config.getOre(this.getDefaultConfigNether());
        if (oreClass.enabled) {
            this.netherOre = new OreItemStack(new BlockOre(oreClass, true));
        }
    }

    @Override
    public void registerItems() {
        switch (this) {
            case Redstone: {
                this.dust = new OreItemStack(Items.field_151137_ax);
                break;
            }
            default: {
                this.dust = new OreItemStack(new ItemCore(this.dustName).func_77637_a(CreativeTabs.field_78035_l));
            }
        }
        this.tinyDust = new OreItemStack(new ItemCore(this.tinyDustName).func_77637_a(CreativeTabs.field_78035_l));
    }

    @Override
    public void registerRecipes() {
        RecipeManager.addShapedRecipe(this.dust.newStack(), "ttt", "ttt", "ttt", Character.valueOf('t'), this.tinyDustName);
        RecipeManager.addShapelessRecipe(this.tinyDust.newStack(9), this.dustName);
        RecipeManager.addSmelting(this.netherOre.newStack(), this.ore.newStack(2), Float.valueOf(0.0f));
        RecipeManager.addShapedRecipe(this.block.newStack(), "ddd", "ddd", "ddd", Character.valueOf('d'), this.dustName);
        RecipeManager.addShapelessRecipe(this.dust.newStack(9), this.block.newStack());
    }

    @Override
    public void registerAspects() {
        if (!Helpers.ThaumCraft.isLoaded()) {
            return;
        }
        if (this != Redstone) {
            ThaumcraftApi.registerObjectTag(this.oreName, new AspectList().add(Aspect.EARTH, 1).add(this._aspect, 2).add(this._secondaryAspect, 2));
            ThaumcraftApi.registerObjectTag(this.dustName, new AspectList().add(this._aspect, 2).add(this._secondaryAspect, 1));
            ThaumcraftApi.registerObjectTag(this.blockName, new AspectList().add(this._aspect, 3).add(this._secondaryAspect, 4));
        }
        ThaumcraftApi.registerObjectTag(this.netherOreName, new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 1).add(this._aspect, 2).add(this._secondaryAspect, 2));
    }
}

