/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.core.helpers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import tw.oresplus.core.OreLog;
import tw.oresplus.core.helpers.OresHelper;

public class ForestryHelper
extends OresHelper {
    private Class genBeesClass;
    private Object genBeesClassObj;
    private Method genBeesMethod;

    public ForestryHelper() {
        super("Forestry");
    }

    @Override
    public void init() {
        if (!this.isLoaded()) {
            OreLog.info("Forestry not found, helper disabled");
            return;
        }
        try {
            this.genBeesClass = Class.forName("forestry.apiculture.worldgen.HiveDecorator");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Constructor c = null;
        try {
            c = this.genBeesClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (c != null) {
            c.setAccessible(true);
            try {
                this.genBeesClassObj = c.newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.genBeesClass != null && this.genBeesClassObj != null) {
            for (Method method : this.genBeesClass.getMethods()) {
                if (!method.getName().equals("generate")) continue;
                this.genBeesMethod = method;
            }
        }
        OreLog.info("Forestry found, helper Initialized");
    }

    @Override
    public void generate(World world, Random rand, int chunkX, int chunkZ) {
        if (!this.isLoaded()) {
            return;
        }
        try {
            this.genBeesMethod.invoke(this.genBeesClassObj, new PopulateChunkEvent.Post(world.func_72863_F(), world, rand, chunkX, chunkZ, false));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void registerRecipe(String recipeType, ItemStack input, NBTTagCompound metadata, ItemStack ... outputs) {
    }
}

