/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import tw.oresplus.OresPlus;
import tw.oresplus.core.OreLog;
import tw.oresplus.core.helpers.Helpers;
import tw.oresplus.worldgen.OreGenerators;

public class TickHandler {
    public static HashMap<Integer, ArrayList<ChunkCoordIntPair>> oreRegenList = new HashMap();
    public static HashMap<Integer, ArrayList<ChunkCoordIntPair>> oilRegenList = new HashMap();
    public static HashMap<Integer, ArrayList<ChunkCoordIntPair>> rubberTreeRegenList = new HashMap();
    public static HashMap<Integer, ArrayList<ChunkCoordIntPair>> beehiveRegenList = new HashMap();

    @SubscribeEvent
    public boolean onWorldTick(TickEvent.WorldTickEvent event) {
        ArrayList<ChunkCoordIntPair> chunks;
        int dim = event.world.field_73011_w.field_76574_g;
        for (OreGenerators oreGen : OreGenerators.values()) {
            ArrayList<ChunkCoordIntPair> chunks2 = oreGen.generator.regenList.get(dim);
            if (chunks2 == null || chunks2.isEmpty()) continue;
            ChunkCoordIntPair coords = chunks2.get(0);
            oreGen.generator.generate(event.world, event.world.field_73012_v, coords.field_77276_a, coords.field_77275_b);
            event.world.func_72964_e(coords.field_77276_a, coords.field_77275_b).func_76630_e();
            if (OresPlus.logRegenerations) {
                OreLog.info("Regenerated " + oreGen.toString() + " at chunk " + coords.field_77276_a + "," + coords.field_77275_b);
            }
            chunks2.remove(0);
            oreGen.generator.regenList.put(dim, chunks2);
        }
        if (Helpers.BuildCraft.isLoaded() && (chunks = oilRegenList.get(dim)) != null && !chunks.isEmpty()) {
            ChunkCoordIntPair coords = chunks.get(0);
            Chunk chunk = event.world.func_72964_e(coords.field_77276_a, coords.field_77275_b);
            Helpers.BuildCraft.generate(event.world, event.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h);
            if (OresPlus.logRegenerations) {
                OreLog.info("Regenerated oil at chunk " + coords.field_77276_a + "," + coords.field_77275_b);
            }
            chunks.remove(0);
            oilRegenList.put(dim, chunks);
        }
        if (Helpers.IC2.isLoaded() && (chunks = rubberTreeRegenList.get(dim)) != null && !chunks.isEmpty()) {
            ChunkCoordIntPair coords = chunks.get(0);
            Chunk chunk = event.world.func_72964_e(coords.field_77276_a, coords.field_77275_b);
            Helpers.IC2.generate(event.world, event.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h);
            if (OresPlus.logRegenerations) {
                OreLog.info("Regenerated rubber trees at chunk " + coords.field_77276_a + "," + coords.field_77275_b);
            }
            chunks.remove(0);
            rubberTreeRegenList.put(dim, chunks);
        }
        if (Helpers.Forestry.isLoaded() && (chunks = beehiveRegenList.get(dim)) != null && !chunks.isEmpty()) {
            ChunkCoordIntPair coords = chunks.get(0);
            Chunk chunk = event.world.func_72964_e(coords.field_77276_a, coords.field_77275_b);
            Helpers.Forestry.generate(event.world, event.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h);
            if (OresPlus.logRegenerations) {
                OreLog.info("Regenerated beehives at chunk " + coords.field_77276_a + "," + coords.field_77275_b);
            }
            chunks.remove(0);
            beehiveRegenList.put(dim, chunks);
        }
        return true;
    }
}

