/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.blocks;

import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tw.oresplus.blocks.BlockMachine;
import tw.oresplus.core.FuelHelper;

public abstract class TileEntityMachine
extends TileEntity
implements ISidedInventory,
IPowerReceptor,
ITriggerProvider {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    protected ItemStack[] inventory;
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int machineWorkTime;
    protected final int workTimeNeeded;
    protected String inventoryName;
    protected String customInventoryName = "";
    protected PowerHandler powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
    protected float energyRequired = 25.0f;
    protected ItemStack currentItem;

    protected TileEntityMachine(int worktime) {
        this.initPower();
        this.workTimeNeeded = worktime;
    }

    private void initPower() {
        this.powerHandler.configure(50.0, 100.0, this.energyRequired, 1500.0);
    }

    public int func_70302_i_() {
        if (this.inventory == null) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot > this.func_70302_i_()) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory != null) {
            ItemStack stack;
            if (this.inventory[slot].field_77994_a <= amount) {
                stack = this.inventory[slot];
                this.inventory[slot] = null;
            } else {
                stack = this.inventory[slot].func_77979_a(amount);
                if (this.inventory[slot].field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack stack = this.inventory[slot];
            this.inventory[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customInventoryName : this.inventoryName;
    }

    public boolean func_145818_k_() {
        return this.customInventoryName != "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerHandler.readFromNBT(tagCompound);
        this.initPower();
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.furnaceBurnTime = tagCompound.func_74765_d("BurnTime");
        this.machineWorkTime = tagCompound.func_74765_d("CookTime");
        this.currentItemBurnTime = FuelHelper.getItemBurnTime(this.inventory[1]);
        NBTTagCompound itemTag = tagCompound.func_74775_l("CurrentItem");
        if (itemTag != null) {
            this.currentItem = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.powerHandler.writeToNBT(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.machineWorkTime);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        if (this.currentItem != null) {
            NBTTagCompound itemTag = new NBTTagCompound();
            this.currentItem.func_77955_b(itemTag);
            tagCompound.func_74782_a("CurrentItem", (NBTBase)itemTag);
        }
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : (side == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return side != 0 || slot != 1 || item.func_77973_b() == Items.field_151133_ar;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.powerHandler.update();
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    public boolean canBurn() {
        return false;
    }

    public abstract boolean hasWork();

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * scale / this.currentItemBurnTime;
    }

    @SideOnly(value=Side.CLIENT)
    public int getWorkProgressScaled(int scale) {
        return this.machineWorkTime * scale / this.workTimeNeeded;
    }

    protected void burnFuel() {
        boolean wasBurning = this.furnaceBurnTime > 0;
        boolean needsSave = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.hasWork()) {
                this.currentItemBurnTime = this.furnaceBurnTime = FuelHelper.getItemBurnTime(this.inventory[1]);
                if (this.furnaceBurnTime > 0) {
                    this.func_70296_d();
                    if (this.inventory[1] != null) {
                        --this.inventory[1].field_77994_a;
                        if (this.inventory[1].field_77994_a == 0) {
                            this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
                        }
                    }
                }
            }
            if (wasBurning != this.furnaceBurnTime > 0) {
                needsSave = true;
                BlockMachine.updateMachineBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (needsSave) {
            this.func_70296_d();
        }
    }
}

