/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.blocks;

import buildcraft.api.gates.ITrigger;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeTile;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tw.oresplus.api.Ores;
import tw.oresplus.blocks.TileEntityMachine;
import tw.oresplus.core.FuelHelper;
import tw.oresplus.core.OreLog;
import tw.oresplus.triggers.OresTrigger;

public class TileEntityCracker
extends TileEntityMachine
implements IFluidHandler {
    public FluidTank tank = new FluidTank(5000);

    public TileEntityCracker() {
        super(1200);
        this.inventory = new ItemStack[2];
        this.inventoryName = "container:cracker";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.burnFuel();
        if (!this.field_145850_b.field_72995_K && this.isBurning() && this.hasWork()) {
            this.doCrack(1);
        }
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return slot == 0 ? item.func_77973_b() == Ores.getItem("itemBitumen") : FuelHelper.isItemFuel(item);
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (this.hasWork()) {
            if (this.powerHandler.useEnergy(this.energyRequired, this.energyRequired, true) != (double)this.energyRequired) {
                return;
            }
            this.doCrack((int)((double)this.energyRequired * 1.5));
        }
    }

    @Override
    public boolean hasWork() {
        if (this.inventory[0] == null && this.currentItem == null) {
            return false;
        }
        ItemStack item = this.currentItem != null ? this.currentItem : this.inventory[0];
        return item.func_77973_b() == Ores.getItem("itemBitumen") && this.tank.getFluidAmount() < this.tank.getCapacity();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
    }

    private void doCrack(int amount) {
        if (this.machineWorkTime == 0) {
            this.startCrack();
        }
        if (this.currentItem != null) {
            this.machineWorkTime += amount;
            if (this.machineWorkTime >= this.workTimeNeeded) {
                this.machineWorkTime -= this.workTimeNeeded;
                this.crackItem();
                this.func_70296_d();
            }
        }
    }

    private void crackItem() {
        this.tank.fill(new FluidStack(FluidRegistry.getFluid((String)"oil"), 250), true);
        OreLog.info("Tank: " + this.tank.getFluidAmount());
        if (this.inventory[0] == null || this.inventory[0].func_77973_b() != this.currentItem.func_77973_b()) {
            this.currentItem = null;
            this.machineWorkTime = 0;
        } else {
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
    }

    private void startCrack() {
        if (this.inventory[0] == null) {
            this.currentItem = null;
            return;
        }
        if (this.currentItem == null) {
            this.currentItem = this.inventory[0].func_77946_l();
        }
        if (this.inventory[0].func_77969_a(this.currentItem)) {
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
    }

    @Override
    public LinkedList<ITrigger> getPipeTriggers(IPipeTile pipe) {
        return null;
    }

    @Override
    public LinkedList<ITrigger> getNeighborTriggers(Block block, TileEntity tile) {
        LinkedList<ITrigger> triggers = new LinkedList<ITrigger>();
        triggers.add(OresTrigger.hasWork);
        return triggers;
    }
}

