/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.blocks;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import tw.oresplus.api.Ores;
import tw.oresplus.blocks.NewTileEntityMachine;
import tw.oresplus.core.FuelHelper;

public class NewTileEntityGrinder
extends NewTileEntityMachine {
    private static final int sourceItemSlot = 0;
    private static final int furnaceItemSlot = 1;
    private static final int currentItemSlot = 2;
    private static final int outputItemSlot = 3;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{3, 1};
    private static final int[] slotsSides = new int[]{1};

    public NewTileEntityGrinder() {
        super(1200.0f);
        this.inventory = new ItemStack[4];
        this.inventoryName = "container:grinder";
        this.initFurnace(1);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.hasWork()) {
            float energyRequired = this._minimumBCEnergyRequired / this._efficiancy;
            if (this.powerHandler.useEnergy(energyRequired, energyRequired, true) != (double)energyRequired) {
                return;
            }
            this.grindItem((int)energyRequired);
        }
    }

    private void grindItem(int grindAmount) {
        if (this._energySpent == 0.0f) {
            this.startGrind();
        }
        if (this.inventory[2] != null) {
            this._energySpent += (float)grindAmount;
            if (this._energySpent >= this._energyRequired) {
                this._energySpent -= this._energyRequired;
                this.finishGrind();
                this.func_70296_d();
            }
        }
    }

    private void startGrind() {
        if (this.inventory[2] == null && this.inventory[0] != null) {
            this.inventory[2] = this.inventory[0].func_77979_a(1);
            if (this.inventory[0].field_77994_a == 0) {
                this.inventory[0] = null;
            }
        } else if (this.inventory[2].func_77969_a(this.inventory[0])) {
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a == 0) {
                this.inventory[0] = null;
            }
        }
    }

    private void finishGrind() {
        ItemStack grindResult = Ores.grinderRecipes.getResult(this.inventory[2]);
        if (this.inventory[3] == null) {
            this.inventory[3] = grindResult.func_77946_l();
        } else if (this.inventory[3].func_77969_a(grindResult)) {
            this.inventory[3].field_77994_a += grindResult.field_77994_a;
        }
        if (this.inventory[0] == null) {
            this.inventory[2] = null;
            this._energySpent = 0.0f;
        }
    }

    @Override
    public boolean hasWork() {
        if (this.inventory[0] == null && this.inventory[2] == null) {
            return false;
        }
        ItemStack grindResult = Ores.grinderRecipes.getResult(this.inventory[2] != null ? this.inventory[2] : this.inventory[0]);
        if (grindResult == null) {
            return false;
        }
        if (this.inventory[3] == null) {
            return true;
        }
        if (!this.inventory[3].func_77969_a(grindResult)) {
            return false;
        }
        int resultSize = grindResult.field_77994_a + this.inventory[3].field_77994_a;
        return resultSize <= this.func_70297_j_() && resultSize <= this.inventory[3].func_77976_d();
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        switch (slot) {
            case 0: {
                return Ores.grinderRecipes.getResult(item) != null;
            }
            case 1: {
                return FuelHelper.isItemFuel(item);
            }
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : (side == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return side != 0 || slot != 1 && slot != 2 || item.func_77973_b() == Items.field_151133_ar && slot == 1;
    }
}

