/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import tw.oresplus.OresPlus;
import tw.oresplus.api.Ores;
import tw.oresplus.blocks.BlockCore;
import tw.oresplus.core.OreClass;
import tw.oresplus.core.helpers.Helpers;
import tw.oresplus.ores.OreDrops;
import tw.oresplus.recipes.OreItemStack;

public class BlockOre
extends BlockCore {
    private OreDrops drops;
    private int xpDropLow;
    private int xpDropHigh;
    private boolean _isNether;
    private Random rand = new Random();

    public BlockOre(OreClass ore, boolean isNether) {
        super(Material.field_151576_e, ore.name);
        this.drops = ore.drops;
        this.func_149647_a(CreativeTabs.field_78030_b);
        OreDictionary.registerOre((String)ore.name, (Block)this);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", ore.harvestLevel);
        this.xpDropLow = ore.xpDropLow;
        this.xpDropHigh = ore.xpDropHigh;
        this._isNether = isNether;
        Ores.manager.registerOre(ore.name, this);
    }

    public BlockOre(OreClass ore) {
        this(ore, false);
    }

    public int getExpDrop(IBlockAccess var1, int var2, int var3) {
        if (this.xpDropLow == 0 && this.xpDropHigh == 0) {
            return 0;
        }
        return this.xpDropLow + this.rand.nextInt(this.xpDropHigh - this.xpDropLow + 1);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        switch (this.drops) {
            case AMETHYST: {
                rList.add(new ItemStack(Ores.getItem("gemAmethyst"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case APATITE: {
                rList.add(new ItemStack(Ores.getItem("gemApatite"), this.fortuneHelper(world, 1 + world.field_73012_v.nextInt(4), fortune)));
                break;
            }
            case BITUMEN: {
                rList.add(new ItemStack(Ores.getItem("itemBitumen"), this.fortuneHelper(world, 2 + world.field_73012_v.nextInt(4), fortune)));
                break;
            }
            case CERTUSQUARTZ: {
                Item certusQuartz = Helpers.AppliedEnergistics.getItem("item.ItemMaterial");
                if (Helpers.AppliedEnergistics.isLoaded() && certusQuartz != null) {
                    OreItemStack cqStack = world.field_73012_v.nextFloat() > 0.92f ? new OreItemStack(new ItemStack(certusQuartz, 1, 1)) : new OreItemStack(new ItemStack(certusQuartz, 1, 0));
                    rList.add(cqStack.newStack(this.fortuneHelper(world, 1 + world.field_73012_v.nextInt(2), fortune)));
                    break;
                }
                rList.add(new ItemStack(this.func_149650_a(metadata, world.field_73012_v, fortune), 1));
                break;
            }
            case CINNABAR: {
                rList.add(new ItemStack(Ores.getItem("dustCinnabar"), this.fortuneHelper(world, 1, fortune)));
                if (world.field_73012_v.nextInt(4) != 0) break;
                rList.add(new ItemStack(Items.field_151137_ax, this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case GREENSAPPHIRE: {
                rList.add(new ItemStack(Ores.getItem("gemGreenSapphire"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case IRIDIUM: {
                rList.add(new ItemStack(Ores.getItem("gemIridium"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case MAGNESIUM: {
                rList.add(new ItemStack(Ores.getItem("dustMagnesium"), this.fortuneHelper(world, 2 + world.field_73012_v.nextInt(4), fortune)));
                break;
            }
            case NIKOLITE: {
                rList.add(new ItemStack(Ores.getItem("dustNikolite"), this.fortuneHelper(world, 4 + world.field_73012_v.nextInt(2), fortune)));
                break;
            }
            case OLIVINE: {
                rList.add(new ItemStack(Ores.getItem("gemOlivine"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case PHOSPHORITE: {
                rList.add(new ItemStack(Ores.getItem("dustPhosphorite"), this.fortuneHelper(world, 2 + world.field_73012_v.nextInt(4), fortune)));
                break;
            }
            case POTASH: {
                rList.add(new ItemStack(Ores.getItem("dustPotash"), this.fortuneHelper(world, 2 + world.field_73012_v.nextInt(4), fortune)));
                break;
            }
            case PYRITE: {
                rList.add(new ItemStack(Ores.getItem("dustPyrite"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case RUBY: {
                rList.add(new ItemStack(Ores.getItem("gemRuby"), this.fortuneHelper(world, 1, fortune)));
                if (world.field_73012_v.nextInt(32) != 0) break;
                rList.add(new ItemStack(Ores.getItem("gemRedGarnet"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case SALTPETER: {
                rList.add(new ItemStack(Ores.getItem("dustSaltpeter"), this.fortuneHelper(world, 1 + world.field_73012_v.nextInt(2), fortune)));
                break;
            }
            case SAPPHIRE: {
                rList.add(new ItemStack(Ores.getItem("gemSapphire"), this.fortuneHelper(world, 1, fortune)));
                if (world.field_73012_v.nextInt(64) != 0) break;
                rList.add(new ItemStack(Ores.getItem("gemGreenSapphire"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case SPHALERITE: {
                rList.add(new ItemStack(Ores.getItem("dustSphalerite"), this.fortuneHelper(world, 1, fortune)));
                if (world.field_73012_v.nextInt(4) == 0) {
                    rList.add(new ItemStack(Ores.getItem("dustZinc"), this.fortuneHelper(world, 1, fortune)));
                }
                if (world.field_73012_v.nextInt(32) != 0) break;
                rList.add(new ItemStack(Ores.getItem("gemYellowGarnet"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case SULFUR: {
                rList.add(new ItemStack(Ores.getItem("dustSulfur"), this.fortuneHelper(world, 2 + world.field_73012_v.nextInt(4), fortune)));
                break;
            }
            case TOPAZ: {
                rList.add(new ItemStack(Ores.getItem("gemTopaz"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case URANIUM: {
                rList.add(new ItemStack(Ores.getItem("gemUranium"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            case SODALITE: {
                rList.add(new ItemStack(Ores.getItem("dustSodalite"), this.fortuneHelper(world, 6, fortune)));
                if (world.field_73012_v.nextInt(4) != 0) break;
                rList.add(new ItemStack(Ores.getItem("dustAluminium"), this.fortuneHelper(world, 1, fortune)));
                break;
            }
            default: {
                rList.add(new ItemStack(this.func_149650_a(metadata, world.field_73012_v, fortune), 1));
            }
        }
        return rList;
    }

    private int fortuneHelper(World world, int stackSize, int fortune) {
        switch (this.drops) {
            case AMETHYST: 
            case CERTUSQUARTZ: 
            case CINNABAR: 
            case GREENSAPPHIRE: 
            case IRIDIUM: 
            case PYRITE: 
            case RUBY: 
            case SAPPHIRE: 
            case SPHALERITE: 
            case TOPAZ: 
            case URANIUM: {
                block4 : switch (fortune) {
                    case 1: {
                        if (world.field_73012_v.nextInt(3) != 0) break;
                        stackSize *= 2;
                        break;
                    }
                    case 2: {
                        switch (world.field_73012_v.nextInt(4)) {
                            case 0: {
                                stackSize *= 2;
                                break;
                            }
                            case 1: {
                                stackSize *= 3;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (world.field_73012_v.nextInt(5)) {
                            case 0: {
                                stackSize *= 2;
                                break block4;
                            }
                            case 1: {
                                stackSize *= 3;
                                break block4;
                            }
                            case 2: {
                                stackSize *= 4;
                            }
                        }
                    }
                }
                break;
            }
            case APATITE: 
            case BITUMEN: 
            case MAGNESIUM: 
            case NIKOLITE: 
            case OLIVINE: 
            case PHOSPHORITE: 
            case POTASH: 
            case SALTPETER: 
            case SULFUR: 
            case SODALITE: {
                if (fortune >= 1) {
                    ++stackSize;
                }
                if (fortune >= 2) {
                    ++stackSize;
                }
                if (fortune != 3) break;
                ++stackSize;
                break;
            }
        }
        return stackSize;
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        if (OresPlus.angryPigmen & this._isNether) {
            BlockOre.upsetThePigs(player, world, x, y, z);
        }
    }

    private static void upsetThePigs(EntityPlayer player, World world, int x, int y, int z) {
        int range = 32;
        List entities = world.func_72872_a(EntityPigZombie.class, AxisAlignedBB.func_72330_a((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + range + 1), (double)(y + range + 1), (double)(z + range + 1)));
        for (Object entity : entities) {
            if (!(entity instanceof EntityPigZombie)) continue;
            ((EntityPigZombie)entity).func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 0.0f);
        }
    }
}

