/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tw.oresplus.OresPlus;
import tw.oresplus.blocks.BlockCore;
import tw.oresplus.blocks.Blocks;
import tw.oresplus.blocks.TileEntityGrinder;
import tw.oresplus.blocks.TileEntityMachine;

public abstract class BlockMachine
extends BlockCore
implements ITileEntityProvider {
    private final Random blockRandom = new Random();
    protected static boolean isLocked;
    protected IIcon[] iconArray = new IIcon[3];
    protected boolean _isWorking;
    protected int guiID;

    public BlockMachine(String machineName) {
        super(Material.field_151576_e, machineName, false);
        this.func_149711_c(3.5f);
    }

    public void onBlockAddded(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.func_149930_e(world, x, y, z);
    }

    private void func_149930_e(World world, int x, int y, int z) {
        Block block1 = world.func_147439_a(x, y, z - 1);
        Block block2 = world.func_147439_a(x, y, z + 1);
        Block block3 = world.func_147439_a(x - 1, y, z);
        Block block4 = world.func_147439_a(x + 1, y, z);
        int meta = 3;
        if (block1.func_149730_j() && !block2.func_149730_j()) {
            meta = 3;
        }
        if (block2.func_149730_j() && !block1.func_149730_j()) {
            meta = 2;
        }
        if (block3.func_149730_j() && !block4.func_149730_j()) {
            meta = 5;
        }
        if (block4.func_149730_j() && !block3.func_149730_j()) {
            meta = 4;
        }
        world.func_72921_c(x, y, z, meta, 2);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int metadata;
        int n = metadata = meta == 0 ? 3 : meta;
        if (side == 1 || side == 0) {
            return this.iconArray[0];
        }
        if (side == metadata) {
            return this.iconArray[2];
        }
        return this.iconArray[1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister icon) {
        this.iconArray[0] = icon.func_94245_a("OresPlus:machine_top");
        this.iconArray[1] = icon.func_94245_a("OresPlus:machine_side");
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (l == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (l == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (l == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int var6) {
        TileEntityMachine te;
        if (!isLocked && (te = (TileEntityMachine)world.func_147438_o(x, y, z)) != null) {
            for (int i1 = 0; i1 < te.func_70302_i_(); ++i1) {
                ItemStack itemstack = te.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = this.blockRandom.nextFloat() * 0.8f + 0.1f;
                float f1 = this.blockRandom.nextFloat() * 0.8f + 0.1f;
                float f2 = this.blockRandom.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = this.blockRandom.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.blockRandom.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.blockRandom.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.blockRandom.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, var6);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this._isWorking) {
            int l = world.func_72805_g(x, y, z);
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            if (l == 4) {
                world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (l == 5) {
                world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (l == 2) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            } else if (l == 3) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)OresPlus.instance, this.guiID, world, x, y, z);
        return true;
    }

    public abstract TileEntity func_149915_a(World var1, int var2);

    public static void updateMachineBlockState(boolean isBurning, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        isLocked = true;
        if (te instanceof TileEntityGrinder) {
            if (isBurning) {
                world.func_147449_b(x, y, z, Block.func_149634_a((Item)Blocks.grinder_lit.source.func_77973_b()));
            } else {
                world.func_147449_b(x, y, z, Block.func_149634_a((Item)Blocks.grinder.source.func_77973_b()));
            }
        }
        isLocked = false;
        world.func_72921_c(x, y, z, meta, 2);
        if (te != null) {
            te.func_145829_t();
            world.func_147455_a(x, y, z, te);
        }
    }
}

