/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus;

import buildcraft.api.gates.ActionManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraftforge.common.MinecraftForge;
import tw.oresplus.api.Ores;
import tw.oresplus.blocks.Blocks;
import tw.oresplus.blocks.TileEntityCracker;
import tw.oresplus.blocks.TileEntityGrinder;
import tw.oresplus.core.Config;
import tw.oresplus.core.GuiHandler;
import tw.oresplus.core.IMCHandler;
import tw.oresplus.core.IProxy;
import tw.oresplus.core.ItemMapHelper;
import tw.oresplus.core.OreEventHandler;
import tw.oresplus.core.OreLog;
import tw.oresplus.core.TickHandler;
import tw.oresplus.core.helpers.Helpers;
import tw.oresplus.fluids.Fluids;
import tw.oresplus.items.Items;
import tw.oresplus.network.NetHandler;
import tw.oresplus.ores.OreManager;
import tw.oresplus.recipes.RecipeManager;
import tw.oresplus.triggers.OresTrigger;
import tw.oresplus.triggers.TriggerProvider;
import tw.oresplus.worldgen.OreChestLoot;
import tw.oresplus.worldgen.OreGenerators;
import tw.oresplus.worldgen.WorldGenCore;

@Mod(modid="OresPlus", name="OresPlus", version="0.5.28 Beta", dependencies="required-after:Forge@10.12.1.1060")
public class OresPlus {
    @SidedProxy(clientSide="tw.oresplus.client.ClientProxy", serverSide="tw.oresplus.core.ServerProxy")
    public static IProxy proxy;
    public static final String MOD_ID = "OresPlus";
    public static final String MOD_NAME = "OresPlus";
    public static final String MOD_VERSION = "0.5.28 Beta";
    @Mod.Instance(value="OresPlus")
    public static OresPlus instance;
    public static OreLog log;
    public static Config config;
    public static String regenKeyOre;
    public static String regenKeyOil;
    public static String regenKeyRubberTree;
    public static String regenKeyBeehives;
    public static boolean iridiumPlateRecipe;
    public static boolean difficultAlloys;
    public static boolean logRegenerations;
    public static boolean angryPigmen;
    public static boolean debugMode;
    public static WorldGenCore worldGen;
    public static OreEventHandler eventHandler;
    public static TickHandler tickHandler;
    public static IMCHandler imcHandler;
    public static ItemMapHelper itemMapHelper;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log.init();
        RecipeManager.init();
        Config.init(event);
        angryPigmen = Config.getBoolean("angryPigmen", angryPigmen, "set to false to prevent zombie pigmen from attacking when mining nether ores");
        iridiumPlateRecipe = Config.getBoolean("iridiumPlateRecipe", iridiumPlateRecipe, "enables an ore dictionary-enabled recipe for iridium plate");
        difficultAlloys = Config.getBoolean("difficultAlloys", difficultAlloys, "enable true to set brass & bronze alloy recipes to output only 2 dusts");
        logRegenerations = Config.getBoolean("logRegenerations", logRegenerations, "enable to log all regenerations that occur");
        debugMode = Config.getBoolean("debugMode", debugMode, "set to true to enable finer debug logging");
        regenKeyOre = Config.getString("regeneration", "regenKey", regenKeyOre, "change this to regenerate ores");
        regenKeyOil = Config.getString("regeneration", "regenKeyOil", regenKeyOil, "change this to regenerate buildcraft oil wells");
        regenKeyRubberTree = Config.getString("regeneration", "regenKeyRubberTree", regenKeyRubberTree, "change this to regenerate IC2 rubber trees");
        regenKeyBeehives = Config.getString("regeneration", "regenKeyBeehives", regenKeyBeehives, "change this to regenerate Forestry beehives");
        NetHandler.instance.preInit();
        Ores.manager = new OreManager();
        Blocks.init();
        Items.init();
        Fluids.init();
        OreLog.info("Registering Ore Generators");
        for (OreGenerators oreGenerators : OreGenerators.values()) {
            oreGenerators.registerGenerator();
        }
        config.save();
        for (Enum enum_ : Helpers.values()) {
            ((Helpers)enum_).init();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        RecipeManager.initRecipes();
        GameRegistry.registerTileEntity(TileEntityGrinder.class, (String)"TileEntityGrinder");
        GameRegistry.registerTileEntity(TileEntityCracker.class, (String)"TileEntityCracker");
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.ORE_GEN_BUS.register((Object)eventHandler);
        FMLCommonHandler.instance().bus().register((Object)tickHandler);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        itemMapHelper = new ItemMapHelper();
        OresTrigger.registerTriggers();
        ActionManager.registerTriggerProvider(new TriggerProvider());
        NetHandler.instance.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (debugMode) {
            Ores.grinderRecipes.debug();
        }
        RecipeManager.replaceRecipeResults();
        OreChestLoot.registerChestLoot();
    }

    @Mod.EventHandler
    public void recieveIMC(FMLInterModComms.IMCEvent event) {
        imcHandler.recieveIMC(event);
    }

    @Mod.EventHandler
    public void handleMissingMaps(FMLMissingMappingsEvent event) {
        itemMapHelper.handleMissingMaps(event);
    }

    @Mod.EventHandler
    public void handRemaps(FMLModIdMappingEvent event) {
        Blocks.handleRemaps(event);
    }

    static {
        regenKeyOre = "DISABLED";
        regenKeyOil = "DISABLED";
        regenKeyRubberTree = "DISABLED";
        regenKeyBeehives = "DISABLED";
        iridiumPlateRecipe = true;
        difficultAlloys = false;
        logRegenerations = false;
        angryPigmen = true;
        debugMode = false;
        worldGen = new WorldGenCore();
        eventHandler = new OreEventHandler();
        tickHandler = new TickHandler();
        imcHandler = new IMCHandler();
    }
}

