/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.power;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IPowerReceptor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public final class PowerHandler {
    public static final PerditionCalculator DEFAULT_PERDITION = new PerditionCalculator();
    public static final double ROLLING_AVERAGE_WEIGHT = 100.0;
    public static final double ROLLING_AVERAGE_NUMERATOR = 99.0;
    public static final double ROLLING_AVERAGE_DENOMINATOR = 0.01;
    private double minEnergyReceived;
    private double maxEnergyReceived;
    private double maxEnergyStored;
    private double activationEnergy;
    private double energyStored = 0.0;
    private final SafeTimeTracker doWorkTracker = new SafeTimeTracker();
    private final SafeTimeTracker sourcesTracker = new SafeTimeTracker();
    private final SafeTimeTracker perditionTracker = new SafeTimeTracker();
    public final int[] powerSources = new int[6];
    public final IPowerReceptor receptor;
    private PerditionCalculator perdition;
    private final PowerReceiver receiver;
    private final Type type;
    private double averageLostPower = 0.0;
    private double averageReceivedPower = 0.0;
    private double averageUsedPower = 0.0;

    public PowerHandler(IPowerReceptor receptor, Type type) {
        this.receptor = receptor;
        this.type = type;
        this.receiver = new PowerReceiver();
        this.perdition = DEFAULT_PERDITION;
    }

    public PowerReceiver getPowerReceiver() {
        return this.receiver;
    }

    public double getMinEnergyReceived() {
        return this.minEnergyReceived;
    }

    public double getMaxEnergyReceived() {
        return this.maxEnergyReceived;
    }

    public double getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    public double getActivationEnergy() {
        return this.activationEnergy;
    }

    public double getEnergyStored() {
        return this.energyStored;
    }

    public void configure(double minEnergyReceived, double maxEnergyReceived, double activationEnergy, double maxStoredEnergy) {
        if (minEnergyReceived > maxEnergyReceived) {
            maxEnergyReceived = minEnergyReceived;
        }
        this.minEnergyReceived = minEnergyReceived;
        this.maxEnergyReceived = maxEnergyReceived;
        this.maxEnergyStored = maxStoredEnergy;
        this.activationEnergy = activationEnergy;
    }

    public void configurePowerPerdition(int powerLoss, int powerLossRegularity) {
        if (powerLoss == 0 || powerLossRegularity == 0) {
            this.perdition = new PerditionCalculator(0.0);
            return;
        }
        this.perdition = new PerditionCalculator((float)powerLoss / (float)powerLossRegularity);
    }

    public void setPerdition(PerditionCalculator perdition) {
        if (perdition == null) {
            perdition = DEFAULT_PERDITION;
        }
        this.perdition = perdition;
    }

    public PerditionCalculator getPerdition() {
        if (this.perdition == null) {
            return DEFAULT_PERDITION;
        }
        return this.perdition;
    }

    public void update() {
        this.applyPerdition();
        this.applyWork();
        this.validateEnergy();
    }

    private void applyPerdition() {
        if (this.perditionTracker.markTimeIfDelay(this.receptor.getWorld(), 1L) && this.energyStored > 0.0) {
            double prev = this.energyStored;
            double newEnergy = this.getPerdition().applyPerdition(this, this.energyStored, this.perditionTracker.durationOfLastDelay());
            this.energyStored = newEnergy == 0.0 || newEnergy < this.energyStored ? newEnergy : DEFAULT_PERDITION.applyPerdition(this, this.energyStored, this.perditionTracker.durationOfLastDelay());
            this.validateEnergy();
            this.averageLostPower = (this.averageLostPower * 99.0 + (prev - this.energyStored)) * 0.01;
        }
    }

    private void applyWork() {
        if (this.energyStored >= this.activationEnergy && this.doWorkTracker.markTimeIfDelay(this.receptor.getWorld(), 1L)) {
            this.receptor.doWork(this);
        }
    }

    private void updateSources(ForgeDirection source) {
        if (this.sourcesTracker.markTimeIfDelay(this.receptor.getWorld(), 1L)) {
            for (int i = 0; i < 6; ++i) {
                int n = i;
                this.powerSources[n] = (int)((long)this.powerSources[n] - this.sourcesTracker.durationOfLastDelay());
                if (this.powerSources[i] >= 0) continue;
                this.powerSources[i] = 0;
            }
        }
        if (source != null) {
            this.powerSources[source.ordinal()] = 10;
        }
    }

    public double useEnergy(double min, double max, boolean doUse) {
        this.applyPerdition();
        double result = 0.0;
        if (this.energyStored >= min) {
            if (this.energyStored <= max) {
                result = this.energyStored;
                if (doUse) {
                    this.energyStored = 0.0;
                }
            } else {
                result = max;
                if (doUse) {
                    this.energyStored -= max;
                }
            }
        }
        this.validateEnergy();
        if (doUse) {
            this.averageUsedPower = (this.averageUsedPower * 99.0 + result) * 0.01;
        }
        return result;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.readFromNBT(data, "powerProvider");
    }

    public void readFromNBT(NBTTagCompound data, String tag) {
        NBTTagCompound nbt = data.func_74775_l(tag);
        this.energyStored = nbt.func_74769_h("energyStored");
    }

    public void writeToNBT(NBTTagCompound data) {
        this.writeToNBT(data, "powerProvider");
    }

    public void writeToNBT(NBTTagCompound data, String tag) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energyStored", this.energyStored);
        data.func_74782_a(tag, (NBTBase)nbt);
    }

    public double addEnergy(double quantity) {
        this.energyStored += quantity;
        if (this.energyStored > this.maxEnergyStored) {
            quantity -= this.energyStored - this.maxEnergyStored;
            this.energyStored = this.maxEnergyStored;
        } else if (this.energyStored < 0.0) {
            quantity -= this.energyStored;
            this.energyStored = 0.0;
        }
        this.applyPerdition();
        return quantity;
    }

    public void setEnergy(double quantity) {
        this.energyStored = quantity;
        this.validateEnergy();
    }

    public boolean isPowerSource(ForgeDirection from) {
        return this.powerSources[from.ordinal()] != 0;
    }

    private void validateEnergy() {
        if (this.energyStored < 0.0) {
            this.energyStored = 0.0;
        }
        if (this.energyStored > this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    public final class PowerReceiver {
        private PowerReceiver() {
        }

        public double getMinEnergyReceived() {
            return PowerHandler.this.minEnergyReceived;
        }

        public double getMaxEnergyReceived() {
            return PowerHandler.this.maxEnergyReceived;
        }

        public double getMaxEnergyStored() {
            return PowerHandler.this.maxEnergyStored;
        }

        public double getActivationEnergy() {
            return PowerHandler.this.activationEnergy;
        }

        public double getEnergyStored() {
            return PowerHandler.this.energyStored;
        }

        public double getAveragePowerReceived() {
            return PowerHandler.this.averageReceivedPower;
        }

        public double getAveragePowerUsed() {
            return PowerHandler.this.averageUsedPower;
        }

        public double getAveragePowerLost() {
            return PowerHandler.this.averageLostPower;
        }

        public Type getType() {
            return PowerHandler.this.type;
        }

        public void update() {
            PowerHandler.this.update();
        }

        public double powerRequest() {
            this.update();
            return Math.min(PowerHandler.this.maxEnergyReceived, PowerHandler.this.maxEnergyStored - PowerHandler.this.energyStored);
        }

        public double receiveEnergy(Type source, double quantity, ForgeDirection from) {
            double used = quantity;
            if (source == Type.ENGINE) {
                if (used < PowerHandler.this.minEnergyReceived) {
                    return 0.0;
                }
                if (used > PowerHandler.this.maxEnergyReceived) {
                    used = PowerHandler.this.maxEnergyReceived;
                }
            }
            PowerHandler.this.updateSources(from);
            used -= used * PowerHandler.this.getPerdition().getTaxPercent();
            used = PowerHandler.this.addEnergy(used);
            PowerHandler.this.applyWork();
            if (source == Type.ENGINE && PowerHandler.this.type.eatsEngineExcess()) {
                used = Math.min(quantity, PowerHandler.this.maxEnergyReceived);
            }
            PowerHandler.this.averageReceivedPower = (PowerHandler.this.averageReceivedPower * 99.0 + used) * 0.01;
            return used;
        }
    }

    public static class PerditionCalculator {
        public static final float DEFAULT_POWERLOSS = 1.0f;
        public static final float MIN_POWERLOSS = 0.01f;
        private final double powerLoss;

        public PerditionCalculator() {
            this.powerLoss = 1.0;
        }

        public PerditionCalculator(double powerLoss) {
            if (powerLoss < (double)0.01f) {
                powerLoss = 0.01f;
            }
            this.powerLoss = powerLoss;
        }

        public double applyPerdition(PowerHandler powerHandler, double current, long ticksPassed) {
            if ((current -= this.powerLoss * (double)ticksPassed) < 0.0) {
                current = 0.0;
            }
            return current;
        }

        public double getTaxPercent() {
            return 0.0;
        }
    }

    public static enum Type {
        ENGINE,
        GATE,
        MACHINE,
        PIPE,
        STORAGE;


        public boolean canReceiveFromPipes() {
            switch (this) {
                case MACHINE: 
                case STORAGE: {
                    return true;
                }
            }
            return false;
        }

        public boolean eatsEngineExcess() {
            switch (this) {
                case MACHINE: 
                case STORAGE: {
                    return true;
                }
            }
            return false;
        }
    }
}

