/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import tw.oresplus.worldgen.WorldGenOre;

public class WorldGenCore
implements IWorldGenerator {
    public static List<WorldGenOre> oreGenOverworld = new ArrayList<WorldGenOre>();
    public static List<WorldGenOre> oreGenNether = new ArrayList<WorldGenOre>();
    public static List<WorldGenOre> oreGenEnd = new ArrayList<WorldGenOre>();
    public static Collection<String> biomeListBauxite = new ArrayList<String>();
    public static Collection<String> biomeListCassiterite = new ArrayList<String>();
    public static Collection<String> biomeListColdiron = new ArrayList<String>();
    public static Collection<String> biomeListMithral = new ArrayList<String>();
    public static Collection<String> biomeListNickel = new ArrayList<String>();
    public static Collection<String> biomeListRuby = new ArrayList<String>();
    public static Collection<String> biomeListSapphire = new ArrayList<String>();
    public static Collection<String> biomeListSaltpeter = new ArrayList<String>();
    public static Collection<String> biomeListSulfur = new ArrayList<String>();
    public static Collection<String> biomeListTetrahedrite = new ArrayList<String>();

    public WorldGenCore() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)1);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.doWorldGen(random, world, chunkX, chunkZ, true);
    }

    public void doWorldGen(Random random, World world, int chunkX, int chunkZ, boolean newChunk) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16, newChunk);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16, newChunk);
                break;
            }
            default: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16, newChunk);
            }
        }
        if (!newChunk) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }

    public void generateEnd(World world, Random random, int blockX, int blockZ, boolean newChunk) {
        for (WorldGenOre oreGen : oreGenEnd) {
            if (!newChunk && !oreGen.doRegen) continue;
            oreGen.generate(world, random, blockX, blockZ);
        }
    }

    public void generateNether(World world, Random random, int blockX, int blockZ, boolean newChunk) {
        for (WorldGenOre oreGen : oreGenNether) {
            if (!newChunk && !oreGen.doRegen) continue;
            oreGen.generate(world, random, blockX, blockZ);
        }
    }

    public void generateSurface(World world, Random random, int blockX, int blockZ, boolean newChunk) {
        for (WorldGenOre oreGen : oreGenOverworld) {
            if (!newChunk && !oreGen.doRegen) continue;
            oreGen.generate(world, random, blockX, blockZ);
        }
    }

    static {
        biomeListBauxite.add(BiomeGenBase.field_76772_c.field_76791_y);
        biomeListBauxite.add(BiomeGenBase.field_76767_f.field_76791_y);
        biomeListBauxite.add(BiomeGenBase.field_76785_t.field_76791_y);
        biomeListCassiterite.add(BiomeGenBase.field_76768_g.field_76791_y);
        biomeListCassiterite.add(BiomeGenBase.field_76784_u.field_76791_y);
        biomeListCassiterite.add(BiomeGenBase.field_76774_n.field_76791_y);
        biomeListCassiterite.add(BiomeGenBase.field_76775_o.field_76791_y);
        biomeListCassiterite.add(BiomeGenBase.field_76789_p.field_76791_y);
        biomeListCassiterite.add(BiomeGenBase.field_76788_q.field_76791_y);
        biomeListCassiterite.add(BiomeGenBase.field_76770_e.field_76791_y);
        biomeListCassiterite.add(BiomeGenBase.field_76783_v.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_76776_l.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_76777_m.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_76774_n.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_76775_o.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_150584_S.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_150579_T.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_76770_e.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_76783_v.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_76768_g.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_76784_u.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_150578_U.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_150581_V.field_76791_y);
        biomeListColdiron.add(BiomeGenBase.field_150580_W.field_76791_y);
        biomeListMithral.add(BiomeGenBase.field_76770_e.field_76791_y);
        biomeListMithral.add(BiomeGenBase.field_76783_v.field_76791_y);
        biomeListNickel.add(BiomeGenBase.field_76770_e.field_76791_y);
        biomeListNickel.add(BiomeGenBase.field_76783_v.field_76791_y);
        biomeListRuby.add(BiomeGenBase.field_76769_d.field_76791_y);
        biomeListRuby.add(BiomeGenBase.field_76786_s.field_76791_y);
        biomeListSaltpeter.add(BiomeGenBase.field_76769_d.field_76791_y);
        biomeListSaltpeter.add(BiomeGenBase.field_76786_s.field_76791_y);
        biomeListSapphire.add(BiomeGenBase.field_76787_r.field_76791_y);
        biomeListSapphire.add(BiomeGenBase.field_76771_b.field_76791_y);
        biomeListSulfur.add(BiomeGenBase.field_76770_e.field_76791_y);
        biomeListSulfur.add(BiomeGenBase.field_76783_v.field_76791_y);
        biomeListTetrahedrite.add(BiomeGenBase.field_76782_w.field_76791_y);
        biomeListTetrahedrite.add(BiomeGenBase.field_76792_x.field_76791_y);
        biomeListTetrahedrite.add(BiomeGenBase.field_76780_h.field_76791_y);
        biomeListTetrahedrite.add(BiomeGenBase.field_76789_p.field_76791_y);
        biomeListTetrahedrite.add(BiomeGenBase.field_76788_q.field_76791_y);
        biomeListTetrahedrite.add(BiomeGenBase.field_76770_e.field_76791_y);
        biomeListTetrahedrite.add(BiomeGenBase.field_76783_v.field_76791_y);
    }
}

