/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.recipes;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import tw.oresplus.OresPlus;
import tw.oresplus.api.Ores;
import tw.oresplus.blocks.Blocks;
import tw.oresplus.core.OreLog;
import tw.oresplus.core.helpers.Helpers;
import tw.oresplus.items.OreItems;
import tw.oresplus.ores.DustOres;
import tw.oresplus.ores.GemstoneOres;
import tw.oresplus.ores.GeneralOres;
import tw.oresplus.ores.MetallicOres;
import tw.oresplus.recipes.GrinderRecipeManager;
import tw.oresplus.recipes.ICraftingHandler;
import tw.oresplus.recipes.NeiHandler;
import tw.oresplus.recipes.OreItemStack;
import tw.oresplus.recipes.TmiHandler;

public class RecipeManager {
    private static ICraftingHandler neiHandler;
    private static ICraftingHandler tmiHandler;

    public static void init() {
        Ores.grinderRecipes = new GrinderRecipeManager();
        neiHandler = new NeiHandler();
        tmiHandler = new TmiHandler();
    }

    public static void initRecipes() {
        OreItemStack coal = new OreItemStack(Items.field_151044_h, 0);
        OreItemStack charcoal = new OreItemStack(Items.field_151044_h, 1);
        OreItemStack fertalizer = new OreItemStack(Helpers.Forestry.getItem("fertilizerCompound"));
        OreItemStack flint = new OreItemStack(Items.field_151145_ak);
        OreItemStack furnace = new OreItemStack(net.minecraft.init.Blocks.field_150460_al);
        OreItemStack glass = new OreItemStack(net.minecraft.init.Blocks.field_150359_w);
        OreItemStack gunpowder = new OreItemStack(Items.field_151016_H);
        OreItemStack oreCoal = new OreItemStack(net.minecraft.init.Blocks.field_150365_q);
        OreItemStack oreLapis = new OreItemStack(net.minecraft.init.Blocks.field_150369_x);
        OreItemStack stick = new OreItemStack(Items.field_151055_y);
        OreItemStack tank = new OreItemStack(Helpers.BuildCraft.getBlock("tankBlock"));
        if (Helpers.BuildCraft.isLoaded() && tank.source.func_77973_b() != null) {
            RecipeManager.addShapedRecipe(Blocks.cracker.newStack(), "t", "F", Character.valueOf('t'), tank.newStack(), Character.valueOf('F'), furnace.newStack());
        } else {
            RecipeManager.addShapedRecipe(Blocks.cracker.newStack(), "ggg", "gFg", "ggg", Character.valueOf('g'), glass.newStack(), Character.valueOf('F'), furnace.newStack());
        }
        RecipeManager.addShapedRecipe(Blocks.grinder.newStack(), "fff", "fFf", "fff", Character.valueOf('f'), flint.newStack(), Character.valueOf('F'), furnace.newStack());
        RecipeManager.addShapedRecipe(gunpowder.newStack(4), "sSs", "csc", "sSs", Character.valueOf('s'), "dustSaltpeter", Character.valueOf('c'), "dustCoal", Character.valueOf('S'), "dustSulfur");
        RecipeManager.addShapedRecipe(gunpowder.newStack(4), "scs", "SsS", "scs", Character.valueOf('s'), "dustSaltpeter", Character.valueOf('c'), "dustCoal", Character.valueOf('S'), "dustSulfur");
        RecipeManager.addShapedRecipe(gunpowder.newStack(4), "sSs", "csc", "sSs", Character.valueOf('s'), "dustSaltpeter", Character.valueOf('c'), "dustCharcoal", Character.valueOf('S'), "dustSulfur");
        RecipeManager.addShapedRecipe(gunpowder.newStack(4), "scs", "SsS", "scs", Character.valueOf('s'), "dustSaltpeter", Character.valueOf('c'), "dustCharcoal", Character.valueOf('S'), "dustSulfur");
        RecipeManager.addGrinderRecipe(charcoal.newStack(), OreItems.dustCharcoal.item.newStack());
        RecipeManager.addGrinderRecipe(coal.newStack(), OreItems.dustCoal.item.newStack());
        RecipeManager.addGrinderRecipe(OreItems.gemUranium.item.newStack(), OreItems.crushedUranium.item.newStack());
        Helpers.IC2.registerRecipe("Macerator", OreItems.gemUranium.item.newStack(), OreItems.crushedUranium.item.newStack());
        RecipeManager.addGrinderRecipe(GeneralOres.Uranium.ore.newStack(), OreItems.crushedUranium.item.newStack(2));
        NBTTagCompound cranks = new NBTTagCompound();
        cranks.func_74768_a("cranks", 8);
        Helpers.AppliedEnergistics.registerRecipe("grinder", GeneralOres.Uranium.ore.newStack(), cranks, OreItems.crushedUranium.item.newStack());
        int amount = 4;
        if (OresPlus.difficultAlloys) {
            amount = 2;
        }
        RecipeManager.addShapelessRecipe(MetallicOres.Brass.dust.newStack(amount), "dustCopper", "dustCopper", "dustCopper", "dustZinc");
        RecipeManager.addShapelessRecipe(MetallicOres.Bronze.dust.newStack(amount), "dustCopper", "dustCopper", "dustCopper", "dustTin");
        RecipeManager.addShapelessRecipe(MetallicOres.Electrum.dust.newStack(2), "dustGold", "dustSilver");
        RecipeManager.addSmelting(GeneralOres.NetherCoal.ore.newStack(), oreCoal.newStack(2), Float.valueOf(0.0f));
        RecipeManager.addSmelting(GeneralOres.NetherLapis.ore.newStack(), oreLapis.newStack(2), Float.valueOf(0.0f));
        RecipeManager.addSmelting(GeneralOres.NetherUranium.ore.newStack(), GeneralOres.Uranium.ore.newStack(2), Float.valueOf(0.0f));
        if (fertalizer.source != null) {
            RecipeManager.addShapelessRecipe(fertalizer.newStack(8), DustOres.Saltpeter.dustName, DustOres.Phosphorite.dustName, DustOres.Potash.dustName);
            RecipeManager.addShapelessRecipe(fertalizer.newStack(12), DustOres.Saltpeter.dustName, DustOres.Saltpeter.dustName, DustOres.Phosphorite.dustName, DustOres.Potash.dustName);
            RecipeManager.addShapelessRecipe(fertalizer.newStack(12), DustOres.Saltpeter.dustName, DustOres.Phosphorite.dustName, DustOres.Phosphorite.dustName, DustOres.Potash.dustName);
            RecipeManager.addShapelessRecipe(fertalizer.newStack(12), DustOres.Saltpeter.dustName, DustOres.Phosphorite.dustName, DustOres.Potash.dustName, DustOres.Potash.dustName);
            RecipeManager.addShapelessRecipe(fertalizer.newStack(12), DustOres.Saltpeter.dustName, DustOres.Phosphorite.dustName, DustOres.Potash.dustName, OreItems.dustMagnesium.item.newStack());
            RecipeManager.addShapelessRecipe(fertalizer.newStack(16), DustOres.Saltpeter.dustName, DustOres.Saltpeter.dustName, DustOres.Phosphorite.dustName, DustOres.Potash.dustName, OreItems.dustMagnesium.item.newStack());
            RecipeManager.addShapelessRecipe(fertalizer.newStack(16), DustOres.Saltpeter.dustName, DustOres.Phosphorite.dustName, DustOres.Phosphorite.dustName, DustOres.Potash.dustName, OreItems.dustMagnesium.item.newStack());
            RecipeManager.addShapelessRecipe(fertalizer.newStack(16), DustOres.Saltpeter.dustName, DustOres.Phosphorite.dustName, DustOres.Potash.dustName, DustOres.Potash.dustName, OreItems.dustMagnesium.item.newStack());
        }
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorAdamantineHelmet.newStack(), "aaa", "a a", Character.valueOf('a'), MetallicOres.Adamantine.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorAdamantineChestplate.newStack(), "a a", "aaa", "aaa", Character.valueOf('a'), MetallicOres.Adamantine.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorAdamantineLeggings.newStack(), "aaa", "a a", "a a", Character.valueOf('a'), MetallicOres.Adamantine.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorAdamantineBoots.newStack(), "a a", "a a", Character.valueOf('a'), MetallicOres.Adamantine.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorColdironHelmet.newStack(), "ccc", "c c", Character.valueOf('c'), MetallicOres.Coldiron.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorColdironChestplate.newStack(), "c c", "ccc", "ccc", Character.valueOf('c'), MetallicOres.Coldiron.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorColdironLeggings.newStack(), "ccc", "c c", "c c", Character.valueOf('c'), MetallicOres.Coldiron.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorColdironBoots.newStack(), "c c", "c c", Character.valueOf('c'), MetallicOres.Coldiron.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorMithralHelmet.newStack(), "mmm", "m m", Character.valueOf('m'), MetallicOres.Mithral.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorMithralChestplate.newStack(), "m m", "mmm", "mmm", Character.valueOf('m'), MetallicOres.Mithral.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorMithralLeggings.newStack(), "mmm", "m m", "m m", Character.valueOf('m'), MetallicOres.Mithral.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.armorMithralBoots.newStack(), "m m", "m m", Character.valueOf('m'), MetallicOres.Mithral.ingotName);
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolAdamantineAxe.newStack(), " aa", " sa", " s ", Character.valueOf('a'), MetallicOres.Adamantine.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolAdamantineHoe.newStack(), " aa", " s ", " s ", Character.valueOf('a'), MetallicOres.Adamantine.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolAdamantinePickaxe.newStack(), "aaa", " s ", " s ", Character.valueOf('a'), MetallicOres.Adamantine.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolAdamantineSpade.newStack(), "a", "s", "s", Character.valueOf('a'), MetallicOres.Adamantine.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolAdamantineSword.newStack(), "a", "a", "s", Character.valueOf('a'), MetallicOres.Adamantine.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolColdironAxe.newStack(), " cc", " sc", " s ", Character.valueOf('c'), MetallicOres.Coldiron.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolColdironHoe.newStack(), " cc", " s ", " s ", Character.valueOf('c'), MetallicOres.Coldiron.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolColdironPickaxe.newStack(), "ccc", " s ", " s ", Character.valueOf('c'), MetallicOres.Coldiron.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolColdironSpade.newStack(), "c", "s", "s", Character.valueOf('c'), MetallicOres.Coldiron.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolColdironSword.newStack(), "c", "c", "s", Character.valueOf('c'), MetallicOres.Coldiron.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolMithralAxe.newStack(), " mm", " sm", " s ", Character.valueOf('c'), MetallicOres.Mithral.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolMithralHoe.newStack(), " mm", " s ", " s ", Character.valueOf('c'), MetallicOres.Mithral.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolMithralPickaxe.newStack(), "mmm", " s ", " s ", Character.valueOf('c'), MetallicOres.Mithral.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolMithralSpade.newStack(), "m", "s", "s", Character.valueOf('m'), MetallicOres.Mithral.ingotName, Character.valueOf('s'), stick.newStack());
        RecipeManager.addShapedRecipe(tw.oresplus.items.Items.toolMithralSword.newStack(), "m", "m", "s", Character.valueOf('c'), MetallicOres.Mithral.ingotName, Character.valueOf('s'), stick.newStack());
        for (MetallicOres metallicOres : MetallicOres.values()) {
            metallicOres.registerRecipes();
        }
        for (Enum enum_ : GemstoneOres.values()) {
            ((GemstoneOres)enum_).registerRecipes();
        }
        for (Enum enum_ : DustOres.values()) {
            ((DustOres)enum_).registerRecipes();
        }
        if (OresPlus.iridiumPlateRecipe && Helpers.IC2.isLoaded()) {
            OreItemStack iridiumPlate = new OreItemStack(Helpers.IC2.getItem("itemPartIridium"));
            OreItemStack alloyPlate = new OreItemStack(Helpers.IC2.getItem("itemPartAlloy"));
            RecipeManager.addShapedRecipe(iridiumPlate.newStack(), "ipi", "pdp", "ipi", Character.valueOf('i'), OreItems.gemIridium.toString(), Character.valueOf('p'), alloyPlate.newStack(), Character.valueOf('d'), GemstoneOres.Diamond.gem.newStack());
        }
    }

    public static void addShapelessRecipe(ItemStack output, Object ... params) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(output, params));
    }

    public static void addSmelting(ItemStack input, ItemStack output, Float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp.floatValue());
    }

    public static void addShapedRecipe(ItemStack output, Object ... params) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(output, params));
    }

    @Deprecated
    public static ItemStack getGrinderRecipeResult(Object input) {
        return Ores.grinderRecipes.getResult(input);
    }

    @Deprecated
    public static boolean isIC2MaceratorRecipe(String oreName) {
        return oreName.equals("Bronze") || oreName.equals("Copper") || oreName.equals("Lead") || oreName.equals("Silver") || oreName.equals("Tin");
    }

    public static void addGrinderRecipe(Object input, ItemStack output) {
        if (!(input instanceof String) && !(input instanceof ItemStack)) {
            return;
        }
        Ores.grinderRecipes.add(input, output);
    }

    public static void replaceRecipeResults() {
        OreLog.info("Replacing smelting results");
        Collection smeltingResultsList = FurnaceRecipes.func_77602_a().func_77599_b().values();
        for (Object result : smeltingResultsList.toArray()) {
            if (!(result instanceof ItemStack)) continue;
            Item item = ((ItemStack)result).func_77973_b();
            GameRegistry.UniqueIdentifier itemUid = GameRegistry.findUniqueIdentifierFor((Item)item);
            OreLog.info("Recipe Result " + itemUid.modId + ":" + itemUid.name);
        }
    }

    public static void hideItem(OreItemStack item) {
        neiHandler.hideItem(item.source);
        tmiHandler.hideItem(item.source);
    }
}

