/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.core.helpers;

import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import tw.oresplus.core.OreLog;
import tw.oresplus.core.helpers.OresHelper;

public class IC2Helper
extends OresHelper {
    private Class genRubTreeClass;
    private Object genRubTreeClassObj;
    private Method genRubTreeMethod;
    private boolean genRubberTree = false;

    public IC2Helper() {
        super("IC2");
    }

    @Override
    public void init() {
        if (!this.isLoaded()) {
            OreLog.info("IC2 not found, helper disabled");
            return;
        }
        if (this.getBlock("blockRubWood") != null) {
            this.genRubberTree = true;
        } else {
            OreLog.info("Rubber Tree gen disabled");
        }
        if (this.genRubberTree) {
            try {
                this.genRubTreeClass = Class.forName("ic2.core.block.WorldGenRubTree");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            Constructor c = null;
            try {
                c = this.genRubTreeClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            if (c != null) {
                c.setAccessible(true);
                try {
                    this.genRubTreeClassObj = c.newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if (this.genRubTreeClass != null && this.genRubTreeClassObj != null) {
                for (Method method : this.genRubTreeClass.getMethods()) {
                    if (!method.getName().equals("func_76484_a")) continue;
                    this.genRubTreeMethod = method;
                }
            }
        }
        OreLog.info("IC2 found, helper Initialized");
    }

    @Override
    public void generate(World world, Random rand, int chunkX, int chunkZ) {
        if (!this.genRubberTree || this.genRubTreeMethod == null) {
            OreLog.info("Rubber tree gen appears to be disabled.");
            return;
        }
        BiomeGenBase biome = world.func_72959_q().func_76935_a(chunkX * 16 + 16, chunkZ * 16 + 16);
        if (biome != null && biome.field_76791_y != null) {
            int numTrees = 0;
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                numTrees += rand.nextInt(10) + 5;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                numTrees += rand.nextInt(5) + 1;
            }
            if (rand.nextInt(100) + 1 <= numTrees * 2) {
                try {
                    this.genRubTreeMethod.invoke(this.genRubTreeClassObj, world, rand, chunkX * 16 + rand.nextInt(16), numTrees, chunkZ * 16 + rand.nextInt(16));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void registerGrind(ItemStack input, ItemStack ... outputs) {
        if (!this.isLoaded()) {
            return;
        }
        if (Recipes.macerator.getOutputFor(input, true) == null) {
            Recipes.macerator.addRecipe(new RecipeInputItemStack(input), null, outputs);
        }
    }

    private void registerWash(ItemStack input, NBTTagCompound metadata, ItemStack ... outputs) {
        if (!this.isLoaded()) {
            return;
        }
        if (Recipes.oreWashing.getOutputFor(input, true) == null) {
            Recipes.oreWashing.addRecipe(new RecipeInputItemStack(input), metadata, outputs);
        }
    }

    @Override
    public void registerRecipe(String recipeType, ItemStack input, NBTTagCompound metadata, ItemStack ... outputs) {
        if (recipeType.equals("Macerator")) {
            this.registerGrind(input, outputs);
        } else if (recipeType.equals("OreWasher")) {
            this.registerWash(input, metadata, outputs);
        }
    }
}

