/*
 * Decompiled with CFR 0.152.
 */
package tw.oresplus.blocks;

import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeTile;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tw.oresplus.blocks.BlockMachine;
import tw.oresplus.core.FuelHelper;
import tw.oresplus.triggers.OresTrigger;

public abstract class NewTileEntityMachine
extends TileEntity
implements IPowerReceptor,
ITriggerProvider,
ISidedInventory {
    private boolean _hasFurnace = false;
    private boolean _furnaceBurning;
    private int _furnaceBurnTime;
    private int _currentItemBurnTime;
    protected float _energyRequired;
    protected float _energySpent;
    protected float _efficiancy = 1.0f;
    protected float _minimumBCEnergyRequired = 25.0f;
    protected float _maximumBCEnergyStored = 1500.0f;
    protected String inventoryName;
    protected String customInventoryName = "";
    protected PowerHandler powerHandler;
    protected ItemStack[] inventory;
    private int furnaceSlot = -1;

    public NewTileEntityMachine(float energyRequired) {
        this._energyRequired = energyRequired;
        this._energySpent = 0.0f;
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.initPowerHandler();
    }

    public NewTileEntityMachine setMinimumBCEnergyRequired(float minimumBCEnergyRequired) {
        this._minimumBCEnergyRequired = minimumBCEnergyRequired;
        this.initPowerHandler();
        return this;
    }

    public NewTileEntityMachine setMaximumBCEnergyStored(float maximumBCEnergyStored) {
        this._maximumBCEnergyStored = maximumBCEnergyStored;
        this.initPowerHandler();
        return this;
    }

    public NewTileEntityMachine setEfficiancy(float efficiancy) {
        this._efficiancy = efficiancy;
        return this;
    }

    public NewTileEntityMachine initFurnace(int slotNum) {
        if (slotNum >= 0) {
            this._hasFurnace = true;
            this.furnaceSlot = slotNum;
        }
        return this;
    }

    private void initPowerHandler() {
        this.powerHandler.configure(50.0, 100.0, this._minimumBCEnergyRequired, this._maximumBCEnergyStored);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerHandler.readFromNBT(tagCompound);
        this._minimumBCEnergyRequired = tagCompound.func_74760_g("minBCEnergy");
        this._maximumBCEnergyStored = tagCompound.func_74760_g("maxBCEnergy");
        this.initPowerHandler();
        this._hasFurnace = tagCompound.func_74767_n("hasFurnace");
        this.furnaceSlot = tagCompound.func_74762_e("furnaceSlot");
        this._efficiancy = tagCompound.func_74760_g("efficiency");
        this._energyRequired = tagCompound.func_74760_g("energyRequired");
        NBTTagList itemList = tagCompound.func_150295_c("inventory", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound tag = itemList.func_150305_b(i);
            byte slot = tag.func_74771_c("slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        if (this.canBurn()) {
            this._furnaceBurnTime = tagCompound.func_74762_e("furnaceBurnTime");
            this._currentItemBurnTime = FuelHelper.getItemBurnTime(this.inventory[this.furnaceSlot]);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.powerHandler.writeToNBT(tagCompound);
        tagCompound.func_74776_a("minBCEnergy", this._minimumBCEnergyRequired);
        tagCompound.func_74776_a("maxBCEnergy", this._maximumBCEnergyStored);
        tagCompound.func_74757_a("hasFurnace", this._hasFurnace);
        tagCompound.func_74768_a("furnaceSlot", this.furnaceSlot);
        tagCompound.func_74776_a("efficiency", this._efficiancy);
        tagCompound.func_74776_a("energyRequired", this._energyRequired);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("inventory", (NBTBase)itemList);
        if (this.canBurn()) {
            tagCompound.func_74768_a("furnaceBurnTime", this._furnaceBurnTime);
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.burnFuel();
        this.powerHandler.update();
    }

    private boolean canBurn() {
        return this._hasFurnace && this.furnaceSlot >= 0;
    }

    private void burnFuel() {
        if (!this.canBurn()) {
            return;
        }
        boolean wasBurning = this._furnaceBurnTime > 0;
        boolean needsSave = false;
        if (this._furnaceBurnTime > 0) {
            --this._furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this._furnaceBurnTime == 0 && this.hasWork()) {
                this._currentItemBurnTime = this._furnaceBurnTime = FuelHelper.getItemBurnTime(this.inventory[this.furnaceSlot]);
                if (this._furnaceBurnTime > 0) {
                    this.func_70296_d();
                    if (this.inventory[this.furnaceSlot] != null) {
                        --this.inventory[this.furnaceSlot].field_77994_a;
                        if (this.inventory[this.furnaceSlot].field_77994_a == 0) {
                            this.inventory[this.furnaceSlot] = this.inventory[this.furnaceSlot].func_77973_b().getContainerItem(this.inventory[this.furnaceSlot]);
                        }
                    }
                }
            }
            if (wasBurning != this._furnaceBurnTime > 0) {
                needsSave = true;
                BlockMachine.updateMachineBlockState(this._furnaceBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (this._furnaceBurnTime > 0) {
            this.powerHandler.addEnergy(1.0);
        }
        if (needsSave) {
            this.func_70296_d();
        }
    }

    public abstract boolean hasWork();

    @Override
    public LinkedList<ITrigger> getPipeTriggers(IPipeTile pipe) {
        return null;
    }

    @Override
    public LinkedList<ITrigger> getNeighborTriggers(Block block, TileEntity tile) {
        LinkedList<ITrigger> triggers = new LinkedList<ITrigger>();
        triggers.add(OresTrigger.hasWork);
        triggers.add(OresTrigger.workDone);
        return triggers;
    }

    public int func_70302_i_() {
        if (this.inventory == null) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot > this.func_70302_i_()) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory != null) {
            ItemStack stack;
            if (this.inventory[slot].field_77994_a <= amount) {
                stack = this.inventory[slot];
                this.inventory[slot] = null;
            } else {
                stack = this.inventory[slot].func_77979_a(amount);
                if (this.inventory[slot].field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack stack = this.inventory[slot];
            this.inventory[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customInventoryName : this.inventoryName;
    }

    public boolean func_145818_k_() {
        return this.customInventoryName != "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

