/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import exter.fodc.block.BlockAutomaticOreConverter;
import exter.fodc.block.BlockOreConversionTable;
import exter.fodc.item.ItemOreConverter;
import exter.fodc.network.ODCPacketHandler;
import exter.fodc.proxy.CommonODCProxy;
import exter.fodc.registry.OreNameRegistry;
import exter.fodc.tileentity.TileEntityAutomaticOreConverter;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="fodc", name="OreDicConvert", version="1.5.0", dependencies="required-after:Forge@[10.12.0.1057,)")
public class ModOreDicConvert {
    public static ItemOreConverter item_oreconverter = null;
    @Mod.Instance(value="fodc")
    public static ModOreDicConvert instance;
    @SidedProxy(clientSide="exter.fodc.proxy.ClientODCProxy", serverSide="exter.fodc.proxy.CommonODCProxy")
    public static CommonODCProxy proxy;
    public static BlockOreConversionTable block_oreconvtable;
    public static BlockAutomaticOreConverter block_oreautoconv;
    public static Logger log;
    public static FMLEventChannel network_channel;
    public static ODCPacketHandler net_handler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        OreNameRegistry.PreInit(config);
        config.save();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        block_oreconvtable = (BlockOreConversionTable)new BlockOreConversionTable().func_149711_c(2.5f).func_149672_a(Block.field_149766_f);
        block_oreautoconv = (BlockAutomaticOreConverter)new BlockAutomaticOreConverter().func_149711_c(2.5f).func_149672_a(Block.field_149769_e);
        item_oreconverter = new ItemOreConverter();
        network_channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("EXTER.FODC");
        GameRegistry.registerBlock((Block)block_oreconvtable, (String)"oreConvTable");
        GameRegistry.registerBlock((Block)block_oreautoconv, (String)"oreAutoconverter");
        GameRegistry.registerItem((Item)item_oreconverter, (String)"oreConverter");
        net_handler = new ODCPacketHandler();
        network_channel.register((Object)net_handler);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        ItemStack iron_stack = new ItemStack(Items.field_151042_j);
        ItemStack redstone_stack = new ItemStack(Items.field_151137_ax);
        ItemStack workbench_stack = new ItemStack(Blocks.field_150462_ai);
        ItemStack wood_stack = new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE);
        ItemStack cobble_stack = new ItemStack(Blocks.field_150347_e, 1, Short.MAX_VALUE);
        ItemStack oreconverter_stack = new ItemStack((Item)item_oreconverter);
        GameRegistry.registerTileEntity(TileEntityAutomaticOreConverter.class, (String)"AutoOreConverter");
        GameRegistry.addRecipe((ItemStack)oreconverter_stack, (Object[])new Object[]{"I", "C", "B", Character.valueOf('I'), iron_stack, Character.valueOf('C'), cobble_stack, Character.valueOf('B'), workbench_stack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)block_oreconvtable), (Object[])new Object[]{"O", "W", Character.valueOf('O'), oreconverter_stack, Character.valueOf('W'), wood_stack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)block_oreautoconv), (Object[])new Object[]{"IOI", "CRC", "ICI", Character.valueOf('I'), iron_stack, Character.valueOf('O'), oreconverter_stack, Character.valueOf('R'), redstone_stack, Character.valueOf('C'), cobble_stack});
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        String[] ore_names;
        for (String name : ore_names = OreDictionary.getOreNames()) {
            if (name == null) {
                log.warning("null name in Ore Dictionary.");
                continue;
            }
            OreNameRegistry.RegisterOreName(name);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void OnOreDictionaryRegister(OreDictionary.OreRegisterEvent event) {
        OreNameRegistry.RegisterOreName(event.Name);
    }

    static {
        log = Logger.getLogger("OreDicConvert");
    }
}

