/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import exter.fodc.registry.OreNameRegistry;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAutomaticOreConverter
extends TileEntity
implements ISidedInventory {
    private ItemStack[] inventory = new ItemStack[SIZE_INVENTORY];
    private ItemStack[] targets = new ItemStack[SIZE_TARGETS];
    private ItemStack last_input;
    private ItemStack last_target;
    public static int SIZE_INVENTORY = 14;
    public static int SIZE_TARGETS = 18;
    private int process_tick = 0;
    private boolean update_targets = false;
    private static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};

    private void WriteItemToNBT(NBTTagCompound compound, int slot) {
        ItemStack is = this.func_70301_a(slot);
        NBTTagCompound tag = new NBTTagCompound();
        if (is != null) {
            tag.func_74757_a("empty", false);
            is.func_77955_b(tag);
        } else {
            tag.func_74757_a("empty", true);
        }
        compound.func_74782_a("Item_" + String.valueOf(slot), (NBTBase)tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound tag;
        int i;
        super.func_145839_a(compound);
        NBTTagList targets_tag = (NBTTagList)compound.func_74781_a("Targets");
        for (i = 0; i < this.inventory.length; ++i) {
            tag = (NBTTagCompound)compound.func_74781_a("Item_" + String.valueOf(i));
            if (tag == null) continue;
            ItemStack stack = null;
            if (!tag.func_74767_n("empty")) {
                stack = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
            this.func_70299_a(i, stack);
        }
        if (targets_tag != null) {
            this.targets = new ItemStack[SIZE_TARGETS];
            for (i = 0; i < targets_tag.func_74745_c(); ++i) {
                tag = targets_tag.func_150305_b(i);
                int slot = tag.func_74771_c("Slot") & 0xFF;
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
                is.field_77994_a = 1;
                this.SetTarget(slot, is);
            }
        }
    }

    private void WriteTargetsToNBT(NBTTagCompound compound) {
        NBTTagList targets_tag = new NBTTagList();
        for (int i = 0; i < this.targets.length; ++i) {
            ItemStack t = this.targets[i];
            if (t == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            t.func_77955_b(tag);
            targets_tag.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("Targets", (NBTBase)targets_tag);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        for (int i = 0; i < this.inventory.length; ++i) {
            this.WriteItemToNBT(compound, i);
        }
        this.WriteTargetsToNBT(compound);
    }

    private static ItemStack ReadItem(ByteBufInputStream data) throws IOException {
        int len = data.readInt();
        byte[] bytes = new byte[len];
        if (data.read(bytes) < len) {
            throw new IOException();
        }
        return ItemStack.func_77949_a((NBTTagCompound)CompressedStreamTools.func_74792_a((byte[])bytes));
    }

    private void SendPacketToPlayers(Packet packet) {
        int MAX_DISTANCE = 192;
        if (!this.field_145850_b.field_72995_K && packet != null) {
            for (int j = 0; j < this.field_145850_b.field_73010_i.size(); ++j) {
                EntityPlayerMP player = (EntityPlayerMP)this.field_145850_b.field_73010_i.get(j);
                if (!(Math.abs(player.field_70165_t - (double)this.field_145851_c) <= 192.0) || !(Math.abs(player.field_70163_u - (double)this.field_145848_d) <= 192.0) || !(Math.abs(player.field_70161_v - (double)this.field_145849_e) <= 192.0) || player.field_71093_bK != this.field_145850_b.field_73011_w.field_76574_g) continue;
                player.field_71135_a.func_147359_a(packet);
            }
        }
    }

    public void ReceivePacketData(ByteBufInputStream data) {
        try {
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                int slot = data.readByte() & 0xFF;
                boolean has_target = data.readBoolean();
                ItemStack target = null;
                if (has_target) {
                    target = TileEntityAutomaticOreConverter.ReadItem(data);
                }
                this.update_targets = true;
                this.SetTarget(slot, target);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int func_70302_i_() {
        return SIZE_INVENTORY;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack var3 = this.inventory[slot];
                this.inventory[slot] = null;
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            this.func_70296_d();
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.inventory[par1] != null) {
            ItemStack var2 = this.inventory[par1];
            this.inventory[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.inventory[slot] = item;
        if (item != null && item.field_77994_a > this.func_70297_j_()) {
            item.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "container.oreAutoconverter";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    private ItemStack FindConversionTarget(ItemStack item) {
        if (this.last_input != null && this.last_target != null && item.func_77969_a(this.last_input) && ItemStack.func_77970_a((ItemStack)item, (ItemStack)this.last_input)) {
            return this.last_target;
        }
        Set<String> names = OreNameRegistry.FindAllOreNames(item);
        if (names.isEmpty()) {
            this.last_target = this.last_input = item.func_77946_l();
            return item;
        }
        for (ItemStack t : this.targets) {
            Set<String> target_names;
            if (t == null || !names.containsAll(target_names = OreNameRegistry.FindAllOreNames(t))) continue;
            this.last_input = item.func_77946_l();
            this.last_target = t;
            return t;
        }
        ItemStack target = item;
        int target_diff = Integer.MAX_VALUE;
        for (String name : names) {
            for (ItemStack stack : OreDictionary.getOres((String)name)) {
                int diff;
                Set<String> target_names = OreNameRegistry.FindAllOreNames(stack);
                if (!names.containsAll(target_names) || (diff = names.size() - target_names.size()) >= target_diff) continue;
                target_diff = diff;
                target = stack;
                if (diff != 0) continue;
                this.last_input = item.func_77946_l();
                this.last_target = target;
                return target;
            }
        }
        this.last_input = item.func_77946_l();
        this.last_target = target;
        return target;
    }

    private NBTTagCompound CreateUpdatePacket() {
        NBTTagCompound packet = new NBTTagCompound();
        super.func_145841_b(packet);
        return packet;
    }

    private NBTTagCompound ProcessItems() {
        NBTTagCompound packet = null;
        for (int i = 7; i >= 0; --i) {
            ItemStack input = this.inventory[i];
            if (input == null) continue;
            ItemStack target = this.FindConversionTarget(input);
            for (int j = 8; j < 14; ++j) {
                ItemStack output = this.inventory[j];
                if (output == null) {
                    this.inventory[j] = target.func_77946_l();
                    this.inventory[j].field_77994_a = input.field_77994_a;
                    this.inventory[i] = null;
                    if (packet == null) {
                        packet = this.CreateUpdatePacket();
                    }
                    this.WriteItemToNBT(packet, i);
                    this.WriteItemToNBT(packet, j);
                    return packet;
                }
                if (output.field_77994_a >= output.func_77976_d() || !output.func_77969_a(target) || !ItemStack.func_77970_a((ItemStack)target, (ItemStack)output)) continue;
                int transfer = output.func_77976_d() - output.field_77994_a;
                if (transfer >= input.field_77994_a) {
                    this.inventory[i] = null;
                    output.field_77994_a += input.field_77994_a;
                    if (packet == null) {
                        packet = this.CreateUpdatePacket();
                    }
                    this.WriteItemToNBT(packet, i);
                    this.WriteItemToNBT(packet, j);
                    return packet;
                }
                input.field_77994_a -= transfer;
                output.field_77994_a += transfer;
                if (packet == null) {
                    packet = this.CreateUpdatePacket();
                }
                this.WriteItemToNBT(packet, i);
                this.WriteItemToNBT(packet, j);
            }
            if (packet != null) break;
        }
        return packet;
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.process_tick = (this.process_tick + 1) % 5;
        NBTTagCompound packet = null;
        if (this.process_tick == 0) {
            packet = this.ProcessItems();
        }
        if (this.update_targets) {
            this.update_targets = false;
            if (packet == null) {
                packet = this.CreateUpdatePacket();
            }
            this.WriteTargetsToNBT(packet);
        }
        if (packet != null) {
            this.func_70296_d();
            this.SendPacketToPlayers((Packet)new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, packet));
        }
    }

    public void SetTarget(int slot, ItemStack target) {
        if (!(slot < 0 || slot >= SIZE_TARGETS || target != null && OreNameRegistry.FindAllOreNames(target).isEmpty())) {
            this.targets[slot] = target;
            this.last_input = null;
            this.last_target = null;
        }
    }

    public ItemStack GetTarget(int slot) {
        if (slot < 0 || slot >= SIZE_TARGETS) {
            return null;
        }
        return this.targets[slot];
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i >= 0 && i < 8;
    }

    public int[] func_94128_d(int side) {
        return ALL_SLOTS;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i >= 8 && i < 14;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }
}

