/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc.registry;

import exter.fodc.ModOreDicConvert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class OreNameRegistry {
    private static Set<String> valid_ore_names;
    private static List<Pattern> whitelist;
    private static List<Pattern> blacklist;
    private static final String REGEX_COMMENT = "Supports multiple expressions separated by commas.\nUses Java's Pattern class regex syntax. See the following page for more info about Pattern regex syntax:\nhttp://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html";
    private static final String WHITELIST_COMMENT = "Only names that match any of these regexes will be registered. Supports multiple expressions separated by commas.\nUses Java's Pattern class regex syntax. See the following page for more info about Pattern regex syntax:\nhttp://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html";
    private static final String BLACKLIST_COMMENT = "Names that match any of these regexes will not be registered. Supports multiple expressions separated by commas.\nUses Java's Pattern class regex syntax. See the following page for more info about Pattern regex syntax:\nhttp://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html";

    public static void PreInit(Configuration config) {
        valid_ore_names = new HashSet<String>();
        String whitelist_line = config.get("general", "whitelist", "^ore.*,^ingot.*,^dust.*,^block.*", WHITELIST_COMMENT).getString();
        String blacklist_line = config.get("general", "blacklist", "", BLACKLIST_COMMENT).getString();
        whitelist = OreNameRegistry.CompilePatterns(whitelist_line);
        blacklist = OreNameRegistry.CompilePatterns(blacklist_line);
    }

    private static List<Pattern> CompilePatterns(String line) {
        String[] tokens;
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        for (String t : tokens = line.split(",")) {
            if ((t = t.trim()) == null || t.isEmpty()) continue;
            try {
                list.add(Pattern.compile(t));
            }
            catch (PatternSyntaxException e) {
                ModOreDicConvert.log.warning("Pattern '" + t + "' has invalid syntax.");
            }
        }
        return list;
    }

    private static boolean MatchesAnyPattern(String str, List<Pattern> patterns) {
        for (Pattern p : patterns) {
            if (!p.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    public static Set<String> FindAllOreNames(ItemStack it) {
        HashSet<String> results = new HashSet<String>();
        for (String name : valid_ore_names) {
            for (ItemStack ore : OreDictionary.getOres((String)name)) {
                if (!it.func_77969_a(ore)) continue;
                results.add(name);
            }
        }
        return results;
    }

    public static void RegisterOreName(String name) {
        if (OreNameRegistry.MatchesAnyPattern(name, whitelist) && !OreNameRegistry.MatchesAnyPattern(name, blacklist)) {
            valid_ore_names.add(name);
            ModOreDicConvert.log.info("registered ore name: " + name);
        }
    }
}

