/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc.tileentity;

import com.google.common.io.ByteArrayDataInput;
import exter.fodc.ModOreDicConvert;
import exter.fodc.network.ODCPacketHandler;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAutomaticOreConverter
extends TileEntity
implements ISidedInventory {
    private ItemStack[] inventory = new ItemStack[SIZE_INVENTORY];
    private ItemStack[] targets = new ItemStack[SIZE_TARGETS];
    private ItemStack last_input;
    private ItemStack last_target;
    public static int SIZE_INVENTORY = 14;
    public static int SIZE_TARGETS = 18;
    private static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        int slot;
        NBTTagCompound tag;
        int i;
        super.func_70307_a(par1NBTTagCompound);
        NBTTagList inv_tag = par1NBTTagCompound.func_74761_m("Items");
        NBTTagList targets_tag = par1NBTTagCompound.func_74761_m("Targets");
        this.inventory = new ItemStack[SIZE_INVENTORY];
        this.targets = new ItemStack[SIZE_TARGETS];
        for (i = 0; i < inv_tag.func_74745_c(); ++i) {
            tag = (NBTTagCompound)inv_tag.func_74743_b(i);
            slot = tag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        for (i = 0; i < targets_tag.func_74745_c(); ++i) {
            tag = (NBTTagCompound)targets_tag.func_74743_b(i);
            slot = tag.func_74771_c("Slot") & 0xFF;
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            is.field_77994_a = 1;
            this.SetTarget(slot, is);
        }
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        NBTTagCompound tag;
        int i;
        super.func_70310_b(par1NBTTagCompound);
        NBTTagList inv_tag = new NBTTagList();
        NBTTagList targets_tag = new NBTTagList();
        for (i = 0; i < this.inventory.length; ++i) {
            ItemStack is = this.inventory[i];
            if (is == null) continue;
            tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            is.func_77955_b(tag);
            inv_tag.func_74742_a((NBTBase)tag);
        }
        for (i = 0; i < this.targets.length; ++i) {
            ItemStack t = this.targets[i];
            if (t == null) continue;
            tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            t.func_77955_b(tag);
            targets_tag.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)inv_tag);
        par1NBTTagCompound.func_74782_a("Targets", (NBTBase)targets_tag);
    }

    public void ReceivePacketData(INetworkManager manager, Packet250CustomPayload packet, EntityPlayer entityPlayer, ByteArrayDataInput data) {
        int type = data.readByte() & 0xFF;
        switch (type) {
            case 0: {
                int slot = data.readByte() & 0xFF;
                int target_id = data.readInt();
                int target_dmg = data.readInt();
                ItemStack target = null;
                if (target_id >= 0) {
                    target = new ItemStack(target_id, 1, target_dmg);
                }
                if (this.field_70331_k.field_72995_K) break;
                this.SetTarget(slot, target);
                break;
            }
            case 1: {
                int size = data.readByte() & 0xFF;
                for (int i = 0; i < size; ++i) {
                    int slot = data.readByte() & 0xFF;
                    int target_id = data.readInt();
                    int target_dmg = data.readInt();
                    ItemStack target = null;
                    if (target_id >= 0) {
                        target = new ItemStack(target_id, 1, target_dmg);
                    }
                    if (!this.field_70331_k.field_72995_K) continue;
                    this.SetTarget(slot, target);
                }
                break;
            }
        }
    }

    public int func_70302_i_() {
        return SIZE_INVENTORY;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack var3 = this.inventory[slot];
                this.inventory[slot] = null;
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            this.func_70296_d();
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.inventory[par1] != null) {
            ItemStack var2 = this.inventory[par1];
            this.inventory[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.inventory[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return "Ore Autoconverter";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        if (!this.field_70331_k.field_72995_K) {
            ODCPacketHandler.SendAllAutoOreConverterTargets(this);
        }
    }

    public void func_70305_f() {
        if (!this.field_70331_k.field_72995_K) {
            ODCPacketHandler.SendAllAutoOreConverterTargets(this);
        }
    }

    private ItemStack FindConversionTarget(ItemStack item) {
        if (this.last_input != null && this.last_target != null && item.func_77969_a(this.last_input) && ItemStack.func_77970_a((ItemStack)item, (ItemStack)this.last_input)) {
            return this.last_target;
        }
        Set<String> names = ModOreDicConvert.instance.FindAllOreNames(item);
        if (names.isEmpty()) {
            this.last_target = this.last_input = item.func_77946_l();
            return item;
        }
        for (ItemStack t : this.targets) {
            Set<String> target_names;
            if (t == null || !names.containsAll(target_names = ModOreDicConvert.instance.FindAllOreNames(t))) continue;
            this.last_input = item.func_77946_l();
            this.last_target = t;
            return t;
        }
        ItemStack target = item;
        int target_diff = Integer.MAX_VALUE;
        for (String name : names) {
            for (ItemStack stack : OreDictionary.getOres((String)name)) {
                int diff;
                Set<String> target_names = ModOreDicConvert.instance.FindAllOreNames(stack);
                if (!names.containsAll(target_names) || (diff = names.size() - target_names.size()) >= target_diff) continue;
                target_diff = diff;
                target = stack;
                if (diff != 0) continue;
                this.last_input = item.func_77946_l();
                this.last_target = target;
                return target;
            }
        }
        this.last_input = item.func_77946_l();
        this.last_target = target;
        return target;
    }

    public void func_70316_g() {
        for (int i = 0; i < 8; ++i) {
            int j;
            ItemStack input = this.inventory[i];
            if (input == null) continue;
            ItemStack target = this.FindConversionTarget(input);
            ItemStack dest = null;
            for (j = 8; j < 14; ++j) {
                ItemStack d = this.inventory[j];
                if (d == null || d.field_77994_a >= d.func_77976_d() || !d.func_77969_a(target) || !ItemStack.func_77970_a((ItemStack)target, (ItemStack)d)) continue;
                dest = d;
                break;
            }
            if (dest == null) {
                for (j = 8; j < 14; ++j) {
                    if (this.inventory[j] != null) continue;
                    dest = target.func_77946_l();
                    dest.field_77994_a = 0;
                    this.inventory[j] = dest;
                    break;
                }
            }
            if (dest == null) continue;
            this.func_70298_a(i, 1);
            ++dest.field_77994_a;
            this.func_70296_d();
            return;
        }
    }

    public void SetTarget(int slot, ItemStack target) {
        if (!(slot < 0 || slot >= SIZE_TARGETS || target != null && ModOreDicConvert.instance.FindAllOreNames(target).isEmpty())) {
            this.targets[slot] = target;
            this.last_input = null;
            this.last_target = null;
        }
    }

    public ItemStack GetTarget(int slot) {
        if (slot < 0 || slot >= SIZE_TARGETS) {
            return null;
        }
        return this.targets[slot];
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i >= 0 && i < 6;
    }

    public int[] func_94128_d(int side) {
        return ALL_SLOTS;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i >= 6 && i < 14;
    }
}

