/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import exter.fodc.block.BlockAutomaticOreConverter;
import exter.fodc.block.BlockOreConversionTable;
import exter.fodc.item.ItemOreConverter;
import exter.fodc.network.ODCPacketHandler;
import exter.fodc.proxy.CommonODCProxy;
import exter.fodc.tileentity.TileEntityAutomaticOreConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="fodc", name="OreDicConvert", version="1.4.3", dependencies="required-after:Forge@[9.11.1.964,)")
@NetworkMod(channels={"FODC"}, clientSideRequired=true, serverSideRequired=true, packetHandler=ODCPacketHandler.class)
public class ModOreDicConvert {
    private int oc_id;
    private int oct_id;
    private int aoc_id;
    private String[] prefixes;
    public static ItemOreConverter item_oreconverter = null;
    @Mod.Instance(value="fodc")
    public static ModOreDicConvert instance;
    @SidedProxy(clientSide="exter.fodc.proxy.ClientODCProxy", serverSide="exter.fodc.proxy.CommonODCProxy")
    public static CommonODCProxy proxy;
    public static BlockOreConversionTable block_oreconvtable;
    public static BlockAutomaticOreConverter block_oreautoconv;
    public ArrayList<String> valid_ore_names;
    public static Logger log;

    public Set<String> FindAllOreNames(ItemStack it) {
        HashSet<String> results = new HashSet<String>();
        for (String name : this.valid_ore_names) {
            for (ItemStack ore : OreDictionary.getOres((String)name)) {
                if (!it.func_77969_a(ore)) continue;
                results.add(name);
            }
        }
        return results;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        String classes = config.get("general", "classprefixes", "ore,ingot,dust,block").getString();
        this.oc_id = config.get("item", "oreconverter", 9001).getInt(9001);
        this.oct_id = config.get("block", "oreconverisontable", 3826).getInt(3826);
        this.aoc_id = config.get("block", "oreautoconverter", 3827).getInt(3827);
        config.save();
        this.prefixes = classes.split(",");
        this.valid_ore_names = new ArrayList();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        block_oreconvtable = (BlockOreConversionTable)new BlockOreConversionTable(this.oct_id).func_71848_c(2.5f).func_71884_a(Block.field_71967_e).func_71864_b("oreConvTable");
        block_oreautoconv = (BlockAutomaticOreConverter)new BlockAutomaticOreConverter(this.aoc_id).func_71848_c(2.5f).func_71884_a(Block.field_71967_e).func_71864_b("autoOreConverter");
        item_oreconverter = new ItemOreConverter(this.oc_id);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        ItemStack iron_stack = new ItemStack(Item.field_77703_o);
        ItemStack redstone_stack = new ItemStack(Item.field_77767_aC);
        ItemStack workbench_stack = new ItemStack(Block.field_72060_ay);
        ItemStack wood_stack = new ItemStack(Block.field_71988_x, 1, -1);
        ItemStack cobble_stack = new ItemStack(Block.field_71978_w, 1, -1);
        ItemStack oreconverter_stack = new ItemStack((Item)item_oreconverter);
        LanguageRegistry.addName((Object)((Object)item_oreconverter), (String)"Ore Converter");
        LanguageRegistry.addName((Object)((Object)block_oreconvtable), (String)"Ore Conversion Table");
        LanguageRegistry.addName((Object)((Object)block_oreautoconv), (String)"Automatic Ore Converter");
        GameRegistry.registerBlock((Block)block_oreconvtable, (String)"oreConvTable");
        GameRegistry.registerBlock((Block)block_oreautoconv, (String)"oreConvChest");
        GameRegistry.registerTileEntity(TileEntityAutomaticOreConverter.class, (String)"AutoOreConverter");
        proxy.Init();
        GameRegistry.addRecipe((ItemStack)oreconverter_stack, (Object[])new Object[]{"I", "C", "B", Character.valueOf('I'), iron_stack, Character.valueOf('C'), cobble_stack, Character.valueOf('B'), workbench_stack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)block_oreconvtable), (Object[])new Object[]{"O", "W", Character.valueOf('O'), oreconverter_stack, Character.valueOf('W'), wood_stack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)block_oreautoconv), (Object[])new Object[]{"IOI", "CRC", "ICI", Character.valueOf('I'), iron_stack, Character.valueOf('O'), oreconverter_stack, Character.valueOf('R'), redstone_stack, Character.valueOf('C'), cobble_stack});
    }

    private void RegisterOreName(String name) {
        if (this.valid_ore_names.contains(name)) {
            return;
        }
        boolean found = false;
        for (String cl : this.prefixes) {
            if (cl == null || !name.startsWith(cl)) continue;
            found = true;
            break;
        }
        if (found) {
            this.valid_ore_names.add(name);
            log.info("registered ore name: " + name);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        String[] ore_names;
        log.setParent(FMLLog.getLogger());
        for (String name : ore_names = OreDictionary.getOreNames()) {
            if (name == null) {
                log.warning("null name in Ore Dictionary.");
                continue;
            }
            this.RegisterOreName(name);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @ForgeSubscribe
    public void OnOreDictionaryRegister(OreDictionary.OreRegisterEvent event) {
        this.RegisterOreName(event.Name);
    }

    static {
        log = Logger.getLogger("OreDicConvert");
    }
}

