/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;

public class Config {
    public static final String OF_NAME = "OptiFine";
    public static final String MC_VERSION = "1.6.4";
    public static final String OF_EDITION = "HD_U";
    public static final String OF_RELEASE = "C7";
    public static final String VERSION = "OptiFine_1.6.4_HD_U_C7";
    private static String newRelease = null;
    private static aul gameSettings = null;
    private static atv minecraft = null;
    private static boolean initialized = false;
    private static Thread minecraftThread = null;
    private static DisplayMode desktopDisplayMode = null;
    private static int antialiasingLevel = 0;
    private static int availableProcessors = 0;
    public static boolean zoomMode = false;
    private static int texturePackClouds = 0;
    public static boolean waterOpacityChanged = false;
    private static boolean fullscreenModeChecked = false;
    private static boolean desktopModeChecked = false;
    private static PrintStream systemOut = new PrintStream(new FileOutputStream(FileDescriptor.out));
    public static final Boolean DEF_FOG_FANCY = true;
    public static final Float DEF_FOG_START = Float.valueOf(0.2f);
    public static final Boolean DEF_OPTIMIZE_RENDER_DISTANCE = false;
    public static final Boolean DEF_OCCLUSION_ENABLED = false;
    public static final Integer DEF_MIPMAP_LEVEL = 0;
    public static final Integer DEF_MIPMAP_TYPE = 9984;
    public static final Float DEF_ALPHA_FUNC_LEVEL = Float.valueOf(0.1f);
    public static final Boolean DEF_LOAD_CHUNKS_FAR = false;
    public static final Integer DEF_PRELOADED_CHUNKS = 0;
    public static final Integer DEF_CHUNKS_LIMIT = 25;
    public static final Integer DEF_UPDATES_PER_FRAME = 3;
    public static final Boolean DEF_DYNAMIC_UPDATES = false;

    private Config() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static void initGameSettings(aul settings) {
        gameSettings = settings;
        minecraft = atv.w();
        desktopDisplayMode = Display.getDesktopDisplayMode();
    }

    public static void initDisplay() {
        Config.checkInitialized();
        antialiasingLevel = Config.gameSettings.ofAaLevel;
        Config.checkDisplaySettings();
        Config.checkDisplayMode();
        minecraftThread = Thread.currentThread();
        Config.updateThreadPriorities();
    }

    public static void checkInitialized() {
        if (initialized) {
            return;
        }
        if (!Display.isCreated()) {
            return;
        }
        initialized = true;
        Config.checkOpenGlCaps();
        Config.startVersionCheckThread();
    }

    private static void checkOpenGlCaps() {
        Config.log("");
        Config.log(Config.getVersion());
        Config.log("" + new Date());
        Config.log("OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        Config.log("Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        Config.log("VM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        Config.log("LWJGL: " + Sys.getVersion());
        Config.log("OpenGL: " + GL11.glGetString((int)7937) + " version " + GL11.glGetString((int)7938) + ", " + GL11.glGetString((int)7936));
        int ver = Config.getOpenGlVersion();
        String verStr = "" + ver / 10 + "." + ver % 10;
        Config.log("OpenGL Version: " + verStr);
        if (!GLContext.getCapabilities().OpenGL12) {
            Config.log("OpenGL Mipmap levels: Not available (GL12.GL_TEXTURE_MAX_LEVEL)");
        }
        if (!GLContext.getCapabilities().GL_NV_fog_distance) {
            Config.log("OpenGL Fancy fog: Not available (GL_NV_fog_distance)");
        }
        if (!GLContext.getCapabilities().GL_ARB_occlusion_query) {
            Config.log("OpenGL Occlussion culling: Not available (GL_ARB_occlusion_query)");
        }
        int maxTexSize = atv.y();
        Config.dbg("Maximum texture size: " + maxTexSize + "x" + maxTexSize);
    }

    public static boolean isFancyFogAvailable() {
        return GLContext.getCapabilities().GL_NV_fog_distance;
    }

    public static boolean isOcclusionAvailable() {
        return GLContext.getCapabilities().GL_ARB_occlusion_query;
    }

    private static int getOpenGlVersion() {
        if (!GLContext.getCapabilities().OpenGL11) {
            return 10;
        }
        if (!GLContext.getCapabilities().OpenGL12) {
            return 11;
        }
        if (!GLContext.getCapabilities().OpenGL13) {
            return 12;
        }
        if (!GLContext.getCapabilities().OpenGL14) {
            return 13;
        }
        if (!GLContext.getCapabilities().OpenGL15) {
            return 14;
        }
        if (!GLContext.getCapabilities().OpenGL20) {
            return 15;
        }
        if (!GLContext.getCapabilities().OpenGL21) {
            return 20;
        }
        if (!GLContext.getCapabilities().OpenGL30) {
            return 21;
        }
        if (!GLContext.getCapabilities().OpenGL31) {
            return 30;
        }
        if (!GLContext.getCapabilities().OpenGL32) {
            return 31;
        }
        if (!GLContext.getCapabilities().OpenGL33) {
            return 32;
        }
        if (!GLContext.getCapabilities().OpenGL40) {
            return 33;
        }
        return 40;
    }

    public static void updateThreadPriorities() {
        try {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            if (tg == null) {
                return;
            }
            int num = (tg.activeCount() + 10) * 2;
            Thread[] ts = new Thread[num];
            tg.enumerate(ts, false);
            int prioMc = 5;
            int prioSrv = 5;
            if (Config.isSmoothWorld()) {
                prioSrv = 3;
            }
            minecraftThread.setPriority(prioMc);
            for (int i = 0; i < ts.length; ++i) {
                Thread t = ts[i];
                if (t == null || !(t instanceof hi)) continue;
                t.setPriority(prioSrv);
            }
        }
        catch (Throwable e) {
            Config.dbg(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public static boolean isMinecraftThread() {
        return Thread.currentThread() == minecraftThread;
    }

    private static void startVersionCheckThread() {
        VersionCheckThread vct = new VersionCheckThread();
        vct.start();
    }

    public static boolean isUseMipmaps() {
        int mipmapLevel = Config.getMipmapLevel();
        return mipmapLevel > 0;
    }

    public static int getMipmapLevel() {
        if (gameSettings == null) {
            return DEF_MIPMAP_LEVEL;
        }
        return Config.gameSettings.ofMipmapLevel;
    }

    public static int getMipmapType() {
        if (gameSettings == null) {
            return DEF_MIPMAP_TYPE;
        }
        switch (Config.gameSettings.ofMipmapType) {
            case 0: {
                return 9984;
            }
            case 1: {
                return 9986;
            }
            case 2: {
                if (Config.isMultiTexture()) {
                    return 9985;
                }
                return 9986;
            }
            case 3: {
                if (Config.isMultiTexture()) {
                    return 9987;
                }
                return 9986;
            }
        }
        return 9984;
    }

    public static boolean isUseAlphaFunc() {
        float alphaFuncLevel = Config.getAlphaFuncLevel();
        return alphaFuncLevel > DEF_ALPHA_FUNC_LEVEL.floatValue() + 1.0E-5f;
    }

    public static float getAlphaFuncLevel() {
        return DEF_ALPHA_FUNC_LEVEL.floatValue();
    }

    public static boolean isFogFancy() {
        if (!Config.isFancyFogAvailable()) {
            return false;
        }
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofFogType == 2;
    }

    public static boolean isFogFast() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofFogType == 1;
    }

    public static boolean isFogOff() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofFogType == 3;
    }

    public static float getFogStart() {
        if (gameSettings == null) {
            return DEF_FOG_START.floatValue();
        }
        return Config.gameSettings.ofFogStart;
    }

    public static boolean isOcclusionEnabled() {
        if (gameSettings == null) {
            return DEF_OCCLUSION_ENABLED;
        }
        return Config.gameSettings.h;
    }

    public static boolean isOcclusionFancy() {
        if (!Config.isOcclusionEnabled()) {
            return false;
        }
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofOcclusionFancy;
    }

    public static boolean isLoadChunksFar() {
        if (gameSettings == null) {
            return DEF_LOAD_CHUNKS_FAR;
        }
        return Config.gameSettings.ofLoadFar;
    }

    public static int getPreloadedChunks() {
        if (gameSettings == null) {
            return DEF_PRELOADED_CHUNKS;
        }
        return Config.gameSettings.ofPreloadedChunks;
    }

    public static void dbg(String s) {
        systemOut.print("[OptiFine] ");
        systemOut.println(s);
    }

    public static void warn(String s) {
        systemOut.print("[OptiFine] [WARN] ");
        systemOut.println(s);
    }

    public static void error(String s) {
        systemOut.print("[OptiFine] [ERROR] ");
        systemOut.println(s);
    }

    public static void log(String s) {
        Config.dbg(s);
    }

    public static int getUpdatesPerFrame() {
        if (gameSettings != null) {
            return Config.gameSettings.ofChunkUpdates;
        }
        return 1;
    }

    public static boolean isDynamicUpdates() {
        if (gameSettings != null) {
            return Config.gameSettings.ofChunkUpdatesDynamic;
        }
        return true;
    }

    public static boolean isRainFancy() {
        if (Config.gameSettings.ofRain == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofRain == 2;
    }

    public static boolean isWaterFancy() {
        if (Config.gameSettings.ofWater == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofWater == 2;
    }

    public static boolean isRainOff() {
        return Config.gameSettings.ofRain == 3;
    }

    public static boolean isCloudsFancy() {
        if (Config.gameSettings.ofClouds != 0) {
            return Config.gameSettings.ofClouds == 2;
        }
        if (texturePackClouds != 0) {
            return texturePackClouds == 2;
        }
        return Config.gameSettings.j;
    }

    public static boolean isCloudsOff() {
        return Config.gameSettings.ofClouds == 3;
    }

    public static void updateTexturePackClouds() {
        texturePackClouds = 0;
        bjp rm = Config.getResourceManager();
        if (rm == null) {
            return;
        }
        try {
            InputStream in = rm.a(new bjo("color.properties")).b();
            if (in == null) {
                return;
            }
            Properties props = new Properties();
            props.load(in);
            in.close();
            String cloudStr = props.getProperty("clouds");
            if (cloudStr == null) {
                return;
            }
            Config.dbg("Texture pack clouds: " + cloudStr);
            cloudStr = cloudStr.toLowerCase();
            if (cloudStr.equals("fast")) {
                texturePackClouds = 1;
            }
            if (cloudStr.equals("fancy")) {
                texturePackClouds = 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isTreesFancy() {
        if (Config.gameSettings.ofTrees == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofTrees == 2;
    }

    public static boolean isGrassFancy() {
        if (Config.gameSettings.ofGrass == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofGrass == 2;
    }

    public static boolean isDroppedItemsFancy() {
        if (Config.gameSettings.ofDroppedItems == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofDroppedItems == 2;
    }

    public static int limit(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static float limit(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static float limitTo1(float val) {
        if (val < 0.0f) {
            return 0.0f;
        }
        if (val > 1.0f) {
            return 1.0f;
        }
        return val;
    }

    public static boolean isAnimatedWater() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedWater != 2;
        }
        return true;
    }

    public static boolean isGeneratedWater() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedWater == 1;
        }
        return true;
    }

    public static boolean isAnimatedPortal() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedPortal;
        }
        return true;
    }

    public static boolean isAnimatedLava() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedLava != 2;
        }
        return true;
    }

    public static boolean isGeneratedLava() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedLava == 1;
        }
        return true;
    }

    public static boolean isAnimatedFire() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedFire;
        }
        return true;
    }

    public static boolean isAnimatedRedstone() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedRedstone;
        }
        return true;
    }

    public static boolean isAnimatedExplosion() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedExplosion;
        }
        return true;
    }

    public static boolean isAnimatedFlame() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedFlame;
        }
        return true;
    }

    public static boolean isAnimatedSmoke() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedSmoke;
        }
        return true;
    }

    public static boolean isVoidParticles() {
        if (gameSettings != null) {
            return Config.gameSettings.ofVoidParticles;
        }
        return true;
    }

    public static boolean isWaterParticles() {
        if (gameSettings != null) {
            return Config.gameSettings.ofWaterParticles;
        }
        return true;
    }

    public static boolean isRainSplash() {
        if (gameSettings != null) {
            return Config.gameSettings.ofRainSplash;
        }
        return true;
    }

    public static boolean isPortalParticles() {
        if (gameSettings != null) {
            return Config.gameSettings.ofPortalParticles;
        }
        return true;
    }

    public static boolean isPotionParticles() {
        if (gameSettings != null) {
            return Config.gameSettings.ofPotionParticles;
        }
        return true;
    }

    public static boolean isDepthFog() {
        if (gameSettings != null) {
            return Config.gameSettings.ofDepthFog;
        }
        return true;
    }

    public static float getAmbientOcclusionLevel() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAoLevel;
        }
        return 0.0f;
    }

    private static Method getMethod(Class cls, String methodName, Object[] params) {
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m2 = methods[i];
            if (!m2.getName().equals(methodName) || m2.getParameterTypes().length != params.length) continue;
            return m2;
        }
        Config.warn("No method found for: " + cls.getName() + "." + methodName + "(" + Config.arrayToString(params) + ")");
        return null;
    }

    public static String arrayToString(Object[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i = 0; i < arr.length; ++i) {
            Object obj = arr[i];
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(String.valueOf(obj));
        }
        return buf.toString();
    }

    public static String arrayToString(int[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i = 0; i < arr.length; ++i) {
            int x = arr[i];
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static atv getMinecraft() {
        return minecraft;
    }

    public static bim getTextureManager() {
        return minecraft.J();
    }

    public static bjp getResourceManager() {
        return minecraft.K();
    }

    public static bjn getResource(bjo location) throws IOException {
        return minecraft.K().a(location);
    }

    public static InputStream getResourceStream(bjo location) throws IOException {
        return Config.getResourceStream(minecraft.K(), location);
    }

    public static InputStream getResourceStream(bjp resourceManager, bjo location) throws IOException {
        bjn res = resourceManager.a(location);
        if (res == null) {
            return null;
        }
        return res.b();
    }

    public static bjn getResource(bjo location, boolean fallback) throws IOException {
        if (!fallback && !Config.getResourcePack().b(location)) {
            return null;
        }
        return minecraft.K().a(location);
    }

    public static boolean hasResource(bjo location) {
        return Config.hasResource(location, true);
    }

    public static boolean hasResource(bjo location, boolean fallback) {
        try {
            bjn res = Config.getResource(location, fallback);
            return res != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean hasResource(bjp resourceManager, bjo location) {
        try {
            bjn res = resourceManager.a(location);
            return res != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static bjr getResourcePack() {
        bjt rep = minecraft.L();
        List entries = rep.c();
        if (entries == null || entries.size() <= 0) {
            return rep.b;
        }
        bjv entry = (bjv)entries.get(0);
        if (entry == null) {
            return rep.b;
        }
        bjr rp = entry.c();
        return rp;
    }

    public static bjr getDefaultResourcePack() {
        return Config.minecraft.L().b;
    }

    public static bfl getRenderGlobal() {
        if (minecraft == null) {
            return null;
        }
        return Config.minecraft.g;
    }

    public static int getMaxDynamicTileWidth() {
        return 64;
    }

    public static ms getSideGrassTexture(acf blockAccess, int x, int y, int z, int side, ms icon) {
        if (!Config.isBetterGrass()) {
            return icon;
        }
        ms fullIcon = TextureUtils.iconGrassTop;
        int destBlockId = 2;
        if (icon == TextureUtils.iconMyceliumSide) {
            fullIcon = TextureUtils.iconMyceliumTop;
            destBlockId = 110;
        }
        if (Config.isBetterGrassFancy()) {
            --y;
            switch (side) {
                case 2: {
                    --z;
                    break;
                }
                case 3: {
                    ++z;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                }
            }
            int blockId = blockAccess.a(x, y, z);
            if (blockId != destBlockId) {
                return icon;
            }
        }
        return fullIcon;
    }

    public static ms getSideSnowGrassTexture(acf blockAccess, int x, int y, int z, int side) {
        if (!Config.isBetterGrass()) {
            return TextureUtils.iconGrassSideSnowed;
        }
        if (Config.isBetterGrassFancy()) {
            switch (side) {
                case 2: {
                    --z;
                    break;
                }
                case 3: {
                    ++z;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                }
            }
            int blockId = blockAccess.a(x, y, z);
            if (blockId != 78 && blockId != 80) {
                return TextureUtils.iconGrassSideSnowed;
            }
        }
        return TextureUtils.iconSnow;
    }

    public static boolean isBetterGrass() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofBetterGrass != 3;
    }

    public static boolean isBetterGrassFancy() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofBetterGrass == 2;
    }

    public static boolean isWeatherEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofWeather;
    }

    public static boolean isSkyEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofSky;
    }

    public static boolean isSunMoonEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofSunMoon;
    }

    public static boolean isStarsEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofStars;
    }

    public static void sleep(long ms2) {
        try {
            Thread.currentThread();
            Thread.sleep(ms2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean isTimeDayOnly() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofTime == 1;
    }

    public static boolean isTimeDefault() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofTime == 0 || Config.gameSettings.ofTime == 2;
    }

    public static boolean isTimeNightOnly() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofTime == 3;
    }

    public static boolean isClearWater() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofClearWater;
    }

    public static int getAnisotropicFilterLevel() {
        if (gameSettings == null) {
            return 1;
        }
        return Config.gameSettings.ofAfLevel;
    }

    public static int getAntialiasingLevel() {
        return antialiasingLevel;
    }

    public static boolean between(int val, int min, int max) {
        return val >= min && val <= max;
    }

    public static boolean isMultiTexture() {
        if (Config.getAnisotropicFilterLevel() > 1) {
            return true;
        }
        return Config.getAntialiasingLevel() > 0;
    }

    public static boolean isDrippingWaterLava() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofDrippingWaterLava;
    }

    public static boolean isBetterSnow() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofBetterSnow;
    }

    public static Dimension getFullscreenDimension() {
        if (desktopDisplayMode == null) {
            return null;
        }
        if (gameSettings == null) {
            return new Dimension(desktopDisplayMode.getWidth(), desktopDisplayMode.getHeight());
        }
        String dimStr = Config.gameSettings.ofFullscreenMode;
        if (dimStr.equals("Default")) {
            return new Dimension(desktopDisplayMode.getWidth(), desktopDisplayMode.getHeight());
        }
        String[] dimStrs = Config.tokenize(dimStr, " x");
        if (dimStrs.length < 2) {
            return new Dimension(desktopDisplayMode.getWidth(), desktopDisplayMode.getHeight());
        }
        return new Dimension(Config.parseInt(dimStrs[0], -1), Config.parseInt(dimStrs[1], -1));
    }

    public static int parseInt(String str, int defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static float parseFloat(String str, float defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static String[] tokenize(String str, String delim) {
        StringTokenizer tok = new StringTokenizer(str, delim);
        ArrayList<String> list = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            list.add(token);
        }
        String[] strs = list.toArray(new String[list.size()]);
        return strs;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktopDisplayMode;
    }

    public static DisplayMode[] getFullscreenDisplayModes() {
        try {
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            ArrayList<DisplayMode> list = new ArrayList<DisplayMode>();
            for (int i = 0; i < modes.length; ++i) {
                DisplayMode dm = modes[i];
                if (desktopDisplayMode != null && (dm.getBitsPerPixel() != desktopDisplayMode.getBitsPerPixel() || dm.getFrequency() != desktopDisplayMode.getFrequency())) continue;
                list.add(dm);
            }
            DisplayMode[] fsModes = list.toArray(new DisplayMode[list.size()]);
            Comparator comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    DisplayMode dm1 = (DisplayMode)o1;
                    DisplayMode dm2 = (DisplayMode)o2;
                    if (dm1.getWidth() != dm2.getWidth()) {
                        return dm2.getWidth() - dm1.getWidth();
                    }
                    if (dm1.getHeight() != dm2.getHeight()) {
                        return dm2.getHeight() - dm1.getHeight();
                    }
                    return 0;
                }
            };
            Arrays.sort(fsModes, comp);
            return fsModes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DisplayMode[]{desktopDisplayMode};
        }
    }

    public static String[] getFullscreenModes() {
        DisplayMode[] modes = Config.getFullscreenDisplayModes();
        String[] names = new String[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            String name;
            DisplayMode mode = modes[i];
            names[i] = name = "" + mode.getWidth() + "x" + mode.getHeight();
        }
        return names;
    }

    public static DisplayMode getDisplayMode(Dimension dim) throws LWJGLException {
        DisplayMode[] modes = Display.getAvailableDisplayModes();
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode dm = modes[i];
            if (dm.getWidth() != dim.width || dm.getHeight() != dim.height || desktopDisplayMode != null && (dm.getBitsPerPixel() != desktopDisplayMode.getBitsPerPixel() || dm.getFrequency() != desktopDisplayMode.getFrequency())) continue;
            return dm;
        }
        return desktopDisplayMode;
    }

    public static boolean isAnimatedTerrain() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedTerrain;
        }
        return true;
    }

    public static boolean isAnimatedItems() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedItems;
        }
        return true;
    }

    public static boolean isAnimatedTextures() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedTextures;
        }
        return true;
    }

    public static boolean isSwampColors() {
        if (gameSettings != null) {
            return Config.gameSettings.ofSwampColors;
        }
        return true;
    }

    public static boolean isRandomMobs() {
        if (gameSettings != null) {
            return Config.gameSettings.ofRandomMobs;
        }
        return true;
    }

    public static void checkGlError(String loc) {
        int i = GL11.glGetError();
        if (i != 0) {
            String text = GLU.gluErrorString((int)i);
            Config.dbg("OpenGlError: " + i + " (" + text + "), at: " + loc);
        }
    }

    public static boolean isSmoothBiomes() {
        if (gameSettings != null) {
            return Config.gameSettings.ofSmoothBiomes;
        }
        return true;
    }

    public static boolean isCustomColors() {
        if (gameSettings != null) {
            return Config.gameSettings.ofCustomColors;
        }
        return true;
    }

    public static boolean isCustomSky() {
        if (gameSettings != null) {
            return Config.gameSettings.ofCustomSky;
        }
        return true;
    }

    public static boolean isCustomFonts() {
        if (gameSettings != null) {
            return Config.gameSettings.ofCustomFonts;
        }
        return true;
    }

    public static boolean isShowCapes() {
        if (gameSettings != null) {
            return Config.gameSettings.ofShowCapes;
        }
        return true;
    }

    public static boolean isConnectedTextures() {
        if (gameSettings != null) {
            return Config.gameSettings.ofConnectedTextures != 3;
        }
        return false;
    }

    public static boolean isNaturalTextures() {
        if (gameSettings != null) {
            return Config.gameSettings.ofNaturalTextures;
        }
        return false;
    }

    public static boolean isConnectedTexturesFancy() {
        if (gameSettings != null) {
            return Config.gameSettings.ofConnectedTextures == 2;
        }
        return false;
    }

    public static String[] readLines(File file) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "ASCII");
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            list.add(line);
        }
        String[] lines = list.toArray(new String[list.size()]);
        return lines;
    }

    public static String readFile(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        return Config.readInputStream(fin, "ASCII");
    }

    public static String readInputStream(InputStream in) throws IOException {
        return Config.readInputStream(in, "ASCII");
    }

    public static String readInputStream(InputStream in, String encoding) throws IOException {
        String line;
        InputStreamReader inr = new InputStreamReader(in, encoding);
        BufferedReader br = new BufferedReader(inr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static aul getGameSettings() {
        return gameSettings;
    }

    public static String getNewRelease() {
        return newRelease;
    }

    public static void setNewRelease(String newRelease) {
        Config.newRelease = newRelease;
    }

    public static int compareRelease(String rel1, String rel2) {
        int rev2;
        String[] rels2;
        String branch2;
        String[] rels1 = Config.splitRelease(rel1);
        String branch1 = rels1[0];
        if (!branch1.equals(branch2 = (rels2 = Config.splitRelease(rel2))[0])) {
            return branch1.compareTo(branch2);
        }
        int rev1 = Config.parseInt(rels1[1], -1);
        if (rev1 != (rev2 = Config.parseInt(rels2[1], -1))) {
            return rev1 - rev2;
        }
        String suf1 = rels1[2];
        String suf2 = rels2[2];
        return suf1.compareTo(suf2);
    }

    private static String[] splitRelease(String relStr) {
        int pos;
        if (relStr == null || relStr.length() <= 0) {
            return new String[]{"", "", ""};
        }
        String branch = relStr.substring(0, 1);
        if (relStr.length() <= 1) {
            return new String[]{branch, "", ""};
        }
        for (pos = 1; pos < relStr.length() && Character.isDigit(relStr.charAt(pos)); ++pos) {
        }
        String revision = relStr.substring(1, pos);
        if (pos >= relStr.length()) {
            return new String[]{branch, revision, ""};
        }
        String suffix = relStr.substring(pos);
        return new String[]{branch, revision, suffix};
    }

    public static int intHash(int x) {
        x = x ^ 0x3D ^ x >> 16;
        x += x << 3;
        x ^= x >> 4;
        x *= 668265261;
        x ^= x >> 15;
        return x;
    }

    public static int getRandom(int x, int y, int z, int face) {
        int rand = Config.intHash(face + 37);
        rand = Config.intHash(rand + x);
        rand = Config.intHash(rand + z);
        rand = Config.intHash(rand + y);
        return rand;
    }

    public static js getWorldServer() {
        if (minecraft == null) {
            return null;
        }
        bdd world = Config.minecraft.f;
        if (world == null) {
            return null;
        }
        bkz is = minecraft.C();
        if (is == null) {
            return null;
        }
        aei wp = world.t;
        if (wp == null) {
            return null;
        }
        int wd = wp.i;
        js ws = is.a(wd);
        return ws;
    }

    public static int getAvailableProcessors() {
        if (availableProcessors < 1) {
            availableProcessors = Runtime.getRuntime().availableProcessors();
        }
        return availableProcessors;
    }

    public static boolean isSingleProcessor() {
        return Config.getAvailableProcessors() <= 1;
    }

    public static boolean isSmoothWorld() {
        if (Config.getAvailableProcessors() > 1) {
            return false;
        }
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofSmoothWorld;
    }

    public static boolean isLazyChunkLoading() {
        if (Config.getAvailableProcessors() > 1) {
            return false;
        }
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofLazyChunkLoading;
    }

    public static int getChunkViewDistance() {
        if (gameSettings == null) {
            return 10;
        }
        int chunkDistance = Config.gameSettings.ofRenderDistanceFine / 16;
        if (chunkDistance <= 16) {
            return 10;
        }
        return chunkDistance;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static void checkDisplaySettings() {
        if (Config.getAntialiasingLevel() > 0) {
            int samples = Config.getAntialiasingLevel();
            DisplayMode displayMode = Display.getDisplayMode();
            Config.dbg("FSAA Samples: " + samples);
            try {
                Display.destroy();
                Display.setDisplayMode((DisplayMode)displayMode);
                Display.create((PixelFormat)new PixelFormat().withDepthBits(24).withSamples(samples));
            }
            catch (LWJGLException e) {
                Config.warn("Error setting FSAA: " + samples + "x");
                e.printStackTrace();
                try {
                    Display.setDisplayMode((DisplayMode)displayMode);
                    Display.create((PixelFormat)new PixelFormat().withDepthBits(24));
                }
                catch (LWJGLException e2) {
                    e2.printStackTrace();
                    try {
                        Display.setDisplayMode((DisplayMode)displayMode);
                        Display.create();
                    }
                    catch (LWJGLException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            if (w.a() != x.d) {
                try {
                    File assetsDir = new File(Config.minecraft.x, "assets");
                    ByteBuffer bufIcon16 = Config.readIconImage(new File(assetsDir, "/icons/icon_16x16.png"));
                    ByteBuffer bufIcon32 = Config.readIconImage(new File(assetsDir, "/icons/icon_32x32.png"));
                    ByteBuffer[] buf = new ByteBuffer[]{bufIcon16, bufIcon32};
                    Display.setIcon((ByteBuffer[])buf);
                }
                catch (IOException e) {
                    Config.dbg(e.getClass().getName() + ": " + e.getMessage());
                }
            }
        }
    }

    private static ByteBuffer readIconImage(File par1File) throws IOException {
        BufferedImage var2 = ImageIO.read(par1File);
        int[] var3 = var2.getRGB(0, 0, var2.getWidth(), var2.getHeight(), null, 0, var2.getWidth());
        ByteBuffer var4 = ByteBuffer.allocate(4 * var3.length);
        int[] var5 = var3;
        int var6 = var3.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            int var8 = var5[var7];
            var4.putInt(var8 << 8 | var8 >> 24 & 0xFF);
        }
        var4.flip();
        return var4;
    }

    public static void checkDisplayMode() {
        try {
            if (minecraft.G()) {
                if (fullscreenModeChecked) {
                    return;
                }
                fullscreenModeChecked = true;
                desktopModeChecked = false;
                DisplayMode mode = Display.getDisplayMode();
                Dimension dim = Config.getFullscreenDimension();
                if (dim == null) {
                    return;
                }
                if (mode.getWidth() == dim.width && mode.getHeight() == dim.height) {
                    return;
                }
                DisplayMode newMode = Config.getDisplayMode(dim);
                if (newMode == null) {
                    return;
                }
                Display.setDisplayModeAndFullscreen((DisplayMode)newMode);
                Config.minecraft.d = Display.getDisplayMode().getWidth();
                Config.minecraft.e = Display.getDisplayMode().getHeight();
                if (Config.minecraft.d <= 0) {
                    Config.minecraft.d = 1;
                }
                if (Config.minecraft.e <= 0) {
                    Config.minecraft.e = 1;
                }
                if (Config.minecraft.n != null) {
                    awf sr = new awf(Config.minecraft.u, Config.minecraft.d, Config.minecraft.e);
                    int sw = sr.a();
                    int sh = sr.b();
                    Config.minecraft.n.a(minecraft, sw, sh);
                }
                Config.minecraft.u.updateVSync();
                Display.update();
                GL11.glEnable((int)3553);
            } else {
                if (desktopModeChecked) {
                    return;
                }
                desktopModeChecked = true;
                fullscreenModeChecked = false;
                Config.minecraft.u.updateVSync();
                Display.update();
                GL11.glEnable((int)3553);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

