/*
 * Decompiled with CFR 0.152.
 */
package omnitools;

import cofh.core.CoFHProps;
import cofh.util.ConfigHandler;
import cofh.util.version.VersionInfo;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import omnitools.block.BlockPlinth;
import omnitools.block.ItemBlockPlinth;
import omnitools.block.TileLexicon;
import omnitools.core.LexiconManager;
import omnitools.core.OTProps;
import omnitools.core.Proxy;
import omnitools.gui.CreativeTabOT;
import omnitools.gui.GuiHandler;
import omnitools.item.ItemArtifact;
import omnitools.item.ItemWrench;

@Mod(name="OmniTools", version="3.1.2.0", useMetadata=false, modid="OmniTools", dependencies="required-after:Forge@[7.7.2.678,);required-after:CoFHCore@[1.5.1.3,);after:*")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class OmniTools {
    @SidedProxy(clientSide="omnitools.core.ProxyClient", serverSide="omnitools.core.Proxy")
    public static Proxy proxy;
    @Mod.Instance(value="OmniTools")
    public static OmniTools instance;
    public static final Logger logOT;
    public static final ConfigHandler config;
    public static final VersionInfo version;
    public static final CreativeTabs tab;
    public static Block blockPlinth;
    public static Item wrench;
    public static Item artifact;
    public static ItemStack plinth;
    public static ItemStack omniwrench;
    public static ItemStack lexicon;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        version.checkForNewVersion();
        File blacklist = new File(event.getModConfigurationDirectory(), "cofh/Lexicon_Blacklist.txt");
        File whitelist = new File(event.getModConfigurationDirectory(), "cofh/Lexicon_Whitelist.txt");
        File oldFile = new File(CoFHProps.configDir, "/cofh/omnitools.cfg");
        if (oldFile.exists()) {
            oldFile.renameTo(new File(CoFHProps.configDir, "/cofh/OmniTools.cfg"));
        }
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/OmniTools.cfg")));
        String category = "general";
        OTProps.enableUpdateNotice = config.get(category, "EnableUpdateNotifications", true);
        config.addBlockEntry("MysticalPlinth");
        config.addItemEntry("OmniWrench");
        config.addItemEntry("Artifact");
        Property listType = config.getProperty(category, "Lexicon.UseWhitelist", true);
        listType.comment = "If this setting is changed to false, a Blacklist model will instead be enforced.";
        LexiconManager.isWhitelist = listType.getBoolean(true);
        Property logEntries = config.getProperty(category, "Lexicon.LogEntries", false);
        logEntries.comment = "Enable this to echo a list of all items on the Lexicon's List to the log during startup.";
        LexiconManager.logEntries = logEntries.getBoolean(false);
        Property defaultWrite = config.getProperty(category, "Lexicon.GenerateDefaultList", true);
        defaultWrite.comment = "This will generate a default List file depending on your list setting. This file will ONLY generate if it does not exist.";
        LexiconManager.writeDefaultFile = defaultWrite.getBoolean(true);
        category = "block.feature";
        BlockPlinth.enable = config.get(category, "MysticalPlinth", true);
        category = "item.feature";
        ItemWrench.enable = config.get(category, "OmniWrench", true);
        ItemWrench.enableIC2Logging = config.get(category, "OmniWrench.EnableIC2Logging", false);
        ItemArtifact.enable[OTProps.Artifacts.LEXICON.ordinal()] = config.get(category, "Artifact.Lexicon", true);
        if (LexiconManager.isWhitelist) {
            LexiconManager.setList(whitelist);
            LexiconManager.addAllListedOres(whitelist);
        } else {
            LexiconManager.setList(blacklist);
            LexiconManager.addAllListedOres(blacklist);
        }
    }

    @Mod.Init
    public void initialize(FMLInitializationEvent event) {
        config.init();
        blockPlinth = new BlockPlinth(config.getBlockId("MysticalPlinth"));
        GameRegistry.registerBlock((Block)blockPlinth, ItemBlockPlinth.class, (String)"MysticalPlinth");
        wrench = new ItemWrench(config.getItemId("OmniWrench"));
        artifact = new ItemArtifact(config.getItemId("Artifact"));
        MinecraftForge.setToolClass((Item)wrench, (String)"crowbar", (int)0);
        GameRegistry.registerTileEntity(TileLexicon.class, (String)"omnitools.Lexicon");
        this.loadItems();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)GuiHandler.instance);
        proxy.registerRenderInformation();
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
        this.loadRecipes();
        LexiconManager.addAllRegisteredOres();
        MinecraftForge.EVENT_BUS.register((Object)LexiconManager.getInstance());
        proxy.registerTickHandlers();
        proxy.registerPacketHandlers();
        config.cleanUp(false);
    }

    void loadItems() {
        plinth = new ItemStack(blockPlinth, 1, 15);
        omniwrench = new ItemStack(wrench, 1, 0);
        lexicon = new ItemStack(artifact, 1, OTProps.Artifacts.LEXICON.ordinal());
    }

    void loadRecipes() {
        if (BlockPlinth.enable) {
            GameRegistry.addRecipe((ItemStack)plinth, (Object[])new Object[]{"GWG", "OOO", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('G'), Item.field_77717_p, Character.valueOf('W'), new ItemStack(Block.field_72101_ab, 1, 9)});
        }
        if (ItemWrench.enable) {
            GameRegistry.addRecipe((ItemStack)omniwrench, (Object[])new Object[]{"D D", " G ", " W ", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('G'), Item.field_77717_p, Character.valueOf('W'), new ItemStack(Block.field_72101_ab, 1, 9)});
        }
        if (ItemArtifact.enable[OTProps.Artifacts.LEXICON.ordinal()]) {
            GameRegistry.addShapelessRecipe((ItemStack)lexicon, (Object[])new Object[]{Item.field_77760_aL, Item.field_77717_p, Item.field_77703_o, new ItemStack(Block.field_72101_ab, 1, 9)});
        }
    }

    static {
        logOT = Logger.getLogger("OmniTools");
        logOT.setParent(FMLLog.getLogger());
        config = new ConfigHandler("3.1.2.0", 2101, 21001);
        version = new VersionInfo("OmniTools", "3.1.2.0", "https://dl.dropboxusercontent.com/u/57416963/Minecraft/Mods/OmniTools/version.txt", logOT);
        tab = new CreativeTabOT();
    }
}

