/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.config.ConfigTag;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.KeyManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.guihook.GuiContainerManager;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class HUDRenderer
implements KeyManager.IKeyStateTracker {
    @Override
    public void tickKeyStates() {
        if (KeyManager.keyStates.get((Object)"world.highlight_tips").down) {
            ConfigTag tag;
            tag.setBooleanValue(!(tag = NEIClientConfig.getSetting("world.highlight_tips")).getBooleanValue());
        }
    }

    public static void renderOverlay() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null && mc.field_71441_e != null && !mc.field_71474_y.field_74321_H.func_151470_d() && NEIClientConfig.getBooleanSetting("world.highlight_tips") && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            WorldClient world = mc.field_71441_e;
            ArrayList<ItemStack> items = ItemInfo.getIdentifierItems((World)world, (EntityPlayer)mc.field_71439_g, mc.field_71476_x);
            if (items.isEmpty()) {
                return;
            }
            int minDamage = Integer.MAX_VALUE;
            ItemStack stack = null;
            for (ItemStack astack : items) {
                if (astack.func_77973_b() == null || astack.func_77960_j() >= minDamage) continue;
                stack = astack;
                minDamage = stack.func_77960_j();
            }
            HUDRenderer.renderOverlay(stack, ItemInfo.getText(stack, (World)world, (EntityPlayer)mc.field_71439_g, mc.field_71476_x), HUDRenderer.getPositioning());
        }
    }

    public static void renderOverlay(ItemStack stack, List<String> textData, Point pos) {
        int w = 0;
        for (String s : textData) {
            w = Math.max(w, GuiDraw.getStringWidth((String)s) + 29);
        }
        int h = Math.max(24, 10 + 10 * textData.size());
        Dimension size = GuiDraw.displaySize();
        int x = (size.width - w - 1) * pos.x / 10000;
        int y = (size.height - h - 1) * pos.y / 10000;
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GuiDraw.drawTooltipBox((int)x, (int)y, (int)w, (int)h);
        int ty = (h - 8 * textData.size()) / 2;
        for (int i = 0; i < textData.size(); ++i) {
            GuiDraw.drawString((String)textData.get(i), (int)(x + 24), (int)(y + ty + 10 * i), (int)-6250336, (boolean)true);
        }
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        if (stack.func_77973_b() != null) {
            GuiContainerManager.drawItem(x + 5, y + h / 2 - 8, stack);
        }
    }

    private static Point getPositioning() {
        return new Point(NEIClientConfig.getSetting("world.highlight_tips.x").getIntValue(), NEIClientConfig.getSetting("world.highlight_tips.y").getIntValue());
    }

    public static void load() {
        KeyManager.trackers.add(new HUDRenderer());
    }
}

