/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.math.MathHelper;
import codechicken.nei.ItemSorter;
import codechicken.nei.LayoutManager;
import codechicken.nei.config.GuiOptionPane;
import codechicken.nei.config.Option;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;

public class GuiItemSorter
extends GuiOptionPane {
    public Option opt;
    public List<SortItem> slots = new ArrayList<SortItem>();
    boolean dragging;
    public SortItem dragged;
    public int mouseclickedy;
    public double dragstarty;

    public GuiItemSorter(Option opt) {
        this.opt = opt;
        for (ItemSorter.SortEntry e : ItemSorter.list) {
            this.slots.add(new SortItem(e));
        }
    }

    public int slotY(int slot) {
        return 2 + slot * 24;
    }

    @Override
    public int contentHeight() {
        return ItemSorter.list.size() * 24;
    }

    @Override
    public void drawContent(int mx, int my, float frame) {
        Rectangle w = this.drawBounds();
        for (SortItem item : this.slots) {
            if (item == this.dragged) continue;
            this.drawItem(w, item, mx, my, frame);
        }
        if (this.dragged != null) {
            this.drawItem(w, this.dragged, mx, my, frame);
        }
    }

    public void drawItem(Rectangle w, SortItem item, int mx, int my, float frame) {
        double y = MathHelper.interpolate((double)item.ya, (double)item.y, (double)frame);
        GL11.glTranslated((double)0.0, (double)y, (double)0.0);
        Rectangle b = new Rectangle(w.x, w.y, w.width, 20);
        boolean mouseOver = this.itemAt(w.x + mx, w.y + my) == item;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        LayoutManager.drawButtonBackground(b.x, b.y, b.width, b.height, true, mouseOver ? 2 : 1);
        GuiDraw.drawStringC((String)item.e.getLocalisedName(), (int)b.x, (int)b.y, (int)b.width, (int)b.height, (int)(mouseOver ? -96 : -2039584));
        GL11.glTranslated((double)0.0, (double)(-y), (double)0.0);
    }

    @Override
    public String getTitle() {
        return this.opt.translateN(this.opt.name, new Object[0]);
    }

    @Override
    public GuiScreen getParentScreen() {
        return this.opt.slot.getGui();
    }

    public void func_73876_c() {
        int nslot;
        super.func_73876_c();
        int my = GuiDraw.getMousePosition().y;
        for (SortItem item : this.slots) {
            item.update(my);
        }
        if (this.dragging && (nslot = (int)MathHelper.clip((double)((this.dragged.y - -10.0) / 24.0), (double)0.0, (double)(this.slots.size() - 1))) != ItemSorter.list.indexOf(this.dragged.e)) {
            ArrayList<ItemSorter.SortEntry> list = new ArrayList<ItemSorter.SortEntry>(ItemSorter.list);
            list.remove(this.dragged.e);
            list.add(nslot, this.dragged.e);
            ItemSorter.list = list;
            this.opt.getTag().setValue(ItemSorter.getSaveString());
        }
    }

    public SortItem itemAt(int mx, int my) {
        if (!this.pane.windowBounds().contains(mx, my)) {
            return null;
        }
        if (this.dragged != null && this.dragged.contains(my)) {
            return this.dragged;
        }
        for (SortItem item : this.slots) {
            if (!item.contains(my)) continue;
            return item;
        }
        return null;
    }

    protected void func_73864_a(int x, int y, int button) {
        SortItem item;
        super.func_73864_a(x, y, button);
        if (!this.dragging && button == 0 && (item = this.itemAt(x, y)) != null) {
            this.dragging = true;
            this.dragged = item;
            this.mouseclickedy = y;
            this.dragstarty = item.y;
        }
    }

    protected void func_146286_b(int x, int y, int button) {
        if (button == 0) {
            this.dragging = false;
        }
    }

    @Override
    public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
        SortItem item;
        if (!this.dragging && (item = this.itemAt(mx, my)) != null && item.e.getTooltip() != null) {
            tooltip.add(item.e.getTooltip());
        }
        return tooltip;
    }

    public class SortItem {
        public double ya;
        public double y;
        public ItemSorter.SortEntry e;

        public SortItem(ItemSorter.SortEntry e) {
            this.e = e;
            this.y = this.slotY();
        }

        public int slotY() {
            return GuiItemSorter.this.slotY(ItemSorter.list.indexOf(this.e));
        }

        public void update(int my) {
            this.ya = this.y;
            this.y = GuiItemSorter.this.dragging && this == GuiItemSorter.this.dragged ? GuiItemSorter.this.dragstarty + (double)my - (double)GuiItemSorter.this.mouseclickedy : MathHelper.approachExp((double)this.y, (double)this.slotY(), (double)0.4, (double)20.0);
        }

        public boolean contains(int my) {
            return (double)(my -= GuiItemSorter.this.drawBounds().y) >= this.y && (double)my < this.y + 20.0;
        }
    }
}

